/*
 *  Masks for ps (first half of psw)
 */

#define TRANS  #04000000
#define ALLINT #03000000
#define IOINT  #02000000
#define EXTINT #01000000
#define KEY    074000000
#define UMODE  0200000

#define PGSIZE  4096
#define PGMASK	07777
#define PTRADDR 0177760
#define PTINVAL 010
#define PTUSER  1
#define PTINIT #00080008
#define SGNPAG  16
#define SGNFLG  1 /* SGNPAG / 16 */
#define SGLEN   036000000000
#define SGPTA   077777770
#define SGINVAL 1
#define CLOCK   80
#define INTERVAL 02400
#define TWOPOW24 16777216

/*
 * for those of us who like (need) to use IBM's numbering convention
 * the the bytes in a word
 */
struct {
	char	byte0;
	char	byte1;
	char	byte2;
	char	byte3;
};

/*
 * Hardware address for i/o
 */
#define	CSW	64
#define IOADDR	186	/* #b8	*/
/*
 * bits in the channel status word
 */

#define	ATTENTION	#80
#define	STATMOD	#40
#define	CUEND	#20
#define	BUSY	#10
#define	CHEND	#08
#define	DEVEND	#04
#define	UNITCHEK #02
#define UNITEXCP #01
#define PCI	 #80
#define INTREQ	 #40
#define TIMEOUT	 #01

/*
 * Structure to pull CSW apart
 */
struct {
	char	key_flag;
	char	ccwadr1,ccwadr2,ccwadr3;
	char	unitstat;
	char	chanstat;
	char	resid1,resid2;
};

/* User controlled bits in the PSW */
#define	PSMASK	#00003700
#define	PCMASK	#00ffffff
