#



 /* text deck to unix 370 a.out format conversion program */


 /* symbol types (a.out) */
#define	TEXT	1
#define	DATA	2
#define	BSS	3
#define	ABS	4
#define	PSREG	5
#define	WEXTERN	010
#define	SEXTERN	011
#define	COMMON	012
#define	EXTDISP	014	/* external displacement - not yet implemented */
#define	EXT	0	/* rld only */
#define	NONPROC	0100	/* temporary flag - never seen in file */
#define	UNSPEC	0	/* temp flag - means segment type still unknown */

/* esd symbol types (text) */
#define	SD	0
#define	LD	01
#define	ER	02
#define	LR	03
#define	PC	04
#define	CM	05
#define	PR	06
#define	WX	10 /* x'0a' */

#define	NSYM	200
#define	NRLD	400
#define	NSECT	20


#define	ASCIIC	0103
#define	ASCSPACE	040

char esym[]	{02, 0342, 0350, 0324};
char eesd[]	{02, 0305, 0342, 0304};
char etxt[]	{02, 0343, 0347, 0343};
char erld[]	{02, 0331, 0323, 0304};
char eend[]	{02, 0305, 0325, 0304};

char buf[80];
int id, od, td;
int rldr, rldp;

char magcon[]	{0107, 0360, 0, 040};

char zeroes[80];

struct esd {
	char name[8];
	char type;
	char addr[1]; char addr1; char addr2;
	char align;
	char length[1]; char length1; char length2;
	int newaddr;
} *stab, *si, *lsi, *si2;

struct idtab {
	struct esd *stp;
	int textp;
} idtab[NSYM], *ii, *lii;

struct rld {
	char flag;
	char loc[1]; char loc1; char loc2;
	char sym[2];
} *rldtab;
char *ri;
struct { char ch;};

int text, data, bss;

struct {
	char magic[4];
	char text[4];
	char data[4];
	char bss[4];
	char hrld[4];
	char est[2];
	char lst[1]; char lst1;
	char free[8];
} header;

struct textab {
	int tlen;
	int tpnt;
	int taddr;
} textab[NSECT];

char ttab[]	{ 0, 0, SEXTERN, 0, 0, COMMON, PSREG, 0, 0, 0, WEXTERN};


main(argc,argv)
char **argv;
{
	register n;
	register char *p;
	int a;
	int diff;
	struct esd *tsi;
	register c;

	if(argc != 3) {
		printf("Argc count!\n");
		cexit(1);
	}

	rldtab = calloc(NRLD, sizeof(*rldtab));
	clear(rldtab, NRLD*sizeof(*rldtab));
	stab = calloc(NSYM, sizeof(*stab));
	clear(stab, NSYM*sizeof(*stab));

	id = copen(argv[1],'r');
	od = copen(argv[2], 'w');

 /*	td = uopen("temp linktemp"); */

	if(uread(id, buf, 80) <= 0) {
 /*
		printf("no xxx text\n");
		cexit(4);
 */
	}

	if(buf[0] != 02) {
		printf("not a text file\n");
		cexit(5);
	}

	while(cmp(buf,esym,4)) {
		buf[0]=0;
		uread(id, buf, 80);
	}

	ii = idtab;
	si = stab;

	while(cmp(buf, eesd, 4)) {
		n = out2(&buf[10]) + 16;
		for(p = &buf[16]; p < &buf[n]; p =+ 16) {
			pesd(p);
		}
		buf[0] = 0;
		uread(id, buf, 80);
	}

	lsi = si;
	lii = ii;
	while(cmp(buf,etxt,4)) {
		ii = &idtab[out2(&buf[14])-1];
		n = out2(&buf[10]);
		si = ii->stp;
		a = out3(&buf[5]) - out3(si->addr);
		if(a<0 || a+n > out3(si->length)) {
			printf("bad format text card\n");
 pcard();
			cexit(7);
		}
		move(&buf[16], ii->textp+a, n);
		if( /* cmp(&buf[16], zeroes, n) == 0 && */
			si->type == (BSS|NONPROC))
			si->type = DATA|NONPROC;
		buf[0] = 0;
		uread(id, buf, 80);
	}

	text = data = bss = 0;
	for(si = stab; si < lsi; si++) {
		if(si->type&NONPROC) {
			switch(si->type =& ~NONPROC) {

			case ABS:
				si->newaddr = out3(si->addr);
				break;
			case TEXT:
				rtext(si);
				break;

			case DATA:
				rdata(si);
				break;

			case BSS:
				rbss(si);
				break;

			case UNSPEC:
				si->type=(tsi=idtab[out3(si->length)-1].stp)->type& ~NONPROC;
				if(tsi->type&NONPROC) {
					switch(tsi->type =& ~NONPROC) {

					case TEXT:
						rtext(tsi);
						break;

					case DATA:
						rdata(tsi);
						break;

					case BSS:
						rbss(tsi);
					}
				}
				si->newaddr = tsi->newaddr + out3(si->addr)
					- out3(tsi->addr);
			} /* end of switch */
		}
	} /* end of for */

	data =+ text;
	bss =+ data;
	for(si = stab; si<lsi; si++) {
		if(si->type == DATA) si->newaddr =+ text;
		else if(si->type == BSS) si->newaddr =+ data;

	}

	ri = rldtab;

	while(cmp(buf,erld,4)) {
		rldr = rldp = 0;
		n = out2(&buf[10]) + 16;
		for(p = &buf[16]; p<&buf[n]; p=+ 4) {
			if(rldr == 0) {
				rldr = out2(p);
				rldp = out2(p+2);
				p =+ 4;
			}
			c = *p & 077;
			si2 = idtab[rldp-1].stp;
			if((si = idtab[rldr-1].stp)->type < PSREG) {
					/* not undefined */
				diff = si->newaddr-out3(si->addr);
				genrld((si->type&3)|(c&014)|((c&02)<<3),
					si2->newaddr+out3(p+1) - out3(si2->addr));
				if(c&060) diff=+ out3(si->addr);/*branch type*/
 printf("c=%o,diff=%x,sinew=%x,si2new=%x,coff=%x\n",c,diff,si->newaddr,si2->newaddr,out3(p+1));
				if(diff) {
					if(c&02) /* relocation direction */
						diff = -diff;
					addn(idtab[rldp-1].textp+out3(p+1),diff,c&014);
				}
			} else {
				genrld((c&014)|((c&02)<<3), si2->newaddr+out3(p+1)-out3(si2->addr), si - stab);
			}
			if((c&01) == 0) rldr = 0;
		}
		buf[0] = 0;
		uread(id,buf,80);
	}

	if(!cmp(buf,eend,4)) {
		printf("bad format text deck\n");
 pcard();
		cexit(7);
	}

	dumpit();
	cexit(0);
}

cmp(a,b,n)
char *a, *b;
{
	while(n--)
		if(*a++ != *b++) return(0);
	return(1);
}

pesd(p)
struct esd *p;
{
	int last;
	extern char etatab[];
	register i,c;
	last = 0;
	for(i=0; i<8; i++) {
		c = etatab[p->name[i]&0377];
		if(c == ASCSPACE) {
			c = 0;
			if(last == 0)
				last = si->name[i-1];
		}
		si->name[i] = c;
	}
	if(last == 0)
		last = si->name[7];
	move(p->addr, si->addr, 7);
	switch(p->type) {

	case WX:
	case PR:
	case ER:
	case CM:
		si->type = ttab[p->type];
	idd:
		ii++->stp = si;
		break;

	case SD:
	case PC:
		i = out3(si->length) +7 & ~7;
		in3(si->length,i);
		if(i== 0) {
 /*			printf("defered length csect not supported\n"); */
			/* zero length csect assumed - if this is incorrect
			diagnostic will be generated when we
			try to read text into it */
		} else {
			ii->textp = calloc(i,1);
			clear(ii->textp, i);
		}
		if(last == ASCIIC)
			i = TEXT | NONPROC;
		else
			i = BSS | NONPROC; /* will be turned into data if nonzero text exists */
		si->type = i;
		goto idd;

	case LR:
		ii++->stp = si;

	case LD:
		si->type = UNSPEC | NONPROC;
	}
	si++;
}

rtext(asi)
{
	asi->newaddr = text;
	text =+ out3(asi->length) + 7;
	text =& ~7;
}

rdata(asi)
{
	asi->newaddr = data;
	data =+ out3(asi->length) + 7;
	data =& ~7;
}

rbss(asi)
{
	asi->newaddr = bss;
	bss =+ out3(asi->length) + 7;
	bss =& ~7;
}

addn(loc, offset, length)
{
	switch(length) {

	case 04:
		return(in2(loc, out2(loc) + offset));

	case 010:
		return(in3(loc, out3(loc) + offset));
	}
	return(in4(loc, out4(loc) + offset));
}


clear(a,i)
char *a;
{
	while(i--) *a++ = 0;
}

genrld(flags, loc, sym /* optional */)
{
	*ri = flags;
	in3(ri + 1, loc);
	ri =+ 4;
	if((flags&03) == 0) {
		in2(ri, sym);
		ri =+ 2;
	}
}

dumpit()
{
	move(magcon, header.magic, 4);
	in4(header.text, text);
	in4(header.data, data-text);
	in4(header.bss, bss- data);
	in4(header.hrld, ri - &(rldtab->ch));
	in2(header.est, (lsi - stab)*12);
	uwrite(od, &header, 32);
	writx(TEXT);
	writx(DATA);
	uwrite(od, rldtab, ri - &(rldtab->ch));
	for(si = stab; si<lsi; si++) {
		in3(si->addr, si->newaddr);
		uwrite(od, si, 12);
	}
	uclose(od);
}

writx(type)
{
	int a;
	register struct textab *ti, *ti1;
	register tem;
	struct textab *lti;

	ti = textab;
	for(ii = idtab; ii<lii; ii++){
		if(ii->textp && (si=ii->stp)->type == type) {
			ti->tlen = out3(si->length);
			ti->tpnt = ii->textp;
			ti++->taddr = si->newaddr;
		}
	}

	lti = ti;
	/* bubble sort */
	for(ti1 = lti - 1; ti1> &textab[0]; ti1--) {
		for(ti = textab; ti<ti1; ti++) {
			if(ti->taddr > (ti+1)->taddr) {
				tem = ti->taddr;
				ti->taddr = (ti+1)->taddr;
				(ti+1)->taddr = tem;
				tem = ti->tpnt;
				ti->tpnt = (ti+1)->tpnt;
				(ti+1)->tpnt = tem;
				tem = ti->tlen;
				ti->tlen = (ti+1)->tlen;
				(ti+1)->tlen = tem;
			}
		}
	}
	a = textab[0].taddr;
	for(ti = textab; ti<lti; ti++) {
		uwrite(od, ti->tpnt, ti->tlen);
		if(a != ti->taddr) {
			printf("writx length error\n");
 pcard();
		}
		a =+ ti->tlen;
	}
}


pcard()
{
	register char *p;
	register j;
	register i;
	for(p = buf; p<&buf[80];) {
		for(i=0; i<5; i++) {
			for(j=0;j<4;j++) 
				printf("%02x",*p++ & 0377);
			printf("  ");
		}
		printf("\n");
	}
 /*abort(); */
}
#ifndef unix
#include	"iutil.c"
#endif
#ifdef unix
#include	"uutil.c"
#endif
#include	"uio.c"
