#
/*
	some general table writing rules

	X specifies that the result may come back in other than
		the requested register (incl reg. 0 );
	R1 should not be used after X is
	(R) should not be used after X is
	In particular, FX* and FS* should be used very cautiously,
		since they tend to imply #1(R), or similar

	* always skips the constant in a *(e+c) situation
		#1 or #2 should always be used in this case!
	*/
/*

	    	C compiler    (file - c10.c)

	Copyright 1972 Bell Telephone Laboratories, Inc.

*/

#include "c0h.c"

int hdebug 0;


char	maprel[] {	EQUAL, NEQUAL, GREATEQ, GREAT, LESSEQ,
			LESS, GREATP, GREATQP, LESSP, LESSEQP
};

char	notrel[] {	NEQUAL, EQUAL, GREAT, GREATEQ, LESS,
			LESSEQ, GREATQP, GREATP, LESSEQP, LESSP
};

int	nreg	7;
int	flreg	0;
int	*treebase;
extern	char	etoa[];

char *match(atree, table, nrleft)
struct tnode *atree;
struct table *table;
{
	int op, d1, d2, t1, t2, dope,i;
	struct tnode *p2;
	register struct tnode *p1, *tree;
	register struct optab *opt;

	if ((tree=atree)==0)
		return(0);
	op = tree->op;
	dope = opdope[op];
	if (isfloat(tree))
		if (op == MOD || op == ASMOD)
			return(0);
	if ((dope&LEAF) == 0)
		p1 = tree->tr1;
	else
		p1 = tree;
	t1 = p1->type;
	d1 = dcalc(p1, nrleft);
	if (hdebug>100) printf("d1=%d\n",d1);
	if ((dope&BINARY)!=0) {
		p2 = tree->tr2;
		t2 = p2->type;
		d2 = dcalc(p2, nrleft);
		if( hdebug>100) printf( "d2=%d\n", d2 );
	}
	for (; table->op!=op; table++)
		if (table->op==0)
			return(0);
	if (hdebug>100) printf("table->tabop=%d\n",table->op);
	for (opt = table->tabp; opt->tabdeg1!=0; opt++) {
		if (hdebug>100) printf("opt->tabdeg1=%d\n",opt->tabdeg1);
		if (opt->tabdeg1 >= 0100) {
			if (p1->op != STAR) {
				if (hdebug > 100) printf("p1->op=%d\n");
				continue;
			}
			/* else p1->op == STAR */
			if ((i=dcalc(p1->tr1,nrleft)) > (opt->tabdeg1&077)) {
				if (hdebug > 100) printf("dcalc(p1->tr1)=%d, opt->tabdeg1&077=%d\n",
				  i,(opt->tabdeg1&077));
				continue;
			}
		}
		if (d1 > opt->tabdeg1)
			continue;
		if (i=notcompat(p1, opt->tabtyp1)) {
			if (hdebug>100) printf("notcompat=%d\n",i);
			continue;
		}
		if ((opdope[op]&BINARY)!=0 && p2!=0) {
			if (d2 > (opt->tabdeg2&077)
			 || (opt->tabdeg2 >= 0100) && (p2->op != STAR) )
			{if (hdebug > 100) printf("opt->tabdeg2=%d,p2->op=%d\n",opt->tabdeg2, p2->op);
				continue;
			}
			if (i=notcompat(p2,opt->tabtyp2)) {
				if( hdebug>100 ) printf("notcompat2=%d\n", i);
				continue;
			}
		}
		while (opt->tabstring == 0)  opt++;
		return(opt);
	}
	return(0);
}

rcexpr(atree, atable, reg)
struct tnode *atree;
struct table *atable;
{
	register r;
	register struct tnode *tree;
	register struct table *table;

	/* I assert that rcexpr should never be asked to
	   compile anything into registers 0 or 1 */

	if( reg < lowreg || reg>7 ){
		error( "rcexper register error" );
		return(lowreg);
		}

	table = atable;
	if((tree=atree)==0)
		return(99);
	switch (tree->op)  {

	case CBRANCH:
		cbranch(tree->btree, tree->lbl, tree->cond, lowreg);
		return(99);

	case INIT:
		if (tree->tr1->op == AMPER)
			tree->tr1 = tree->tr1->tr1;
		if (tree->tr1->op!=NAME && tree->tr1->op!=CON)
			error("Illegal initialization");
		else{
			cexpr(tree, regtab, nreg);
		}
		return(99);

	case INIB:
		cexpr(tree, regtab, nreg);
		return(99);

	case EXCLA:
		if ((opdope[tree->tr1->op] & RELAT) != 0) {
			tree = tree->tr1;
			tree->op = notrel[tree->op - EQUAL];
		}
		break;

	case RFORCE:
		if((r=rcexpr(tree->tr1, table, reg)) != 0)
			printf("	lr	0,%d\n", r);
		return(0);

	case TIMES:
	case ASTIMES:
		pow2(tree);
	}
	if ((r=cexpr(tree, table, reg))>=0) {
		return(r);
	}
	if (table!=regtab)
		if((r=cexpr(tree, regtab, reg))>=0) {
			if (table==cctab) {
				printf("	ltr	%d,%d\n", r, r);
			}
			return(99);
		}
	error("No match for op %d", tree->op);
	return(lowreg);
}

# define SHARP 1
# define STAROP 2

cexpr(atree, table, areg)	/*  Compile an expression.  */
struct tnode *atree;
struct table *table;
{
	int c, r;
	int tstat;  /* status check for * and # operators */
	register struct tnode *p, *p1, *tree;
	struct tnode *p2;
	char *string;
	int reg, reg1, rreg;
	char *opt;
	int tempoff;
	char cr;

	/* I assert that reg is always between 2 and 9 */
	/* the return value of this function is always
	   -1, which means can7t be done
	    0, which means result in register 0
	    value is  result register, >= reg >= 2
	   1 is never a legal return value

	   The registers r satisfying 2<=r<reg are
	to be unchanged by any of these sequences */

	/* some general philosophy
		reg is always set equal to the register where the result is expected.
		reg1 is usually reg+1; sometimes larger, in the event of * / or %
		ordinarily, the results of operands are forced into registers >= 2
		X is used if the result could come back into register 0
		Register 1 can be freely used at all times by the code sequences

		*/

	if( areg < lowreg || areg > 7 ){
		if (hdebug > 50) printf(2,"lowreg=%d, areg=%d\n", lowreg, areg);
		error( "cexpr register error" );
		return( lowreg );
		}

	tstat = 0;
	tree = atree;
	reg = areg;
	p1 = tree->tr2;
	if ((c = tree->op)==CALL) {
		/* beware: comarg doesn't know about reg... */
		if (tree->tr1->op == STAR)
			tree->tr1 = tree->tr1->tr1;		
		else  error("Compiler ftn call error");
		if(tree->tr1->class == FORTRAN) ftern=YES;
		else ftern = NO;
		fflg = (fflg<<1) + ftern;
		r = 0;
		if(p1->op) {
			while (p1->op==COMMA) {
				r =+ comarg(p1->tr1);
				p1 = p1->tr2;
			}
			r =+ comarg(p1);
		}
		tree->op = MCALL;	/* MCALL is a CALL with arguements already taken care of.  */
		tree->degree = r;	/* save arg length */
		fflg = fflg>>1;
	}
	if ((opdope[c]&RELAT||c==LOGAND||c==LOGOR||c==EXCLA) && table!=cctab) {
		cbranch(tree, c=isn++, 1, reg);
		rcexpr(&czero, table, reg);
		branch(isn);
		label(c);
		rcexpr(&cone, table, reg);
		label(isn++);
		return(reg);
	}
	if(c==QUEST) {
		if (table==cctab)
			return(-1);
		cbranch(tree->tr1, c=isn1++, 0, reg);
		rreg = rcexpr(p1->tr1, table, reg);
		branch(r=isn1++);
		label(c);
		reg = rcexpr(p1->tr2, table, reg);
		if (rreg!=reg)
			printf("	lr	%d,%d\n", rreg, reg);
		reg = rreg;
		label(r);
		goto retrn;
	}
	reg = oddreg(tree, reg);
	reg1 = reg+1;
	if (chkleaf(tree, table, reg) >= 0)
		goto retrn;
	if ((opt=match(tree, table, nreg-reg))==0)
		return(-1);
	string = opt->tabstring;
	p1 = tree->tr1;
	p2 = 0;
	if (opdope[tree->op] & BINARY)
		p2 = tree->tr2;

loop:
	switch(c = *string++) {

	case '\0':
		if (tree->op==MCALL) {
			if(tree->tr1->class==FORTRAN) ftern = YES;
			else ftern = NO;
			if (ftern==YES) {
				printf("	mvi	%d(HGARGP),x'80'\n",hgoffs-hgintsz);
				printf("	la	1,%d(HGARGP)\n",hgoffs-tree->degree);
				printf("	la	HGARGP,%d(HGARGP)\n",hgoffs);
				printf("	FCALL\n");
				printf("	s	HGARGP,=f'%d'\n",hgoffs);
				}
			else
				{
				printf("	la	1,%d\n",tree->degree);
				if (hgoffs - tree->degree)
					printf("	la	HGARGP,%d(HGARGP)\n",hgoffs-tree->degree);
				printf("	BCALL\n");
				if (hgoffs - tree->degree)
					printf("	s	HGARGP,=f'%d'\n",hgoffs-tree->degree);
				}
			hgoffs =- tree->degree;
			reg = 0;
		}
retrn:
		if( tstat != 0 && tstat != (SHARP+STAROP) )error( "compiler error; star without sharp" );

		if (!isfloat(tree))
			if (tree->op==DIVIDE || tree->op==ASDIV)
				reg++;
		if (tree->type == FLOAT || tree->type == DOUBLE)
			return(0);
		return(reg);

	/* A1 and A2 */
	case 'A':
		if (*string++ == '1') p=p1;
		else p=p2;
		pname(p);
		goto loop;

	/* B1 B2 or BF */
	case 'B':

		switch (*string++) {

		case 'F':
			p=tree;
			if (isfloat(p))
				putchar('d');
			goto loop;

		case '1':
		case '2':
			if (((opdope[tree->op]&LEAF) != 0 )
			  || (tree->op == STAR))
				p=tree;
			else
				if (*(string-1) == '1')
					p=p1;
				else
					p=p2;
		}

		if (p->type == CHAR)
			putchar('c');
		if (cr=isfloat(p))
			putchar(cr);
		goto loop;

	/* C1 or C2 */
	case 'C':
		if (*string++ == '1')
			p=p1->tr1;
		else
			p=p2->tr1;
		printf("%d",p);
		goto loop;

	/* F or FR */
	case 'F':
		if (*string != 'R') {
			p=p1;
			goto subtre;
		}
		else {
			string++;
			goto breg;
		}

	case 'S':
		p=p2;
		goto subtre;

	case 'H':
		p=tree;

subtre:

		c=((*string++)-'0')*8+((*string++)-'0');

		if (c&01) {	/* star operator */
			if (p->op != STAR)
				error("compiler error; bad star entry");
			p=p->tr1;
			tstat =| STAROP;
			if (collcon(p))
				p = p->tr1;
		}
		if( c&02 ){ /* FS or SS or FS* or SS* */
			/* compile, then simulate a store to temp */
			/* this should appear before any other forms of F or S
			/* except other FS or SS forms */

			/* This is legal only in the forms FS, SS, FS*, and SS* */

			rreg = rcexpr( p, regtab, areg );

			tempoff = autolen;
			autolen =+ 4;
			if( isfloat(p) ){
				autolen =+ 4;
				/* floating point store here */
				printf( "\tstd\t%d,%d(HGAUTOP)\ttemp\n", flreg, tempoff );
				}
			else {
				printf( "\tst\t%d,%d(HGAUTOP)\ttemp\n", rreg, tempoff );
				}
			goto loop;
			}
		if (c&010){	/*  F2 or S2  */
			r = reg1 + 1;
			goto csubtre;
		}
		if (c&4)	/*  F1 or S1  */
			r = reg1;
		else
			if( c & 020 ) r = areg;  /* we don't really care ! */
			else r = reg;

csubtre:

		rreg = rcexpr(p, regtab, r);
		if (c & 010) {
			if (rreg != r) {
				printf("	lr	%d,%d\n", r, rreg);
				if (hdebug > 100) printf("010 matches\n");
			}
			goto loop;
		}
		if (c&4)
			reg1 = rreg;
		else
			if (rreg != reg)
				if (c&020) {
				/* we assert (through the X mechanism) that
				   we are prepared to live with the result in
				   a place where we did not expect it */
				/* warning!  don't use with mult, div, etc. */
					reg = rreg;
				/*  reg1 should never be used if this is done */
					reg1 = 99;
				}
				else {
					if (tree->type != FLOAT && tree->type != DOUBLE)
					printf("	lr	%d,%d\n", reg, rreg);
					if (hdebug > 100) printf("020 not recognized\n");
				}
		goto loop;

	/* Z */
	case 'Z':


		if(isfloat(p))

breg:

		{	r=flreg;
			if (*string == '2') {
				r =+ 2;
				string++;
			}
			goto preg;
		}

	/* R */
	case 'R':

		switch (*string++) {

		case '-':
			r=reg-1;
			goto preg;

		case '+':
			r=reg+1;
			goto preg;

		case '1':
			r=reg1;
			goto preg;

		case '2':
			r=reg+2;
			string++;
			goto preg;

		default:
			r=reg;
			string--;

preg:

			if (r>nreg)
				error("Register overflow: simplify expression");
			printf("%d",r);
			goto loop;
		}			/* end case R */

	/* #1 or #2 */
	case '#':
		if ((*string++) == '1')
			p=p1->tr1;
		else
			p=p2->tr1;
		goto nmbr;

	case '~':
			p=p1;

nmbr:

			tstat =| SHARP;
			if (collcon(p))
				printf("%d", p->tr2->value);
			else
				printf("0");
			goto loop;

	/* Q */
	case 'Q':
		p = p1->tr1;
		printf("%x", p);
		goto loop;

	/* O */
	case 'O':
		wexpr(tree->op<50?tree->op:tree->op-30,tree);
		goto loop;

	/* T */
	case 'T':
		printf("%d(HGAUTOP)	temp", tempoff);
		goto loop;

	}
	putchar(c);
	goto loop;
}

wexpr(operator,tree) /* part of cexpr moved to here because cexpr got to big */
struct tnode *tree;
int operator;
{	
	switch(operator) {
		case INCAFT:
		case PLUS:
			printf("a");
			break;
		case DECAFT:
		case MINUS:
			printf("s");
			break;
		case AND:
			printf("n");
			break;
		case OR:
			printf("o");
			break;
		case EXOR:
			printf("x");
			break;
		default:
			error("No match - binary op %d", tree->op);
		}
}

chkleaf(atree, table, reg)
struct tnode *atree;
{
	struct tnode lbuf;
	register struct tnode *tree;

	tree = atree;
	if (dcalc(tree, nreg-reg) > 12)
		return(-1);
	lbuf.op = LOAD;
	lbuf.type = tree->type;
	lbuf.degree = tree->degree;
	lbuf.tr1 = tree;
	return(cexpr(&lbuf, table, reg));
}

comarg(atree)	/*  Compile an argument for a function call.  */
{
	register struct tnode *tree;
	int r,t,l;

	tree = atree;
	t = isfloat(tree);
	if (tree->type==STRUCT)
		error("Illegal structure");
	r = rcexpr(tree, regtab, lowreg);
	ftern = fflg & 1;
	if(ftern) {
		if (t) {
			printf("	std	%d",flreg);
			l=hgfloatsz;
		}
		else {
			printf("	st	%d",r);
			l=hgintsz;
		}
		printf(",%d(HGAUTOP)	conv args to ptrs for fortran\n",autolen);
		printf("	la	%d,%d(HGAUTOP)\n",r,autolen);
		autolen =+ l;
	}
	if((t) && (!ftern)) {
		printf("	std	%d,%d(HGARGP)\n", flreg, hgoffs);
		hgoffs =+ hgfloatsz;
		l=hgfloatsz;
	}
	else {
		printf("	st	%d,%d(HGARGP)\n",r, hgoffs);
		hgoffs =+ hgintsz;
		l=hgintsz;
	}
	return(l);
}

