#
/*
 *  C compiler
 */

#include "c0h.c"

char *condop[]
{
	"be",
	"bne",
	"bnh",
	"bl",
	"bnl",
	"bh",
	"bl",
	"bnh",
	"bh",
	"bnl",
	0
};

max(a, b)	/* returns max of a  b. */
{
	if (a>b)
		return(a);
	return(b);
}

degree(at)
struct tnode *at;
{
	register struct tnode *t;

	if ((t=at)==0 || t->op==0)
		return(0);
	if (t->op == CON || t->op == LCON)
		return(-3);
	if (t->op == AMPER)
		return(-2);
	if ((opdope[t->op] & LEAF) != 0)
		return(0);
	return(t->degree);
}

pname(ap)	/*  Called by cexpr to print addresses.  */
struct tnode *ap;
{
	register i;
	register struct tnode *p;

	p = ap;
	if (p->op == STAR)
		p = p->tr1;
loop:
	switch(p->op) {

	case SFCON:
	case FCON:
		printf("$%d",p->value);
		return;
	case CON:
		printf("=f'%d'", p->value);
		return;

#ifdef unix
	case LCON:
		printf("=x'%04x%04x'",p->value->integ,p->value->integ2);
		return;
#endif
	case NAME:
		if (i = p->offset)
			printf("%d+", i);
		switch(p->class) {

		case AUTO:
			if(p->nloc >= 0)
				printf("%d(R12)", p->nloc);
			else	/* argument */
				printf("ss$&fnum+%d(R12)",-1 - p->nloc);
			return;

		case EXTERN:
			printf("%.8s", &(p->nloc));
			return;

		case FORTRAN:
		case GXTERN:
			printf("@%.7s", &(p->nloc));
			return;

		case STRUCT:
			error("Illegal structure reference");
			printf("$0");
			return;

		case REG:
			if (i)
				error("Bad reg. reference");
			printf("%d", p->nloc);
			return;

		}
		/* presumably, it's static */
		printf("$%d", p->nloc);
		return;

	}
	error("pname called illegally");
}

dcalc(ap, nrleft)	/* Difficulty calculation - returns stuff like e, n, a, or whatever. */
struct tnode *ap;
{
	register struct tnode *p;

	if ((p=ap)==0)
		return(0);
	switch (p->op) {

	case NAME:
		return(12);	/* 12 => addressible. */

	case SFCON:
	case FCON:
		return(12);
	case CON:
		return(p->value==0? 4:(p->value==1?5:((p->value >=0)&&(p->value <4096))?6:8));
#ifdef unix
	case LCON:
		return(8);
#endif
		/* 4=>zero, 5=>one, 6=> 0<=x<4096, 8=>constant. */

	}
	return(p->degree<=nrleft? 20: 24);	/* 20 => easy,  24 => anything.  */
}

notcompat(ap, ast)	/* check compatibility of types - eg int, char, or whatever. */
			/* if tree is type float and tables say double,
			   pretend tree is type double ... */

			/* this is a mess and should be re-written */
struct tnode *ap;	/* ftn returns 0 if compatible and 1 if not. */
{
	register at, st;
	register struct tnode *p;

	p = ap;
	at = p->type;	/* actual type - of the object. */
	st = ast;	/* string type - type demanded by the code table. */
	if ((at&07)==STRUCT)	/* dmr said this shouldn't happen. */
		at =& 077770;	/* map to int */
	if (st==0)		/* word, byte */
		return(at>1 & at<=07);	/* compatible if at = 0 or 1, or if at > 7. */
	if (st==1)		/* word */
		return(at>0 & at<=07);	/* compatible if  at is 0 or if at >7. */
	st =- 2;
	if ((at&077740) != 0)
		at = 020;	/* 020 is pointer to int. */
	if ((at&077770) != 0)
		at = at&07 | 020;
	if (st==DOUBLE && at==FLOAT)
		at = DOUBLE;
	return(st != at);
}

collcon(ap)	/* collect constant. */
struct tnode *ap;
{
	register op;
	register struct tnode *p;

	p = ap;
	if(p->op==PLUS) {
		op = p->tr2->op;
		if ((op == CON) && (p->tr2->value >= 0) && (p->tr2->value < 4096))
			return(1);
	}
	return(0);
}

isfloat(at)	/*  Is type float or double?  */
struct tnode *at;
{
	register struct tnode *t;

	t = at;
	if ((opdope[t->op]&RELAT)!=0)
		t = t->tr1;
	if (t->type == FLOAT)
		return('e');
	if (t->type == DOUBLE)
		return('d');
	return(0);
}

oddreg(t, areg)
struct tnode *t;
{
	register reg;

	reg = areg;
	if (!isfloat(t))
		switch(t->op) {
		case DIVIDE:	/* for / and % need even reg. */
		case MOD:
		case ASDIV:
		case ASMOD:
			reg++;
			return(reg & 0776);

		case TIMES:	/* for * need odd reg and empty even below it.  */
		case ASTIMES:
			reg++;
			return(reg|1);
		}
	return(reg);
}

char dirsw[]	{"	c	r0,=f'%d'\n\
	bh	$%d\n\
	lr	r1,r0\n\
	sll	r1,2\n\
	b	*+4(r1)\n\
"};
pswitch(afp, alp)	/*  Generate code for a switch statement.  */
struct swtab *afp, *alp;
{
	int tlab, ncase, i, j, tabs, worst, best, range;
	int l1, l2, l3;
	register struct swtab *swpo, *fp, *lp;
	int poctab[swsiz];

	fp = afp;
	lp = alp;
	if (fp==lp) {
		printf("	b	$%d\n", deflab);
		return;
	}
	tlab = isn1++;
	if (sort(fp, lp))
		return;
	ncase = lp-fp;
	lp--;
	range = lp->swval - fp->swval;
	/* direct switch */
	if ((range>0 && range <= 3*ncase)) {
		if (fp->swval)
			printf("	s	0,=f'%d'\n", fp->swval);
		printf(dirsw, range, deflab);
		for (i=fp->swval; i<=lp->swval; i++) {
			if (i==fp->swval) {
				printf("	b	$%d\n", fp->swlab);
				fp++;
			} else
				printf("	b	$%d\n", deflab);
		}
		goto esw;
	}
	/* simple switch */
	if( 1 || (ncase<8)) {
		for (; fp <= lp; fp++) {
			/* should distinguish half and full word literals */
			printf ("        c       0,=f'%d'\n",fp->swval);
			printf ("        be      $%d\n",fp->swlab);
		}
		printf ("        b       $%d\n",deflab);
		goto esw;
	}
	/* hash switch */
/*  Hash switch is not currently supported.  */
/*	best = 077777;
/*	for (i=ncase/4; i<=ncase/2; i++) {
/*		for (j=0; j<i; j++)
/*			poctab[j] = 0;
/*		for (swpo=fp; swpo<=lp; swpo++)
/*			poctab[lrem(0, swpo->swval, i)]++;
/*		worst = 0;
/*		for (j=0; j<i; j++)
/*			if (poctab[j]>worst)
/*				worst = poctab[j];
/*		if (i*worst < best) {
/*			tabs = i;
/*			best = i*worst;
/*		}
/*	}
/*	printf("jsr	pc,hswitch; 0%o; .+4; L%d\n", tabs, deflab);
/*	for (i=0; i<tabs; i++) {
/*		for (swpo=fp; swpo<=lp; swpo++) {
/*			if (lrem(0, swpo->swval, tabs) == i) {
/*				printf("2f\n.data\n2:\n");
/*				for (; swpo<=lp; swpo++)
/*					if (lrem(0,swpo->swval,tabs)==i)
/*						printf("L%d;0%o\n",
/*						  swpo->swlab,
/*						  swpo->swval);
/*				printf("0\n.text\n");
/*				goto break1;
/*			}
/*		}
/*		printf("0\n");
/*break1:;
/*	}
*/
esw:
	printf("* End of switch code.\n");
}

sort(afp, alp)
struct swtab *afp, *alp;
{
	register struct swtab *bp, *fp, *lp;
	int intch, t;

	fp = afp;
	lp = alp;
	while (fp < --lp) {
		intch = 0;
		for (bp=fp; bp<lp; bp++) {
			if (bp->swval == bp[1].swval) {
				error("Duplicate case (%d)", bp->swval);
				return(1);
			}
			if (bp->swval > bp[1].swval) {
				intch++;
				t = bp->swval;
				bp->swval = bp[1].swval;
				bp[1].swval = t;
				t = bp->swlab;
				bp->swlab = bp[1].swlab;
				bp[1].swlab = t;
			}
		}
		if (intch==0)
			break;
	}
	return(0);
}

ispow2(atree)
{
	register int d;
	register struct tnode *tree;

	tree = atree;
	if (!isfloat(tree) && tree->tr2->op==CON) {
		d = tree->tr2->value;
		if (d>0 && (d&(d-1))==0)
			return(d);
	}
	return(0);
}

pow2(atree)
struct tnode *atree;
{
	register int d, i;
	register struct tnode *tree;

	tree = atree;
	if (d = ispow2(tree)) {
		for (i=0; (d = d >> 1)!=0; i++);
		tree->tr2->value = i;
		d = tree->op;
		tree->op = ( d==TIMES? LSHIFT: ASLSH );
	}
}

struct tconst czero { CON, INT, 0, 0};
struct tconst cone  { CON, INT, 0, 1};

cbranch(atree, albl, cond, areg)
struct tnode *atree;
{
	int l1;
	register lbl, reg;
	register struct tnode *tree;
	struct tnode lbuf;

	lbl = albl;
	reg = areg;
	if ((tree=atree)==0)
		return;
	switch(tree->op) {

	case LOGAND:
		if (cond) {
			cbranch(tree->tr1, l1=isn1++, 0, reg);
			cbranch(tree->tr2, lbl, 1, reg);
			label(l1);
		} else {
			cbranch(tree->tr1, lbl, 0, reg);
			cbranch(tree->tr2, lbl, 0, reg);
		}
		return;

	case LOGOR:
		if (cond) {
			cbranch(tree->tr1, lbl, 1, reg);
			cbranch(tree->tr2, lbl, 1, reg);
		} else {
			cbranch(tree->tr1, l1=isn1++, 1, reg);
			cbranch(tree->tr2, lbl, 0, reg);
			label(l1);
		}
		return;

	case EXCLA:
		cbranch(tree->tr1, lbl, !cond, reg);
		return;
	}
	if ((opdope[tree->op]&RELAT)==0) {
		lbuf.op = NEQUAL;
		lbuf.type = tree->type;
		lbuf.degree = tree->degree;
		lbuf.tr1 = tree;
		lbuf.tr2 = &czero;
		tree = &lbuf;
	}
	rcexpr(tree, cctab, reg);
	branch1(lbl, tree->op, !cond);
}

branch1(lbl, aop, c)	/*  generate jump instruction for branching. */
{
	register op;

	if(op=aop)
		cbr(op,c);
	else
		printf("b");
	printf("	$%d\n", lbl);
}

cbr(op, flag)
{
	if (flag)
		op = notrel[op - EQUAL];
	printf("	%s", condop[op - EQUAL]);
}
