#
/*

			(file - c0h.c)

	C compiler--  header file

	Copyright 1973 Bell Telephone Laboratories, Inc.

*/

/*
  parameters
*/

#define	ncps	8
#define	hshsiz	400
#define	cmsiz	40
#define	swsiz	200
#define	ncpw	4  /*  number of characters per word  */
#define	ossiz	500
#define	dimsiz	100
# define  hgintsz 4  /* number of bytes in an integer */
# define hgfloatsz 8  /* number of bytes in a float */
# define hgreglen 64	/*  bytes required to store 16 registers  */
# define totregs 5
# define lowreg 2
#define	PREPUSH	4	/* number of bytes to drop stack below base */

/* the following constants indicate the type of loctr */
# define hgmain 1
# define hgcode 2
# define hgdata 3
# define hgstring 4
# define hgtvec 5
# define hglit 6
# define hgistring 7



struct tnode {  /* nodes for expression tree */
	int op;
	int type;
	int dimp;   /*  dimention pointer */
	struct tnode *tr1, *tr2;
};

struct {
	int fop;
	int ftype;
	char ssp;		/* subscript list */
	char lenp;		/* structure length */
};

struct  {  /* tnode from pass 1. */
	int op;
	int type;
	int degree;
	struct tnode *tr1, *tr2;
};

struct tname {   /*  node for a leaf in the expression tree  */
	int nop;
	int ntype;
	int ndimp;
	int class;
	int offset;
	int nloc;
};


struct  {  /*  tname from pass 1.  */
	int nop;
	int ntype;
	int elsize;
	int class;
	int offset;
	int nloc;
};

struct tconst {   /*  node for a constant in the expression tree  */
	int cop;
	int ctype;
	int cdimp;
	int value;
};

struct  {  /*  tconst from pass 1.  */
	int cop;
	int ctype;
	int cdeg;
	int value;
};
struct hshtab {  /*  hash table  */
	int hclass;
	int htype;
	int hdimp;
	int hoffset;
	int hflags;
	char name[ncps];
};

struct swtab {  /* switch table  */
	int swlab;
	int swval;
};

struct bnode {
	int bop;
	struct tnode *btree;
	int lbl;
	int cond;
};

struct optab {
	int tabdeg1;
	int tabtyp1;
	int tabdeg2;
	int tabtyp2;
	char *tabstring;
};

struct table {
	int tabop;
	struct optab *tabp;
};



extern struct	tconst czero, cone;
extern char	cvtab[];    /*  conversion table in c04.c ; used in type conversions  */
extern int	opdope[];    /*  information on operators */
extern char	ctab[];    /*  table that maps characters into character types  */
extern char	symbuf[ncps];
extern int	hshused;
extern struct	hshtab	hshtab[hshsiz];
extern int	*space;
extern int	*cp;
extern int	cmst[cmsiz];
extern int	isn;
extern int 	isn1;
extern struct	swtab	swtab[swsiz];
extern struct	swtab	*swp;
extern int	contlab;
extern int	brklab;
extern int	retlab;
extern int	deflab;
extern int	autolen;
extern int	peeksym;
extern int	peekc;
extern int	eof;
extern int	line;
extern int	*treebase;
extern struct	hshtab	*defsym;
extern struct	hshtab	*funcsym;
extern int	xdflg;
extern int	proflg;
extern struct	hshtab	*csym;
extern int	cval;
extern char	*fcval;
extern int	nchstr;
extern int	nerror;
extern struct	hshtab	*paraml;
extern struct	hshtab	*parame;
extern int	strflg;
extern int	osleft;
extern int	mosflg;
extern int	initflg;
extern int	inhdr;
extern int	dimtab[dimsiz];
extern int	dimp;	/* Next free slot in dimension table. */
extern int	regvar;	/* Number of declared register variables. */

 /* Variables added for ibmc. */
extern int ndp;	/* nbr of declared parameters in a ftn. */
extern int endp;	/* enable incrementing of ndp. */
extern int xtern;	/* flag to indicate keyword extern was seen. */
extern int ftern;	/* flag to indicate keyword fortran was seen. */
extern int fflg;	/* composite fortran flag */
extern int function;	/* flag to indicate if a ftn has yet been seen. */
extern int mainftn;	/* flag to indicate whether ftn is main */
extern int mainfile;	/* flag indicating whether main function is in file */
extern int machine;	/* flag to tell which machine this program is executing on.  */
extern int hgoffs;	/* contents of HGARGP plus hgoffs points to first free space on arg. stack */
extern int hgcurloc;	/*  current loctr  */


extern char	maprel[];
extern char	notrel[];
extern int	nreg;
extern struct	table	cctab[];
extern struct	table	efftab[];
extern struct	table	regtab[];
extern int	nstack;
extern int	nfloat;

/*
  operators
*/
#define	EOF	0
#define	SEMI	1
#define	LBRACE	2
#define	RBRACE	3
#define	LBRACK	4
#define	RBRACK	5
#define	LPARN	6
#define	RPARN	7
#define	COLON	8
#define	COMMA	9

#define	KEYW	19
#define	NAME	20
#define	CON	21
#define	STRING	22
#define	FCON	23
#define	SFCON	24
#define	LCON	25

#define	INCBEF	30
#define	DECBEF	31
#define	INCAFT	32
#define	DECAFT	33
#define	EXCLA	34
#define	AMPER	35
#define	STAR	36
#define	NEG	37
#define	COMPL	38

#define	DOT	39
#define	PLUS	40
#define	MINUS	41
#define	TIMES	42
#define	DIVIDE	43
#define	MOD	44
#define	RSHIFT	45
#define	LSHIFT	46
#define	AND	47
#define	OR	48
#define	EXOR	49
#define	ARROW	50
#define	ITOF	51
#define	FTOI	52
#define	LOGAND	53
#define	LOGOR	54

#define	EQUAL	60
#define	NEQUAL	61
#define	LESSEQ	62
#define	LESS	63
#define	GREATEQ	64
#define	GREAT	65
#define	LESSP	66
#define	LESSEQP	67
#define	GREATP	68
#define	GREATQP	69

#define	ASPLUS	70
#define	ASMINUS	71
#define	ASTIMES	72
#define	ASDIV	73
#define	ASMOD	74
#define	ASRSH	75
#define	ASLSH	76
#define	ASSAND	77
#define	ASOR	78
#define	ASXOR	79
#define	ASSIGN	80

#define	QUEST	90
#define	CALL	100
#define	MCALL	101
#define	JUMP	102
#define	CBRANCH	103
#define	INIT	104
#define	SETREG	105
#define LOAD    106
#define INIB	107
#define	RFORCE	110
#define	BRANCH	111
#define	LABEL	112

/*
  types
*/
#define	INT	0
#define	CHAR	1
#define	FLOAT	2
#define	DOUBLE	3
#define	STRUCT	4
#define	RSTRUCT	5
#define	PTR	010
#define	FUNC	020
#define	ARRAY	030

/*
  storage classes
*/
#define	KEYWC	1
#define MOS	4
#define	GXTERN	9
#define	AUTO	5
#define	EXTERN	6
#define	STATIC	7
#define	REG	8
#define	STRTAG	3
#define ARG	10
#define	ARG1	11
#define FORTRAN	23
#define BLISS 22

/*
  keywords
*/
#define	GOTO	10
#define	RETURN	11
#define	IF	12
#define	WHILE	13
#define	ELSE	14
#define	SWITCH	15
#define	CASE	16
#define	BREAK	17
#define	CONTIN	18
#define	DO	19
#define	DEFAULT	20
#define	FOR	21
#define ASM	24
#define SIZEOF 29

/*
  characters
*/
#define	INSERT	119
#define	PERIOD	120
#define	SQUOTE	121
#define	DQUOTE	122
#define	LETTER	123
#define	DIGIT	124
#define	NEWLN	125
#define	SPACE	126
#define	UNKN	127

/*
  Flag bits
*/

#define	BINARY	01
#define	LVALUE	02
#define	RELAT	04
#define	ASSGOP	010
#define	LWORD	020
#define	RWORD	040
#define	COMMUTE	0100
#define	RASSOC	0200
#define	LEAF	0400

/*
hflags
*/

#define GLOBAL	01
#define DEFINED	02
#define DELETED	04
#define PERM	010


#define YES	1
#define NO	0
#define IBM	0
#define UNIX 	1

#ifndef unix
#define	long	int
#endif
struct { long longint;};
struct { int integ; int integ2;};
