.TH XREF LOCAL U-WISC
.ad b
.SH NAME
xref \- cross reference files
.SH SYNOPSIS
\fBxref\fR [\fB-k\fR keyfile] [\fB-w\fR n] file ...
.SH DESCRIPTION
.I Xref
cross references to standard output
all the "names" in its (text) input files
together with the files and line numbers they occur on.
If no files are supplied, it reads standard input.
Names consist of letters, underscores, and (non-initial) digits.
.PP
Available options are:
.TP
.B \-k " keyfile"
Use keyfile as a list of words which should be
suppressed from the cross reference.
As the removal is done via "fgrep -v", the words should occur one
per line.
To prevent internal matches from discarding valid longer words,
each word can be preceded by a space and followed by a tab.
By default all words are included.
.TP
.B \-w " n"
Format the output with a width of n columns, by default 80.
N is primarily intended for raising the line length;
a lower limit of 40 is silently enforced.
.ne 5
.SH FILES
.br
???usrlocal/xreflex	first stage of xref (lexical analyzer)
.SH DIAGNOSTICS
Complains about unreadable files, and exits with status 2 if no
files can be read.
Unhappy subprocesses (fgrep, sort, awk) may also bleat.
.SH "SEE ALSO"
ctags(1),
egrep(1),
ptx(1)
.SH BUGS
Filenames containing shell meta-characters may be misprocessed.
The four stage pipeline is relatively inefficient.
A general purpose program cannot take advantage of semantic
knowledge of its input in order to produce prettier, better classified
output.
.SH AUTHOR
Jim Leinweber
