float	sintab[] = {
	.00000,	.00614,	.01227,	.01841,	.02454,	.03067,	.03681,	.04294,
	.04907,	.05520,	.06132,	.06744,	.07356,	.07968,	.08580,	.09191,
	.09802,	.10412,	.11022,	.11632,	.12241,	.12850,	.13458,	.14066,
	.14673,	.15280,	.15886,	.16491,	.17096,	.17700,	.18304,	.18907,
	.19509,	.20111,	.20711,	.21311,	.21910,	.22508,	.23106,	.23702,
	.24298,	.24893,	.25487,	.26079,	.26671,	.27262,	.27852,	.28441,
	.29029,	.29615,	.30201,	.30785,	.31368,	.31950,	.32531,	.33111,
	.33689,	.34266,	.34842,	.35416,	.35990,	.36561,	.37132,	.37701,
	.38268,	.38835,	.39399,	.39962,	.40524,	.41084,	.41643,	.42200,
	.42756,	.43309,	.43862,	.44412,	.44961,	.45508,	.46054,	.46598,
	.47140,	.47680,	.48218,	.48755,	.49290,	.49823,	.50354,	.50883,
	.51410,	.51936,	.52459,	.52980,	.53500,	.54017,	.54533,	.55046,
	.55557,	.56066,	.56573,	.57078,	.57581,	.58081,	.58580,	.59076,
	.59570,	.60062,	.60551,	.61038,	.61523,	.62006,	.62486,	.62964,
	.63439,	.63912,	.64383,	.64851,	.65317,	.65781,	.66242,	.66700,
	.67156,	.67609,	.68060,	.68508,	.68954,	.69397,	.69838,	.70276,
	.70711,	.71143,	.71573,	.72000,	.72425,	.72846,	.73265,	.73682,
	.74095,	.74506,	.74914,	.75319,	.75721,	.76120,	.76517,	.76910,
	.77301,	.77689,	.78074,	.78456,	.78835,	.79211,	.79584,	.79954,
	.80321,	.80685,	.81046,	.81404,	.81759,	.82110,	.82459,	.82805,
	.83147,	.83486,	.83823,	.84156,	.84485,	.84812,	.85136,	.85456,
	.85773,	.86087,	.86397,	.86705,	.87009,	.87310,	.87607,	.87901,
	.88192,	.88480,	.88764,	.89045,	.89322,	.89597,	.89867,	.90135,
	.90399,	.90660,	.90917,	.91171,	.91421,	.91668,	.91911,	.92151,
	.92388,	.92621,	.92851,	.93077,	.93299,	.93518,	.93734,	.93946,
	.94154,	.94359,	.94561,	.94759,	.94953,	.95144,	.95331,	.95514,
	.95694,	.95870,	.96043,	.96212,	.96378,	.96540,	.96698,	.96852,
	.97003,	.97150,	.97294,	.97434,	.97570,	.97703,	.97832,	.97957,
	.98079,	.98196,	.98311,	.98421,	.98528,	.98631,	.98730,	.98826,
	.98918,	.99006,	.99090,	.99171,	.99248,	.99321,	.99391,	.99457,
	.99519,	.99577,	.99631,	.99682,	.99729,	.99772,	.99812,	.99848,
	.99880,	.99908,	.99932,	.99953,	.99970,	.99983,	.99993,	.99998,
	1.00000 };

double
pslsin(angle)
int	angle;
{
	register int	sign, ang;
	double	sin;

	ang = (angle + 32) & ~077;
	sign = ang & 0100000;
	ang = ang & 077777;
	ang = ang & 040000 ? 0100000 - ang: ang;
	ang = ang>>6;
	if( sign ) {
		sin = -sintab[ang];
	} else {
		sin = sintab[ang];
	}
	return(sin);
}

double
pslcos(angle)
int	angle;
{
	double	pslsin();

	return(pslsin(angle+040000));
}

double
psltan(angle)
int	angle;
{
	double	pslsin();

	if( (angle & 077777) == 040000 ) return(1.e38);
	return(pslsin(angle)/pslsin(angle + 040000));
}

double
ipslsin(angle)
int	angle;
{
	register int	interp, ang;
	double	h, l, pslsin();

	interp = angle;
	interp &= 077;
	ang = angle;
	ang &= ~077;
	l = pslsin(ang);
	h = pslsin(ang+64);
	return(((interp*(h-l))/64. + l));
}

double
ipslcos(angle)
{
	double	ipslsin();

	return(ipslsin(angle+16384));
}

double
ipsltan(angle)
int	angle;
{
	double	ipslsin();

	if( (angle & 077777) == 040000 ) return(1.e38);
	return(ipslsin(angle)/ipslsin(angle + 040000));
}
