	  Title   lnkmdm.asm  X.PC Link and Modem Changes/Report Routines
	  page	  60,132
;*****************************************************************************
;     This program is the sole property and confidential information of      *
;     Tymnet, Inc., and may not be copied in whole or part, or disclosed     *
;     to any third party, without the written prior consent of Tymnet.	     *
;*****************************************************************************
; ------------------------------------------------------------------------
;
;		  X.PC Link and Modem Changes/Report Routines
;
; filename = x_lnkmdm.asm
;
; The routines in this module will either report or set the values of the
; 8250 chip, including the Link Characteristics and the state of the Modem
; signals.  The formats of the Link Characteristics field and the Modem and
; Line Status Registers are as shown in the IBM PC Technical Reference Manual,
; in the "Asynchronous Communications Adapter" section (ch. 2, p. 123).
; All routines use the 'curr_port' and 'port_addr' table as generated by the
; load_com routine, so that routine must be called before these will work.
;
; rep_lkch  returns the Link characteristics of the current port in AX.
; set_lkcc  sets the Link characteristics for the current port, from AX.
; set_lkch  accepts a 'C' call (parameter), stores in AX and calls set_lkcc.
;
; rep_lkst  returns the Line Status Register in AL (AH=0).
; rep_mdst  returns the Modem Status Register in AL (AH=0).
;
; setondtr  sets the DTR signal to an ON position.
; setofdtr  sets the DTR signal to an OFF position.
; setonrts  sets the RTS signal to an ON position.
; setofrts  sets the RTS signal to an OFF position.
; setonbrk  sets the BREAK signal to an ON position.
; setofbrk  sets the BREAK signal to an OFF position.
; ------------------------------------------------------------------------
;   Date    Change#   by     Reason
; 05/22/84     01    curt    Initial Generation of code.
; 08/31/84     02    curt    Cleanup for release version 1.02.
; ------------------------------------------------------------------------
	  subttl  Include file section
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	  include p_intequ.ad	       ; port addressing MACROs.
	  subttl  Local File Data Declarations
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ------------------------------------------------------------------------
; The information here is a duplication of the tables in the IBM PC
; Technical Reference Manual.  When conflicts occur, refer to the manual.
; ------------------------------------------------------------------------
; Link Characteristics Field format used is as follows:
; ------------------------------------------------------------------------
;      ---- in AH: -----       ----------------  in AL:  -----------------
;
;  7->3   2	1     0        7   6	 5   4	 3	 2	  1	0
;  ----   -------------        -----	 ---------	----	 ---------
;  don't      Baud             don't      parity        stop       data
;  care.      rate	       care.			bits	   bits
;
;	  000  :   110			 xx0  : none	0 : 1	  00 : 5
;	  001  :   150			 001  : odd	1 : 2	  01 : 6
;	  010  :   300			 011  : even		  10 : 7
;	  011  :   600			 101  : space		  11 : 8
;	  100  :  1200			 111  : mark
;	  101  :  2400
;	  110  :  4800
;	  111  :  9600
; ------------------------------------------------------------------------

dgroup	  group   data
data	  segment byte public 'data'
	  extrn   port_addr:word, curr_port:word
; ------------------------------------------------------------------------
; Baud rate Divisor Table.  Value sets baud rate when given to 8250.
; ------------------------------------------------------------------------
baud_tbl  label   word	     ; make a label that can get to table with
	  dw	  1047	     ;	110 baud
	  dw	  768	     ;	150
	  dw	  384	     ;	300
	  dw	  192	     ;	600
	  dw	  96	     ; 1200
	  dw	  48	     ; 2400
	  dw	  24	     ; 4800
	  dw	  12	     ; 9600
data	  ends

pgroup	  group   prog
prog	  segment byte public 'prog'
	  assume  CS:pgroup,DS:dgroup

	  subttl  Report Link Characteristics
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ------------------------------------------------------------------------
; This returns in AX the Link Characteristics field for the current port.  When
; the existing baud rate setting is not found in the table, the routine will
; indicate 110 baud.  The parity, # of data/stop bits are input, then the
; baud rate is determined by a table lookup algorithm.
; ------------------------------------------------------------------------
	  public  rep_lkch
rep_lkch  proc	  near
	  bld_dxp LIN_CNTRL		    ; build line control reg. address.
	  in	  al,dx 		    ; get line control reg. contents,
	  and	  al,7Fh		    ; mask off lower 7 bits (DLAB=>0).
	  push	  ax			    ; save LCR value on the stack. ***

	  or	  al,80h		    ; set DLAB bit to 1, leave others
	  out	  dx,al 		    ; for output to line control reg.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  dec_dxp LIN_CNTRL, INT_ENBLE	    ; Move to Most Significant Byte
	  in	  al,dx 		    ; port and read MSB from there.
	  mov	  ah,al 		    ; save value...
	  dec_dxp INT_ENBLE, IO_PORT	    ; Move to Least Significant Byte
	  in	  al,dx 		    ; port and read LSB from there.

; ------------------------------------------------------------------------
; Now have read into AX value in use by the Chip in generating baud rate.
; Find in 'baud_tbl', report 3-bit value showing X.PC format baud rate.
; ------------------------------------------------------------------------
	  xor	  di,di 		    ; zero index/counter
bd_next:  cmp	  ax,word ptr baud_tbl[di]  ; compare reported to possible.
	  je	  short bd_done 	    ; found matching divisor value.
	  inc	  di			    ; next word, please.
	  inc	  di			    ; increment bit map.
	  cmp	  di,16 		    ; see if have done 8 word entries.
	  jne	  short bd_next 	    ; next count, please.
	  xor	  di,di 		    ; failed to find entry, return 110
bd_done:  mov	  cl,7			    ; Move the value just 7 bits: move
	  shl	  di,cl 		    ; byte into high order & div by 2.
	  inc_dxp IO_PORT, LIN_CNTRL	    ; point dx at Line control reg.
	  pop	  ax			    ; get previous contents of LCR. ***
	  out	  dx,al 		    ; Using bits as IN from Clin_cntrl, with
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
					    ; DLAB=0, reset Line control reg.
	  and	  ax,003Fh		    ; Only use bits 0-5 for report.
	  or	  ax,di 		    ; combine baud rate & other fields

	  ret
rep_lkch  endp
	  subttl  Set Link Characteristics - ASM version
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ------------------------------------------------------------------------
; This routine accepts in AX a X.PC formatted Link Characteristics field.
; The baud rate field is used to lookup a divisor for the Baud rate generator.
; The remaining bits are passed directly to the Link Control Register. MUST
; turn the DLAB bit on so can access the Divisor bytes of the Generator.
; ------------------------------------------------------------------------
	  public  set_lkcc
set_lkcc  proc	  near
	  push	  ax		       ; save parameter on the stack.
	  bld_dxp LIN_CNTRL	       ; build pointer to Line Control Reg,
	  mov	  al,80h	       ; so can turn DLAB bit on.
	  out	  dx,al 	       ; may proceed with sending MSB/LSB.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...

; ------------------------------------------------------------------------
; Look up the divisor to use by indexing into the Baud Table.
; ------------------------------------------------------------------------
	  mov	  bl,ah 	       ; recall baud rate parameter.
	  and	  bx,0007h	       ; get rid of high order bits, then shift
	  shl	  bx,1		       ; whole thing by one to make word index,
	  mov	  di,bx 	       ; and get the damn thing into index reg!
	  mov	  ax,word ptr baud_tbl[di]	 ; get word version of 2 bytes.

	  dec_dxp LIN_CNTRL, INT_ENBLE ; point dx at interrupt enable port.
	  mov	  cl,8		       ; rotate ah into al in order to get
	  ror	  ax,cl 	       ; Most significant Byte into al,
	  out	  dx,al 	       ; write MSB to interrupt enable port.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  dec_dxp INT_ENBLE, IO_PORT   ; point to Least Significant Byte port,
	  ror	  ax,cl 	       ; get Least Significant Byte into al,
	  out	  dx,al 	       ; write LSB to IO port.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...

; ------------------------------------------------------------------------
; Now have established baud rate, do rest of fields.  AND operation on the
; Line Control Register output field will set DLAB to 0.
; ------------------------------------------------------------------------
	  inc_dxp IO_PORT, LIN_CNTRL   ; make dx point to Line Control Reg.
	  pop	  ax		       ; recover saved parameter from stack.
	  and	  al,3Fh	       ; retain all but 2 high-order bits.
	  out	  dx,al 	       ; output rest of Line Control info.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  ret
set_lkcc  endp
	  subttl  Set Link Characteristics - 'C' callable version
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


stk_struc struc 		       ; used to access stack, setup by caller.
oldbp	  dw	  ?		       ; caller's bp value.
retn_ip   dw	  ?		       ; Instruction pointer of caller.
param	  dw	  ?		       ; single parameter stored here.
stk_struc ends


; ------------------------------------------------------------------------
; This routine calls the set_lkcc routine, after retrieving the parameter
; from the stack, as placed there by C caller. Structure maps storage.
; ------------------------------------------------------------------------
	  public  set_lkch
set_lkch  proc	  near
	  push	  bp		       ; save caller's bp.
	  mov	  bp,sp 	       ; move base pointer to stack top.

	  mov	  ax,[bp].param        ; get parameter as held on stack.
	  call	  set_lkcc	       ; and call real SETUP routine.

	  pop	  bp
	  ret
set_lkch  endp
	  subttl  Report Line and Modem Status
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ------------------------------------------------------------------------
; This routine returns in AL the current value of the Line Status Register
; of the 8250 Async. Chip. AH is set to 0.
; ------------------------------------------------------------------------
	  public  rep_lkst
rep_lkst  proc	  near
	  bld_dxp LIN_STAT	       ; need the Line Status Register.
	  in	  al,dx 	       ; get contents for return.
	  xor	  ah,ah 	       ; clear high order bits of AX.
	  ret
rep_lkst  endp


; ------------------------------------------------------------------------
; This routine returns in AL the current value of the Modem Status Register
; of the 8250 Async. Chip.  AH is set to 0.
; ------------------------------------------------------------------------
	  public  rep_mdst
rep_mdst  proc	  near
	  bld_dxp MDM_STAT	       ; need the Modem Status Register.
	  in	  al,dx 	       ; get contents for return.
	  xor	  ah,ah 	       ; clear high order bits of AX.
	  ret
rep_mdst  endp
	  subttl  DTR on/off settings
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ------------------------------------------------------------------------
; This routine sets the DTR bit in the Modem Control Register to ON.
; ------------------------------------------------------------------------
	  public  setondtr
setondtr  proc	  near
	  bld_dxp MDM_CNTRL		;want Modem Control Register.
	  in	  al,dx 		;Read current settings, and OR to
	  or	  al,01h		;set bit #0 to 1 regardless.
	  out	  dx,al 		;output new settings.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  ret
setondtr  endp


; ------------------------------------------------------------------------
; This routine sets the DTR bit in the Modem control Register to OFF.
; ------------------------------------------------------------------------
	  public  setofdtr
setofdtr  proc	  near
	  bld_dxp MDM_CNTRL		;want modem control register.
	  in	  al,dx 		;read current settings, and AND to
	  and	  al,NOT 01h		;leave all bits as is except bit #0.
	  out	  dx,al 		;output new settings.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  ret
setofdtr  endp
	  subttl  RTS on/off settings
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ------------------------------------------------------------------------
; This routine sets the RTS bit in the Modem Control Register to ON.
; ------------------------------------------------------------------------
	  public  setonrts
setonrts  proc	  near
	  bld_dxp MDM_CNTRL	       ; Want Modem control register.
	  in	  al,dx 	       ; Read current settings, and OR to
	  or	  al,02h	       ; set bit #1 ON regardless.
	  out	  dx,al 	       ; output new settings.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  ret
setonrts  endp


; ------------------------------------------------------------------------
; This routine sets the RTS bit in the Modem control Register to OFF.
; ------------------------------------------------------------------------
	  public  setofrts
setofrts  proc	  near
	  bld_dxp MDM_CNTRL	       ; Want Modem control register.
	  in	  al,dx 	       ; Read current settings, and AND to
	  and	  al,NOT 02h	       ; leave all as is except bit #1.
	  out	  dx,al 	       ; output new settings.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  ret
setofrts  endp
	  subttl  Break Signal On/Off routines
;	  page	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ------------------------------------------------------------------------
; This routine causes the BREAK signal to go ON by setting the bit in the
; Line Control Register that turns on the BREAK signal.
; ------------------------------------------------------------------------
	  public  setonbrk
setonbrk  proc	  near
	  bld_dxp LIN_CNTRL	       ; point at Line Control register.
	  in	  al,dx 	       ; read current settings,
	  or	  al,40h	       ; set bit to cause break to begin.
	  out	  dx,al 	       ; output new settings.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  ret
setonbrk  endp


; ------------------------------------------------------------------------
; This routine accesses the Line Control Register to turn the BREAK signal
; bit OFF, stopping any output of a BREAK signal.
; ------------------------------------------------------------------------
	  public  setofbrk
setofbrk  proc	  near
	  bld_dxp LIN_CNTRL		;point at Line Control Register.
	  in	  al,dx 		;read current settings,

	  and	  al,NOT 40h		;make sure bit is off now (10111111).
	  out	  dx,al 		;output to the Line Control Register.
	  jmp	  short $+2		;delay for IBM PC/AT
	  out	  dx,al 		;SCS, Sleepy Chip Syndrome...
	  ret
setofbrk  endp

prog	  ends
	  end
