#
/*
 */

#include "../param.h"
#include "../seg.h"
#include "../buf.h"
#include "../conf.h"
#include "../tty.h"		/* for log() clist dfn */

/*
 * Address and structure of the
 * KL-11 console device registers.
 */
struct
{
	int	rsr;
	int	rbr;
	int	xsr;
	int	xbr;
};

/*
 * In case console is off,
 * panicstr contains argument to last
 * call to panic.
 */

char	*panicstr;

struct	clist	log_q;
int	logit;

/*
 * Scaled down version of C Library printf.
 * Only %s %l %d (==%l) %o are recognized.
 * Used to print diagnostic information
 * directly on console tty.
 * Since it is not interrupt driven,
 * all system activities are pretty much
 * suspended.
 * Printf should not be used for chit-chat.
 */
printf(fmt,x1)
char *fmt;
{
	print1(fmt, &x1);
}


print1(fmt, x1)
char *fmt;
int *x1;
{
	register char *s;
	register *adx, c;

	if(!logit && SW->integ == 0)
		return;
	adx = x1;
loop:
	while((c = *fmt++) != '%') {
		if(c == '\0')
			return;
		putchar(c);
	}
	c = *fmt++;
	if(c == 'o'){
		putchar('0');
		printn(*adx, 8);
	} else 
		if(c== 'd' || c== 'l')
			printn(*adx, 10);
		else
			if(c == 's') {
				s = *adx;
				while(c = *s++)
				putchar(c);
			}
	/*		   else
				if(c == 'c')
					putchar(*adx);  */

	adx++;
	goto loop;
}

/*
 * Print an unsigned integer in base b.
 */
printn(n, b)
{
	register a;

	if(a = ldiv(n, b))
		printn(a, b);
	putchar(lrem(n, b) + '0');
}

/*
 * Print a character on console.
 * Attempts to save and restore device
 * status.
 * If the switches are 0, all
 * printing is inhibited.
 */
putchar(c)
{
	register rc, s;

	rc = c;
	if(logit) {
		putc(rc, &log_q);
		return;
	}
	if(SW->integ == 0)
		return;
	while((KL->xsr&0200) == 0)
		;
	if(rc == 0)
		return;
	s = KL->xsr;
	KL->xsr = 0;
	KL->xbr = rc;
	if(rc == '\n') {
		putchar('\r');
		putchar(0177);
		putchar(0177);
	}
	putchar(0);
	KL->xsr = s;
}

/*
 * Panic is called on unresolvable
 * fatal errors.
 * It syncs, prints "panic: mesg" and
 * then loops.
 */
panic(s)
char *s;
{
	panicstr = s;
	update();
	printf("panic: %s\n", s);
	for(;;)
		idle();
}

/*
 * prdev prints a warning message of the
 * form "mesg on dev x/y".
 * x and y are the major and minor parts of
 * the device argument.
 */

int	prd_str,  prd_dev;

prdev(str, dev)
{

	if(prd_str == str && prd_dev == dev) return;
	log(LOG_LOG, "#%l/%o: %s\n", dev.d_major, dev.d_minor, str);
	prd_str = str;   prd_dev = dev;
}

/*
 * deverr prints a diagnostic from
 * a device driver.
 * It prints the device, block number,
 * and an octal word (usually some error
 * status register) passed as argument.
 */
deverror(bp, o1, o2)
int *bp;
{
	register *rbp;

	rbp = bp;
	prdev("err", rbp->b_dev);
	log(LOG_INFO, "bn%l er%o %o\n", rbp->b_blkno, o1, o2);
}


log(flag, fmt, x1)
{
	extern log_open;

	switch(flag + ((log_q.c_cc < LOGHOG)?log_open:0)) {

	case LOG_DIRECT:
	case LOG_LOG:	print1(fmt, &x1);
	case LOG_INFO:	return;

	case LOG_OPEN+LOG_DIRECT:
			print1(fmt, &x1);
	case LOG_OPEN+LOG_LOG:
	case LOG_OPEN+LOG_INFO:
			logit++;
			putchar(flag);
			print1(fmt, &x1);
			putchar(0);
			logit = 0;
			wakeup(&log_q);
			return;
	}
}
