#include "/h/stat.h"
/* update to perform a sync every minute, as well as
	print the date on the cty every 15 minutes while
	the system is up and no one is logged into the cty.
 */

long nxttim, nowtim, oldtim;
struct inode fstatbuf;

main(a,b)
{
	register int i, count;

	signal(2, 1);
	signal(3, 1);
	count = 0;
	nowtim = 0;
	nxttim = 0;
	for(;;) {
		sleep(60);
		count++;
		sync();
		oldtim = nowtim;
		time(&nowtim);
		if (nowtim < oldtim) {
			/* date set back */
			nxttim =- oldtim-nowtim+60;
		}
		if (nowtim > nxttim) {
			nxttim =+ 15*60;
			if (nxttim <= nowtim) {
				/* first time through, or date set forward */
				nxttim = nowtim + 15*60;
			}
			stat("/dev/cty", &fstatbuf);
			if (fstatbuf.i_uid == 0 && fstatbuf.i_gid == 0) {
				i = open("/dev/cty", 1);
				type(i, "\r\n\r\n=>=>=>=>=>=>=>=>=>=>=>=>=>=>=> syncs = ");
				prndec(i, count);
				type(i, "     ");
				count = 0;
				type(i, ctime(&nowtim));
				type(i, "\r");
				close(i);
			}
		}
	}
}
