#include "/h/cinfo.h"
#include "/h/sgtty.h"
#define BSIZ	1024

int	fin;
char	buf[BSIZ];
struct	sgtty sgb;
struct	cinfo inf;


main(argc, argv)
char **argv;
{
	register char *bp, *low;
	register int c;
	int me, except, *exclist, i;
	char *namep;

	if(getruid())
		error("Sorry");
	if(argc > 1) {
		argv[argc] = 0;
		if(*argv[1] == '-')
			except = 1;
		else if(*argv[1] == '+')
			except = -1;
		else
			error("syntax: talkall [+/- name name name]");
		exclist = &argv[2];
	}
	namep = 0;
	gtty(1, &sgb);
	sgb.sg_flag =| TECO;
	stty(1, &sgb);
	low = buf;
	low = copy("\n\n\nNotice from Operator (", low);
	low = copy(getlogn(getluid()), low);
	low = copy(")...\n", low);
	fin = dup(0);
	bp = low;
	printf("Enter message, end with ^D...\n");
	while(c = getchar()) {
		switch(c) {

		case CALTNEW:	if(namep)
					error("Sorry, only one esc allowed");
				namep = bp;
				c = 13;
				do *bp++ = 0;
				while(--c);
				continue;

		case CERASE:	if(bp > low)
					putchar(*--bp);
				if(bp <= namep)
					namep = 0;
				continue;

		case CRETYPE:	write(1, low, bp-low);
				continue;

		case CKILL:	while(bp>=low && *--bp != '\n');
				bp++;
				if(bp <= namep)
					namep = 0;
				continue;

		default:	*bp++ = c;
				if(bp >= &buf[BSIZ])
					error("Character limit exceeded");
		}
	}
	me = getcinfo(-1, &inf);
	if((c = fork()) == -1)
		error("No forks");
	if(c) {
		printf("Child=%d...\n", c);
		exit(0);
	}
	bp = copy("\n\n\n", bp);
	for(c = 0; ; c++) {
		if(c == me) continue;
		if(getcinfo(c, &inf) == -1)
			break;
		if(!inf.c_uid)
			continue;
		if(except) {
			i = swmtch(getlogn(inf.c_uid), exclist);
			if((except > 0 && i >= 0) || (except < 0 && i < 0))
				continue;
		}
		if(namep) {
			low = copy(getfstn(inf.c_uid), namep);
			while(low - namep < 13)
				*low++ = 0;
			*namep =- 'a'-'A';
		}
		low = cat("/dev/", ttyname(c));
		if((low = open(low, 1)) != -1) {
			write(low, buf, bp-buf);
			close(low);
		}
	}
}
