#
/*
 * login [ name ]
 */

#define	ECHO	010

struct {
	char	name[8];
	char	tty;
	char	ifill;
	int	time[2];
	int	ufill;
} utmp;

struct {
	int	speeds;
	char	erase, kill;
	int	tflags;
} ttyb;

#define unsigned char *         /* RAND */

struct inode {          /* RAND */
	char    minor;
	char    major;
	int     inumber;
	int     flags;
	char    nlinks;
	char    uid;
	char    gid;
	char    size0;
	int     size1;
	int     addr[8];
	unsigned actime[2];
	unsigned modtime[2];
} statb;

char	*ttyx;

main(argc, argv)
char **argv;
{
	char pbuf[128];
	register char *namep, *np;
	char pwbuf[9];
	int t, sflags, f, c, uid, gid;
	char mbuf[32];  /* RAND -- buffer for /etc/motd */

	signal(3, 1);
	signal(2, 1);
	nice(0);
	ttyx = "/dev/ttyx";
	if ((utmp.tty=ttyn(0)) == 'x') {
		write(1, "Sorry.\n", 7);
		exit();
	}
	ttyx[8] = utmp.tty;
	gtty(0, &ttyb);
	ttyb.erase = '#';
	ttyb.kill = '@';
	stty(0, &ttyb);
    loop:
	namep = utmp.name;
	if (argc>1) {
		np = argv[1];
		while (namep<utmp.name+8 && *np)
			*namep++ = *np++;
		argc = 0;
	} else {
		write(1, "Name: ", 7);
		while ((c = getchar()) != '\n') {
			if (c <= 0)
				exit();
			if (namep < utmp.name+8)
				*namep++ = c;
		}
	}
	while (namep < utmp.name+8)
		*namep++ = ' ';
	if (getpwentry(utmp.name, pbuf))
		goto bad;
	np = colon(pbuf);
	if (*np!=':') {
		sflags = ttyb.tflags;
		ttyb.tflags =& ~ ECHO;
		stty(0, &ttyb);
		write(1, "Password: ", 10);
		namep = pwbuf;
		while ((c=getchar()) != '\n') {
			if (c <= 0)
				exit();
			if (namep<pwbuf+8)
				*namep++ = c;
		}
		*namep++ = '\0';
		ttyb.tflags = sflags;
		stty(0, &ttyb);
		write(1, "\n", 1);
		namep = crypt(pwbuf);
		while (*namep++ == *np++);
		if (*--namep!='\0' || *--np!=':')
			goto bad;
	}
	np = colon(np);
	uid = 0;
	while (*np != ':')
		uid = uid*10 + *np++ - '0';
	np++;
	gid = 0;
	while (*np != ':')
		gid = gid*10 + *np++ - '0';
	np++;
	np = colon(np);
	namep = np;
	np = colon(np);
/*
 *      The order of the following items was changed so that, in
 *      time (read "our copious spare ____") we can put in a loop
 *      to read motd's from the root down to a person's own directory
 *      (so that, eg, he can leave word for all using that directory;
 *      or a group leader might leave word in the group directory).
 *      Also, since people don't always read the motd, they get a
 *      number of chances to read it (change from RAND). Including
 *      the guy who  s h o u l d  have deleted it last week.
 *
 *      Joe Yao, Science Applications, Inc., 1911 N. Ft. Myer Dr. #1200,
 *      Rosslyn VA 22209        25 March 1977
 *
 */
	if ((f = open("/etc/motd", 0)) >= 0) {
		/* print out message */
		while ((t=read(f, mbuf, 32)) > 0)
			write(1, mbuf, t);
		close(f);
	}
	if (chdir(namep)<0) {
		write(1, "No directory\n", 13);
		goto loop;
	}
	if ((f = open("./motd", 0)) >= 0) {
		while ((t=read(f, mbuf, 32)) > 0)
			write(1, mbuf, t);
		close(f);
	}
	if ((stat (".llog", &statb)) != -1) {
		/* print out last login time */
		printf ("Previous login: %s\n", ctime (statb.modtime));
	}
	/* create and close .llog to record login time */
	close (creat (".llog", 0600));
	time(utmp.time);
	if ((f = open("/etc/utmp", 1)) >= 0) {
		t = utmp.tty;
		if (t>='a')
			t =- 'a' - (10+'0');
		seek(f, (t-'0')*16, 0);
		write(f, &utmp, 16);
		close(f);
	}
	if ((f = open("/usr/adm/wtmp", 1)) >= 0) {
		seek(f, 0, 2);
		write(f, &utmp, 16);
		close(f);
	}
/*
 *      end of re-ordering
 */

	if(stat(".mail", &statb) >= 0 && statb.size1)
		write(1, "You have mail.\n", 15);
	if(newscheck(uid)) write(1, "You've new news to peruse\n", 26);
	chown(ttyx, uid);
	setgid(gid);
	setuid(uid);
	if (*np == '\0')
		np = "/bin/sh";
	execl(np, "-", 0);
	write(1, "No shell.\n", 9);
	exit();
bad:
	write(1, "Login incorrect.\n", 17);
	goto loop;
}

getpwentry(name, buf)
char *name, *buf;
{
	extern fin;
	int fi, r, c;
	register char *gnp, *rnp;

	fi = fin;
	r = 1;
	if((fin = open("/etc/passwd", 0)) < 0)
		goto ret;
loop:
	gnp = name;
	rnp = buf;
	while((c=getchar()) != '\n') {
		if(c <= 0)
			goto ret;
		*rnp++ = c;
	}
	*rnp++ = '\0';
	rnp = buf;
	while (*gnp++ == *rnp++);
	if ((*--gnp!=' ' && gnp<name+8) || *--rnp!=':')
		goto loop;
	r = 0;
ret:
	close(fin);
	fin = 0;
	(&fin)[1] = 0;
	(&fin)[2] = 0;
	return(r);
}

colon(p)
char *p;
{
	register char *rp;

	rp = p;
	while (*rp != ':') {
		if (*rp++ == '\0') {
			write(1, "Bad /etc/passwd\n", 16);
			exit();
		}
	}
	*rp++ = '\0';
	return(rp);
}
/*
 * This depends on your implementation of news. It compares the items already
 * read (found in a table) to the number of items extant.
 */
newscheck(id)
{
#define PERS    "/u1/ss/kent/nips"
#define INDEX   "/u1/ss/kent/index"

	int f,buf1[],buf2[];

	*buf1 = 0;
	*buf2 = 0;
	f = open(PERS,0);
	seek(f,id*2,0);
	read(f,buf1,2);
	close(f);
	f = open(INDEX,0);
	read(f,buf2,2);
	close(f);
	return(*buf1 == *buf2 ? 0 : 1);
}
