#
/*
 * alias [name[.] [prog [args...]] ]  - become another user
 *
 * compile:
 *      cc -O -s alias.c
 *      chmod 6751 a.out
 *      chown 0 a.out
 *      chgrp 0 a.out
 *      mv a.out /usr/bin/alias.
 *
 * uses:
 *
 *      alias                   returns current alias
 *
 *      alias name[.]           invokes a sub-shell for user name, in his
 *                              directory. If invoker is not superuser and
 *                              there is an autostart program in passwd, it
 *                              runs that instead.
 *                              If the name is followed by a dot, the
 *                              directory is not changed.
 *
 *      alias name[.] prog args same as above, except that if there exists
 *                              no autostart program in passwd (or invoker
 *                              is superuser) prog gets run.
 *
 * In all cases, if user is not su and has different uid, a password is
 * required.
 * All i/o is from/to the diagnostic stream, to allow redirection of standard
 * input & output (and to foil command-shellers).
 *
 *      Joseph S. D. Yao
 *      Science Applications, Inc.
 *      1911 N. Ft. Myer Dr. #1200
 *      Rosslyn VA 22209
 *      703-527-7571
 *
 */

#define ECHO    010

char    utmp_name[9];
int     dirflg 0;

struct {
	int	speeds;
	char	erase, kill;
	int	tflags;
} ttyb;

char binstring[] "/usr/bin/xxxxxxxxxxxxxx";
char *shell "/bin/sh";
char	*ttyx;

main(argc, argv)
char **argv;
{
	char pbuf[128];
	register char *namep, *np, *onp;
	char pwbuf[9];
	int t, sflags, f, c, uid, gid;
	int olduid, oldgid;

	olduid = getuid();
	oldgid = getgid() << 8;

	if (argc < 2) {
		/* deliver to diagnostic stream info on current alias */
		if(getpw(oldgid | olduid, pbuf)) {
			write(2,"I don't know: who are you?\n",27);
			return;
		}
		namep = pbuf;
		while(*namep++ != ':');
		namep[-1] = '\n';
		write(2,pbuf,namep - pbuf);
		return;
	}

	/* setup for changing id's and invoking new prog */
	signal(3, 1);
	signal(2, 1);
	nice(0);

	ttyx = "/dev/ttyx";
	if ((ttyx[8] = ttyn(2)) == 'x') {
		/* This should only happen in 2proto */
		write(2, "Sorry.\n", 7);
		exit();
	}

	/*
	 * Transfer the name to utmp_name, stripping off any
	 * terminating period and setting dirflg if it exists.
	 * Blank-pad it, and get the entry in passwd that
	 * corresponds to that logname.
	 */
	namep = utmp_name;
	np = argv[1];
	while (namep<&utmp_name[9] && *np)
		*namep++ = *np++;
	if(namep[-1] == '.') {
		* --namep = ' ';
		dirflg = 1;
	}
	while (namep < &utmp_name[8])
		*namep++ = ' ';
	if (getpwentry(utmp_name, pbuf)) {
		write(2, "No name.\n", 9);
		exit(-1);
	}

	/*
	 * Isolate from the entry line the uid, gid, encrypted
	 * password (if any) (which test against the entered
	 * password if (a) it exists, (b) the invoker is not
	 * superuser, and (c) the invoker has a different uid
	 * from the desired alias), the login directory, and
	 * any extant autostart process.
	 */
	np = colon(pbuf);
	onp = colon(np);
	uid = 0;
	while (*onp != ':')
		uid = uid*10 + *onp++ - '0';
	onp++;
	gid = 0;
	while (*onp != ':')
		gid = gid*10 + *onp++ - '0';
	onp++;
	if ((*np != ':') && (olduid != 0) && (olduid != uid)) {
		gtty(2,&ttyb);
		sflags = ttyb.tflags;
		ttyb.tflags =& ~ ECHO;
		stty(2, &ttyb);
		write(2, "Password: ", 10);
		namep = pwbuf;
		while ((c=getchar()) != '\n') {
			if (c <= 0)
				exit();
			if (namep<pwbuf+8)
				*namep++ = c;
		}
		*namep++ = '\0';
		ttyb.tflags = sflags;
		stty(2, &ttyb);
		write(2, "\n", 1);
		namep = crypt(pwbuf);
		while (*namep++ == *np++);
		if (*--namep!='\0' || *--np!=':') {
			write(2, "Sorry.\n", 7);
			exit(-1);
		}
	}
	namep = colon(onp);
	np = colon(namep);
	np[-1] = '\0';

	if(dirflg == 0)
		if (chdir(namep)<0) {
			write(2, "No directory\n", 13);
			exit(-1);
		}

	if(fork() == 0) {

		/* child process */

		chown(ttyx,gid<<8 | uid);
		setgid(gid);
		setuid(uid);

		if(olduid != 0 && *np != 0) {
			/* autostart program */
			execl(np, "-alias", 0);
			write(2, "No shell.\n", 9);
			exit(-1);
		}

		if(argc > 2) {
			/* program passed as argument */
			/* this looks in all possible places for it */
			argv[argc] = 0;
			execv(argv[2],&argv[2]);

			np = argv[2];
			for(onp = &binstring[9];
			    onp < &binstring[sizeof binstring];
			    onp++)
				if((*onp = *np++) == 0) break;

			execv(&binstring[5],&argv[2]);
			/* the above for rand and yale personal bins */

			execv(&binstring[4],&argv[2]);

			execv(binstring,&argv[2]);

			argv[1] = shell;
			execv(shell,&argv[1]);

			argv[2] = &binstring[5];
			execv(shell,&argv[1]);
			/* the above for rand and yale personal bins */

			argv[2] = &binstring[4];
			execv(shell,&argv[1]);

			argv[2] = binstring;
			execv(shell,&argv[1]);

			write(2, "Program not found.\n", 19);
			exit(-1);
		}

		/*
		 * no autostart or passed program, or
		 * su override on autostart
		 */
		execl("/bin/sh", "-*", 0);
		write(2, "No shell.\n", 9);
		exit(-1);
	}
	else {

		/* parent process */

		while(wait() > 0);
		chown(ttyx,oldgid | olduid);
		exit(0);
	}
}

/*
 * copped from login.c
 * uses getchar to do buffered input from passwd
 */
getpwentry(name, buf)
char *name, *buf;
{
	extern fin;
	register char *gnp, *rnp;
	register int c;
	int r;

	r = 1;
	if((fin = open("/etc/passwd", 0)) < 0)
		goto ret;
loop:
	gnp = name;
	rnp = buf;
	while((c=getchar()) != '\n') {
		if(c <= 0)
			goto ret;
		*rnp++ = c;
	}
	*rnp++ = '\0';
	rnp = buf;
	while (*gnp++ == *rnp++);
	if ((*--gnp!=' ' && gnp<&name[8]) || *--rnp!=':')
		goto loop;
	r = 0;
ret:
	close(fin);
	/* next input from the diagnostic stream */
	fin = 2;
	(&fin)[1] = 0;
	(&fin)[2] = 0;
	return(r);
}

/*
 * also copped from login.c
 */
colon(p)
char *p;
{
	register char *rp;

	rp = p;
	while (*rp != ':') {
		if (*rp++ == '\0') {
			write(2, "Bad /etc/passwd\n", 16);
			exit();
		}
	}
	*rp++;
	return(rp);
}

