#

/*	PROGRAM NAME:  help
 *	
 *	AUTHOR:  pavo
 *	
 *	DATE WRITTEN:  January 3, 1977
 *	
 *	SOURCE LANGUAGE:  c
 *	
 *	LOCATION OF SOURCE:  /usr/pavo/help.c
 *	
 *	LOCATION OF BINARY:  /usr/bin/help
 *	
 *	SYNTAX:
 *		help	[<file>  [<chapter>]  ]
 *	
 *		<file> can be a file associated with locally-written  
 *			news and/or software, or <file> can be a UNIX
 *			command that is found in the UNIX manual
 *			given by the optional parameter <chapter>, the
 *			default is chapter 1 (shell commands).
 *	 	<chapter> is a UNIX manual section (1 through 8) and 
 *			section 1 is default.
 *	
 *	DESCRIPTION:
 *		Help is an online documentation manager that can be used
 *	by both the novice and the experienced user.  Entering "help <cr>"
 *	from the terminal will cause help to guide the user through the 
 *	system documentation file structure.  The documentation system
 *	is setup like the rest of the UNIX file system; on a tree
 *	structure.  The root of the tree is given by the global variable
 *	"root".
 *		For the experienced user, entering "help <file> <cr>" will
 *	cause help to first search for locally-written documentation and then
 *	to search through the UNIX manual in the specified section (defaults
 *	to section 1).  The user may move in both directions in the "tree".
 *	Moving up the tree (away from "root") is the natural progression, as
 *	each new input from the user causes help to check if the entry is a
 *	directory (continue moving up the tree) or a file (print it out and
 *	prompt).  However, a user may enter the characters "/" (return to
 *	root and continue) or ".." (move toward the root one level and
 *	continue) at any time.
 *	
 *	MESSAGES & DIAGNOSTICS:
 *		Most messages will indicate within their context whether
 *	they are informative (expected) or corrective (fatal).  Error
 *	messages such as "cant find <file>" will indicate that the file is not
 *	documented in the root directory or the UNIX manual section specified.
 *	Messages such as "cant {open | read} <file>" may indicate that the 
 *	documentation is not online  (presently, it is mountable as a
 *	file system with root as "/doc").
 *		Help will prompt the user for input with a message "enter
 *	file: ".  Help will wait for input.  Input can be any of the 
 *	followng:
 *		<file>  must be in the current working directory.
 *			<file> will either be listed (if it is a
 *			directory) or printed (if it is a file).
 *		ctrl-d	terminate the program immediately.
 *		INTERRUPT (RUB, DEL, or BREAK) abort type-out.
 *		..	move (back) toward the root one level,
 *			and continue accepting input.
 *		/	move (back) to the root and continue accep-
 *			 ting input.
 *		<number>  consider the file that was listed corre-
 *			sponding with <number> as the file.  
 *			Otherwise, same as <file>.
 *	
 *	SEE ALSO:
 *		man(i)
 *	
 *	FILES USED:
 *		/usr/news	documentation system root
 */
/*  */

/*	G L O B A L    D E C L A R A T I O N S	*/
#include	"/usr/sys/sbuf.h"
#define		ifdir	040000

char		*root	"/usr/news";
char		*man	"/usr/news/documentation/chapter1";
/* WARNING: there is code that uses an index depending on the
   length of the above string in routine "decodesect".
 */

int		bound	0;

main(argc,argp)
int	argc;
char	**argp;
{
	extern int fout, processinput();

/*	Reassign fd 2 so help can be used as login shell, else not needed */
	close(2);	/* assign /dev/tty to fd=2 */
	open("/dev/tty",2); /* fd 0 & 1 are alredy opened by login */
	fout = 2;
	if(argc  ==  1)  {
/*		printf("Documentation available in:\n");	*/
		signal(2,processinput);
		chdir(root);
		list(root);
		processinput();
	} else	if(argc  ==  2)  {
			searchdir(argp[1]);
	} else	if(argc == 3) {
		if(decodesect(argp[2])){
			printf("syntax is: %s [<topic> [<section>]]\n",argp[0]);
			exit(3);
		}
		searchdir(argp[1]);
	} else
		printf("type \"help help\" for help\n");
	exit(1);
}
/**/
/*
 *	search various directories (starting at documentation "root")
 *	for the specified "file".
 */
searchdir(file)
char	*file;
{
	chdir(root);
	if(findfile(file)  ==  -1)  {
		chdir(man);
		if(findfile(file)  ==  -1)  {
			printf("Can't find documentation on \"%s\"\n",file);
			exit(2);
		}
	}
/*	list(".");	*/
/*	processinput();	*/
	exit(0);
}
/**/
/*
 *	move along the file system tree listing directories and
 *	accepting further input or printing files and promptimg
 *	for further input in the existing directory.
 */
findfile(file)
char	*file;
{
	struct	inode	sbuf;
	char	*fptr;
	int	listed;
	
	fptr 	= file;
	listed = 0;
	if(stat(fptr,&sbuf)  !=  -1)  {
		while((ifdir & sbuf.i_mode)  ==  ifdir)  {
/*			printf("Further Documentation available under:\n");	*/
			if(chdir(fptr)  !=  -1)  {
				listed = lsdir(fptr);
			} else	{
				printf("cant change to %s\n",fptr);
				list(".");
			}
			fptr = input();
			while(stat(fptr,&sbuf)  ==  -1)  {
				printf("invalid file:  %s\n",fptr);
				list(".");
				fptr = input();
			}
		}
		if(! listed)  {
		print(fptr);
		}
		return(1);
	} else	{
		return(-1);
	}
}
/**/
/*
 *	list a directory, if there is only 1 active entry, determine
 *	its state (directory or file) and act accordingly.
 */
lsdir(dir_name)
char	*dir_name;
{
	char	*save,	*dptr;
	struct	inode	sbuf;
	int	code;
	save	= dir_name;
	code	= 0;
	
	list(dir_name);
	while(bound  ==  1)  {
		dptr = scandir(1);
		stat(dptr,&sbuf);
		if((ifdir & sbuf.i_mode) == ifdir)  {
			chdir(dptr);
			list(".");
		} else	{
			print(dptr);
			code = 1;
			chdir(save);
			chdir("..");
			list(".");

		}
	}
	return(code);
}
/**/
/*
 *	list a directory's active entries (excluding entries
 *	beginning with ".").  If there are no active entries,
 *	output the fact and reprompt.
 */
list(dir_name)
char	*dir_name;
{
	int	fddir,  inc,  ctr,  red;
	char	dbuf[17],  *dptr;
	dbuf[16] = '\0';
	red 	= 16;
	ctr	= 1;

	chdir(dir_name);
	printf("\nCurrent topics are:\n\n");
	if((fddir = open(".",0))  !=  -1)  {
		while(red == 16)  {
			inc = 0;
			while(inc < 4  && (red = read(fddir,dbuf,16)) > 0)  {
				dptr = dbuf;
				if(*dptr  !=  '\0')  {
					dptr =+ 2;
					if(*dptr  !=  '.')  {
						printf("%3d:%-14s ",ctr++,dptr);
						inc++;
					}
				}
			}
			putchar('\n');
		}
		close(fddir);
		if(ctr == 1)  {
			printf("directory %s has no entries\n",dir_name);
			chdir("..");
		} else	{
			bound = ctr -1;
		}
	}  else	{
		printf("cant read %s\n",dir_name);
		ctr = 0;
	}
	return;
}
/**/
/*
 *	decode the optional chapter specification of the argument
 *	string.  An optional argument that can be passed to help is
 *	the chapter to consider when searching for a command.  The
 *	UNIX manual chapters range from 1 to 8 with 1 being the 
 *	default.  Chapter 1 details shell commands.
 */
decodesect(num)
char	*num;
{

	if(*num <= 070  &&  *num >= 061){
		man[31] = *num;
/* The above index must point to the chapter number in the
 * pathname pointer "*man".
 */
		return(0);
	} else
		return(1);	/* error */
}
/**/
/*
 *	prompt the user for input.  Valid input is one of the
 *	following:
 *	<file>		a file listed by the previous list;
 *			implies <file> in the present working
 *			directory.
 *	<number>	shorthand notation for <file>
 *	/		reset the present working directory at
 *			the documentation root and continue
 *			prompting and accepting input.
 *	..		move toward the root one level;
 *			equivalently, change the present
 *			working directory to the parent
 *			directory of the present working
 *			directory.
 *	ctrl-d		stop this program immediately.
 */
char *input()
{
	static char inbuf[70];
	char	*inptr;
	int	offset;
	extern	int  fin;
	inptr = inbuf;

	printf("\n\n\nselect topic ('?' for help): ");
	if(read(fin,inbuf,70)  ==  0)  {
		putchar('\n');
		exit(0);
	}  else	{
		while(*inptr != '\n')  {
			inptr++;
		}
		*inptr = '\0';
		inptr = inbuf;
		if(*inptr >= '0' && *inptr <= '9') {
			offset = atoi(inbuf);
			return(scandir(offset));
		} else	if(compstr("/",inbuf))  {
				return(root);
		} else if(compstr("?",inbuf)) {
			help();
			return(".");
		} else	{
			return(inptr);
		}
	}
}
/*  */
/*
 *	output the contents of a file.
 */
print(file)
char	*file;
{	
	register int fd, cnt;
	char buf[512];

	if((fd = open(file,0))  !=  -1)  {
		printf("\n============================   %s   ========================\n\n",file);
		while((cnt = read(fd, buf, 512)) > 0)
			write(1, buf, cnt);
		printf("\n============================================================\n\n");
		close(fd);
		return;
	}  else	{
		printf("cannot open %s for reading\n",file);
		return;
	}
}
/*  */
/*
 *	compare two strings for equivalent values.
 */
compstr(first,second)
char	*first,	*second;
{
	int	i,	size;
	size  =  i  =  0;

	size = sizstr(first);
	if(size != (sizstr(second)))
		return(0);
	while(*first != '\0'  &&  *first++  ==  *second++)
		i++;
	return(i == size ? 1:0);
}
/*
 *	return the size of a string (number of bytes).
 */
sizstr(str)
char	*str;
{
	int	size;
	size	= 0;

	while(*str++  !=  '\0')  {
		size++;
	}
	return(size);
}
/*  */
/*
 *	given a number, find that corresponding entry in the
 *	current working directory.  When "lsdir" outputs the direc-
 *	tory's active entries, it prints a number beside each entry.
 *	This number may be input by the user instead of the file 
 *	name, if desired.  If a number is input to "helpin", "scandir"
 *	will scan the current working directory and find the correspond-
 *	ing entry, if there is one.
 */
char *scandir(offset)
int	offset;
{
	int	ctr,  fddir;
	static char dbuf[17];
	char	*dptr;

	dbuf[16] = '\0';
	ctr = 1;

	if((fddir = open(".",0))  !=  -1)  {
		while(read(fddir,dbuf,16) > 0)  {
			dptr = dbuf;
			if(*dptr  !=  '\0')  {
				dptr =+ 2;
				if(*dptr  !=  '.')  {
					if(ctr++ == offset)  {
						close(fddir);
						return(dptr);
					}
				}
			}
		}
		printf("%d too large\n",offset);
	} else	{
		printf("cant open '.'\n");
	}
	return(".");
}
/**/
/*
 *	coordinate the input and processing routines of help.
 *	This routine, once entered, will never return.
 */
processinput()
{
	char	*in;
	struct	inode	sbuf;
	int	listed;
	extern int reset();
	
	setexit();
	signal(2, reset);
	while(1)  {
		in = input();
		if(! done(in))  {
			if(stat(in,&sbuf)  !=  -1)  {
				if((ifdir & sbuf.i_mode) == ifdir)  {
					listed = lsdir(in);
				} else	{
					print(in);
					lsdir(".");	
				}
			} else	{
				printf("invalid input: %s\n",in);
				lsdir(".");
			}
		} else
			break;		/* terminate while loop */
	}
	exit(0);
}

/*
 * done -- see if this is a "quit" command
 */
done(s)
char *s;
{
	return(
	compstr("stop",s) || compstr("quit",s) || compstr("end", s)
	);
}

/*
 * help -- help the user
 */

help()
{
	printf("\nenter a name or a number to see more documentation\n");
	printf("type ^D, 'stop' 'end' or 'quit' to exit the program\n");
	printf("type '..' to return to previous documentation level\n");
	printf("type '/' to return to documentation root\n");
	printf("type BREAK or RUB or DEL to abort a type out\n");
	printf("type '?' for this message\n\n");
	printf("If the text scrolls off of the screen before you can\n");
	printf("read it, type the ESC key to stop it, type ESC to restart\n");
}
