#

/*	ass -- logically assign an assignable device
 *
 *	usage:	ASS  [dev1  [dev2  ...]  ]
 *	        (if no arguments are present ASS will print
 *	        the assignment list)
 *
 *	description:  ASS logically assigns devices that can be
 *		assigned.  Presently, unfortunately, there is no
 *		system mechanism to force a user to assign and deas-
 *		sign resources to use them.  but, keeping in mind that
 *		anyone can write to any writable device regardless
 *		of what is there (eg: backup tape on dec-drive, image
 *		on the COMTAL,...), these procedures (ASS and DEASS)
 *		will safeguard devices that are in use but are
 *		presently idle.  ASS and DEASS can easily be
 *		thought of as a "begin/end" pair that enclose (protect)
 *		a device.
 *
 *	note:	assignments can only be made to logon-name.
 *
 *	assumptions:	1)  maximum filename is 14 chars long
 *			2)  maximum user name (logon name) is 8 chars long
 *			3)  maximum device name is 19 chars long
 *
 *	files:	/etc/passwd   		password file
 *		/etc/utmp     		logon file
 *		/usr/sys/sbuf.h		inode structure for "stat" calls
 *		/dev			device directory (system resources)
 *
 *	source:	/usr/pavo/ass.c
 *
 *	object:	/usr/bin/ass
 *
 *	see also:  /usr/pavo/deass.c
 *
 *					...  pavo	10-76
 */

#include	"/usr/sys/sbuf.h"	/*sbuf structure for "stat" */
#define		bin	3		/*system ownership id */
#define		protect 01600		/*protected file mode */
#define		isvtx	01000		/*assignable device flag */
#define		unprot	01666		/*unprotect file mode */



main(argc,argp)
int	argc;
char	**argp;

{	int	argnum;
	argnum	= 0;

	if(argc == 1)  {
		printf("To assign a device:  assign [dev1  [dev2  ...]  ]\n\n");
		list();			/*print assignment list */
	}
	else  {
		while((++argnum) < argc)
			assign(argp[argnum]);
	}
	exit(0);
}

/*	assign -- assign the next device
 *
 *	usage:	assign(devicename)
 *
 *	steps:	1)  declare and initialize local variables.
 *		2)  check for the first 5 characters of devicename
 *		    equal to "/dev/";
 *		    if not, prefix devicename with "/dev/".
 *		3)  check status of device and current owner.
 *		4)  if device assignable and current owner is system,
 *		    assign device to calling logon-name.
 *		5)  if device assignable and current owner is user, 
 *		    check if user is still logged-on:
 *		    if so, print message indicating current owner
 *		    if not, assign device to calling logon-name.
 *
 *					...  pavo	11-76
 */

assign(devname)
char	*devname;

/*	<step 1>	*/
{	char	*dev,	*devprefx;
	char	devbuf[20];
	int	i;	
	struct	inode sbuf;
	devprefx  = "/dev/";
	dev	= devbuf;

/*	<step 2>	*/
	i = 0;
	while(i < 5  &&  *devname != '\0')  {
		*dev++  =  *devname++;
		i++;
	}
	devname =- i;
	*dev = 0;
	dev  =  devbuf;
	if((compstr(devprefx,dev)) != 1) {
		while(*dev++ = *devprefx++) {}
		dev--;
		while(*dev++ = *devname++) {}	
		devname = devbuf;
	}

/*	<step 3>	*/
	if((stat(devname,&sbuf)) < 0) {		/*device nonexistent */
		printf("%s:	nonexistent device!\n",devname);
		return;
	}
	if((sbuf.i_mode & isvtx) != isvtx)  {
		printf("%s:	unassignable device!\n",devname);
		return;
	}

/*	<step 4>	*/
	if(sbuf.i_uid == bin) 			/*unassigned device */
		chdev(devname);

/*	<step 5>	*/
	else  {
		if(logdin(sbuf.i_uid))  {
			dev  =  getun(sbuf.i_uid);
			printf("%s:	assigned to %s\n",devname,dev);
		}
		else 
			chdev(devname);
	}
	return;
}

/*	logdin -- find if a user is still logged-on to UNIX 
 *
 *	usage:	LOGDIN(userid)
 *	        where   "userid" is returned from a "getuid" call
 *
 *	returns:
 *		 0	"userid" is not currently logged-on
 *		 1	"userid" is currently logged-on
 *
 *	steps:	1)  declare and initialize local variables.
 *		2)  get device owner's name from password file pointed at
 *		    by argument passed to logdin.
 *		3)  scan utmp file for logged-on user; return appropriate
 *		    flag depending on result.
 *
 *					...  pavo	10-76
 */

logdin(usid)
int	usid;

/*	<step 1>	*/
{	char	*online,  *devowner;
	char	onlinbuf[16];
	int	fdes;
	online 	= onlinbuf;

/*	<step 2>	*/
	devowner = getun(usid);
	if(devowner == -1)  
		return(0);
	
/*	<step 3>	*/
	fdes = open("/etc/utmp",0);
	while(read(fdes,online,16) == 16) {
		if(*online  !=  '\0')  {
			online = onlinbuf;
			online[8] = 0;
			while(*online++  !=  ' ')  {}
			online--;
			*online = '\0';
			online = onlinbuf;
			if(compstr(online,devowner) > 0)  {
				close(fdes);
				return(1);
			}
		}
	}
	close(fdes);
	return(0);
}

/*	list -- print out the device assignment list
 *
 *	usage:	list()
 *
 *	Note:  LIST will print only those devices that are assignable. 
 *
 *	2nd note:  LIST will deassign all devices which are currently
 *		assigned to users that are not logged-on to UNIX.
 *
 *	steps:	1)  declare and initialize local variables.
 *		2)  begin scanning device directory checking for all
 *		    assignable devices.
 *		3)  corresponding to listing mode, print information.
 *
 *					...  pavo	11-76
 */
list()

/*	<step 1>	*/
{	char	*devinfo,  *devname,   *devprefx;
	char	infobuf[16],  device[20];
	int	fdes;
	struct	inode	sbuf;
	devname = device;

/*	<step 2>	*/
	chdir("/dev");
	fdes = open("/dev",0);
	while(read(fdes,infobuf,16) == 16)  {
		devinfo = infobuf;
		if(*devinfo != '\0')  {
			devinfo[16] = 0;
			devinfo =+ 2;
			devprefx = "/dev/";
			while(*devname++ = *devprefx++)  {}
			devname--;
			while(*devname++ = *devinfo++)  {}
			devname = device;
	
	/*	<step 3>	*/
			if(stat(devname,&sbuf) != -1)  {
				if((sbuf.i_mode & isvtx) == isvtx)  {
					if(sbuf.i_uid == bin  || (!(logdin(sbuf.i_uid))))  {
						chown(devname,(bin<<8)|bin);
						chmod(devname,unprot);
						printf("%s:	unassigned\n",devname);
					}
					else  {  
						devinfo = getun(sbuf.i_uid);
						printf("%s:	assigned to %s\n",devname,devinfo);
					}
				}
			}
		}
	}
	close(fdes);
	return;
}

/*	getun -- get a user name given its index
 *
 *	usage:	getun(userid)
 *		where 	"userid" is an integer returned from a "getpw" call
 *
 *	returns:
 *  		?   -   a pointer to the null-terminated name
 *	       -1   -	error
 *
 *	steps:	1)  declare and initialize local variables.
 *		2)  get user's process word and extract user name.
 *
 *					...  pavo	11-76
 */

getun(userid)
int	userid;

/*	<step 1>	*/
{	static 	char   tempbuf[10];
	char	namebuf[75];
	char	*temp,	*name;
	name 	= namebuf;
	temp	= tempbuf;

/*	<step 2> 	*/
	if(getpw(userid,name)	!=  0)  {
		return(-1);
	}
	name = namebuf;
	while((*temp++ = *name++) != ':')  {}
	temp--;
	*temp = 0;
	name = tempbuf;
	return(name);
}

/*	compstr -- compare two strings
 *
 *	usage:	compstr(str1,str2)
 *		where	"str1" is a pointer to a string,
 *			"str2" is a pointer to a string,
 *
 *
 *	returns:	1   -   strings are equal
 *			0   -   strings are unequal
 *
 *	steps:	1)  declare and initialize variables
 *		2)  get sizes of both strings (terminated with '0')
 *		3)  check char with char 
 *		4)  return appropriate flag
 *
 *					...  pavo	11-76
 */

compstr(first,second)
char	*first,	*second;

/*	<step 1>	*/
{	int	i,	size;
	size  =  i  =  0;

/*	<step 2>	*/
	size = sizstr(first);
	if(size != (sizstr(second)))
		return(0);
	while(*first != '\0'  &&  *first++  ==  *second++)
		i++;

/*	<step 3>	*/
	if(i == size)
		return(1);
	else	
		return(0);
}

/*	sizstr -- get the size of a string
 *
 *	usage:	sizstr(string)
 *		where "string" is a character pointer pointing to
 *			a null-terminated ('0') string.
 *
 *	returns:  the size of the string
 *
 *	important:  "string" MUST be terminated by '0' for "sizstr" to
 *		work correctly.
 *
 *	steps:	1)  declare and initialize all local variables.
 *		2)  find and return size of the string.
 *
 *					...  pavo	11-76
 */

sizstr(str)
char	*str;

/*	<step 1>	*/
{	int	size;
	size	= 0;

/*	<step 2>	*/
	while(*str++  !=  '\0')  {
		size++;
	}
	return(size);
}

/*	chdev -- change id and mode of a device
 *
 *	usage:	chdev(devname)
 *
 *	returns:   1   -   successful
 *		  -1   -   unsuccessful
 *
 *	note:  This version will always change the device's id to that
 *		of the requesting user; the mode will always be
 *		changed to "protected", allowing only the requesting
 *		user or super-user to write on the device.
 *
 *	steps:	1)  declare and initialize local variables.
 *		2)  change mode and owner if device exists
 *
 *					...  pavo	11-76
 */

chdev(devname)
char	*devname;

/*	<step 1>	*/
{	int	user;
	char	*name;
	struct	inode	sbuf;

/*	<step 2>	*/
	user = getuid() & 0377;
	chown(devname,(bin<<8)|user);
	chmod(devname,protect);
	name = getun(user);
	printf("%s:	now assigned to %s\n",devname,name);
	return(1);
}

