#define ALLOC	0100000
#define TYPE	 060000
#define CHAR	 020000
#define DIR	 040000
#define LARGE	 010000
#define SUID	  04000
#define SGID	  02000
#define READ	   0444
#define WRITE	   0222
#define XEQ	   0111
#define OWNER	   0700
#define GROUP	   0070
#define OTHERS	   0007

struct statb {
	int	device;
	int	inumber;
	int	flags;
	char	nlinks;
	char	uid;
	char	gid;
	char	size0;
	int	size1;
	int	addr[8];
	int	actime[2];
	int	modtime[2];
} x;


struct {
	char	d_main;
	char	d_sup;
	char	*d_name;
} devices[] {
	(6<<8) + 0,"/dev/hp00",
	(6<<8) + 1,"/dev/hp01",
	(6<<8) + 2,"/dev/hp02",
	(6<<8) + 3,"/dev/hp03",
	(6<<8) + 4,"/dev/hp04",
	(6<<8) + 5,"/dev/hp05",
	(0<<8) + 0,"/dev/rk0",
	(0<<8) + 1,"/dev/rk1"
};

struct {
	int	devnr;
};

char	*getdevice(devicenr){
	register	int i;
	for(i = 0; i < sizeof devices /4; i++){
		if( devices[i].devnr != devicenr) continue;
		return(devices[i].d_name);
	}
	return("");
}

char	tbuf[16];
char	tbufg[16];
int	uidfil	-1;
int	gidfil	-1;
int	olduid	-1;
int	oldgid	-1;

struct {
	int	fdes;
	int	nleft;
	char	*nextp;
	char	buff[512];
} inf;

#define	UID	0
#define	GID	1
getname(id, buf,fie)
char buf[];
{
	register  int c, n, i;
	int j;
	if(fie == UID){
		if(olduid == id) return(0);
		else olduid = -1;
	} else
	if(oldgid == id) return(0);
	else oldgid = -1;
	inf.fdes = (fie == UID)?uidfil:gidfil;
	seek(inf.fdes, 0, 0);
	inf.nleft = 0;
	do {
		i = 0;
		j = 0;
		n = 0;
		while((c=getc(&inf)) != '\n') {
			if (c<=0)
				return(-1);
			if (c==':') {
				j++;
				c = '0';
			}
			if (j==0)
				buf[i++] = c;
			if (j==2)
				n = n*10 + c - '0';
		}
	} while (n != id);
	buf[i++] = '\0';
	if(fie == UID) olduid = n;
		else oldgid = n;
	return(0);
}

main(argc,argv) int argc; char **argv;{
	register int i;
	register int spec;
	extern ldivr;
	if(argc==1){argv[1]="."; argc++;}
	while(--argc){
	argv++;
	spec = 0;
	if(stat(*argv,&x)<0){printf("%s not found\n",*argv);continue;}
	printf("\nfile: %s\n",*argv);
	printf("\tdevice no:\t%o\t%s\n",x.device,getdevice(x.device));
	printf("	i number:	%d\n", x.inumber);
	printf("	flags:		%o", x.flags);
		if(x.flags & LARGE)
			if(x.addr[7])
				printf(" hudge");
			else
				printf(" large");
		if(x.flags & DIR){
			if(x.flags & CHAR) {
				printf(" bdev");
				spec++;
			}
			else printf(" dir");
		} else	if(x.flags & CHAR) {
				printf(" cdev");
				spec++;
			}
	printf("\n");
	if((i = x.nlinks) != 1){
		if(i)printf("	%d links\n",i);
		else printf("	no links\n");
	}
	uidfil = open("/etc/passwd",0);
	gidfil = open("/etc/group",0);
	if(getname(x.uid,tbuf,UID)!=0) *tbuf = '\0';
	if(getname(x.gid,tbufg,GID)!=0) *tbufg = '\0';
	printf("\tuid:  %-6.6s (%d)\tgid:  %-6.6s (%d)\n",
		tbuf,x.uid,tbufg,x.gid);
	if(!spec) {
		i = ldiv(x.size0,x.size1,512); if(ldivr)i++;
		printf("	size: %7s bytes (%d blocks)\n",
			locv(x.size0,x.size1),i);
		if(x.flags & DIR)
			printf("\t%l (possibly empty) entries in directory\n",
				x.size1/16);
		printf("	blocks:");
		for(i=0;i<8;i++)printf("  %d",x.addr[i]);
		printf("\n");
	}
	else 
		printf("\tmajor dev nr: %d, minor dev nr: %d\n",
			x.addr[0]>>8,x.addr[0] & 0377 );
	printf("	last access:	%s", ctime(x.actime));
	printf("	last modif.:	%s", ctime(x.modtime));
	}
}
