//
//	PDP 11/40 simulator
//
//	Paul Klint
//	Mathematisch Centrum
//	Amsterdam
//	1976
//
//	Illegal instruction interrupts are catched, and the
//	following instructions are simulated:
//
//
//		00 67 dd	sxt
//
//		07 0r ss	mul	(EIS option)
//		07 1r ss	div	(EIS option)
//		07 2r ss	ash	(EIS option)
//		07 3r ss	ashc	(EIS option)
//		07 4r dd	xor
//
//		07 77 nn	sob
//
//	Other illegal opcodes result in a halt.
//	Condition codes are set correctly during exit from
//	the simulator.

C=1			/ condition codes
V=2
Z=4
N=10
halt=0
iot=4
rti=2
.globl	_eis,pdp05,spsw
_eis:	tst	reenter		/ prevent reentrancy
	beq	1f
	halt
1:	inc	reenter
	mov	(sp)+,spc	/ save all registers
	mov	(sp)+,spsw
	mov	sp,ssp
	mov	r0,-(sp)
	mov	r1,-(sp)
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	r4,-(sp)
	mov	r5,-(sp)
	mov	ssp,-(sp)
	mov	spc,r5
	sub	pdp05,r5
	mov	(r5)+,r1	/ fetch offending instruction
	mov	r1,r0		/ r1 == instruction
	mov	r5,-(sp)	/ save updated pc
	mov	r0,instr
	bic	$77,r0
	cmp	r0,$6700
	bne	1f		/ sxt?
	mov	$i.sxt,r5
	br	2f
1:	bic	$7700,r0
	cmp	r0,$70000
	bne	badins
	movb	instr+1,r0
	bic	$!16,r0		/ isolate instruction  number
	mov	sw(r0),r5	/ use switch table sw to exclude
				 / illegal instructions
	bne	2f

badins:	halt
2:				/ r5 == adr of simulation routine
	mov	r1,r0		/ r0 := instruction
	bic	$!700,r0	/ isolate reg #
	mov	$5,r3
1:	asr	r0
	dec	r3
	bne	1b
	mov	r0,regnum	/ save it
	mov	ssp,r3
	mov	r3,r4
	sub	r0,r4		/ adr of saved reg -> r4
	cmp	r5,$i.sob
	beq	i.sob		/ sob treated apart
	mov	r4,regbase	/ save r4 for restore routine
	mov	r1,r0		/ r0 := instruction
	asr	r0
	asr	r0
	asr	r0
	bic	$!7,r0		/ mode -> r0
	asl	r1
	bic	$!16,r1
	sub	r1,r3
	mov	r3,r1
	mov	$2,r2		/ a useful constant
	sub	r2,r1		/ adr of saved reg -> r1
	mov	r0,r3
	bic	$1,r3
	jmp	*1f(r3)		/ perform addressing

	.data
1:	m00x			/ register mode
	m01x			/ auto increment mode
	m10x			/ auto decrement mode
	m11x			/ index mode
	.text

m00x:	mov	r1,r3
	br	cont

m01x:	mov	(r1),r3		/ fetch address
	add	r2,(r1)		/ and increment reg afterwards
	br	cont

m10x:	sub	r2,(r1)		/ decrement reg first
	mov	(r1),r3		/ and fetch address
	br	cont

m11x:	mov	(sp),r3		/ pc (on top of stack) to r3
	mov	(r3),r3		/ fetch offset from pc
	add	r2,(sp)		/ increment pc
	add	(r1),r3		/ r3 := reg + offset
/	br	cont

cont:	bit	$1,r0		/ deferred mode
	beq	1f
	mov	(r3),r3
1:
	mov	(r3),r2		/ set up parameters 
	mov	-(r4),r0
	mov	-(r4),r1
	mov	$spsw,r4
	jmp	(r5)		/ to simulation routine

	.data
sw:	i.mul
	i.div
	i.ash
	i.ashc
	i.xor
	0			/ illegal instruction
	0			/ illegal instruction
	i.sob
	.text


//
//	common restore routine
//	entry rest01:
//		r0,r1 contain result of simulated instruction
//		which must be stored in reg and reg|1
//

rest01:	mov	regbase,r2
	bit	$2,regnum		/ odd reg ?
	bne	1f
	mov	r0,-(r2)
1:	mov	r1,-(r2)
rest:
	mov	(sp)+,spc		/ restore registers
	mov	(sp)+,ssp
	mov	(sp)+,r5
	mov	(sp)+,r4
	mov	(sp)+,r3
	mov	(sp)+,r2
	mov	(sp)+,r1
	mov	(sp)+,r0
	mov	ssp,sp
	mov	spsw,-(sp)
	mov	spc,-(sp)
	clr	reenter
	rti

//
//	Set conditions N and Z depending on the value of r0.
//	Input:	r0	value returned by simulation routine
//		r4	address of spsw
//	output:	N,Z	set conditionally
//
//	Jumps on exit to rest.
//

setNZ:	tst	r0
	beq	1f
	bgt	rest
	bis	$N,(r4)
	br	rest
1:	bis	$Z,(r4)
	br	rest

//
//	Set conditions N and Z conditionally depending on the
//	value of r0-r1, considered as double length integer.
//	input:	r0,r1	value delivered by simulation routine
//		r4	address of spsw
//	output:	N,Z	set conditionally depending on r0-r1
//
//	Jumps on exit to rest01, to restore r0-r1
//

dsetNZ:	tst	r0
	beq	1f
	bgt	rest01
	bis	$N,(r4)
	br	rest01
1:	tst	r1
	bne	rest01
	bis	$Z,(r4)
	br	rest01

//
//	The following simulation routines expect as
//	input parameters:
//
//		r0,r1	reg,reg+1
//		r2	value of source operand
//		r3	address of source (destination) operand
//		r4	address of spsw
//	Output is either delivered in r0,r1 (and return via dsetNZ)
//	or is stored directly via (r3) (and return via setNZ).
//
//	Exception: i.sob
//	input:
//		r1	instruction
//		r4	adr+2 of saved reg
//	output:	(sp)	modified if reg != 0
//

//
//	Simulate sxt
//

i.sxt:	mov	$-1,r0
	bit	$N,(r4)		/ was N bit set ?
	bne	1f
	clr	r0
	bis	$Z,(r4)		/ set Z bit
1:	mov	r0,(r3)		/ restore result
	br	rest


//
//	Simulate sob
//

i.sob:	dec	-(r4)		/ decrement the register
	beq	rest		/ return if it is not zero
	bic	$!77,r1		/ isolate branch offset
	asl	r1
	sub	r1,(sp)		/ and update pc with offset
	br	rest


//
//	Simulate xor
//

i.xor:	bic	$N|Z|V,(r4)	/ clear relevant conditions
	mov	r2,r1
	bic	r0,r1
	bic	r2,r0
	bis	r1,r0
	mov	r0,(r3)		/ restore result
	jbr	setNZ

//
//	Simulate ashc
//

i.ashc:	mov	$rashc,r5
	mov	$rashc1-rashc,r3	/ r3 := offset to neg. shift code
	bit	$2,regnum
	beq	1f
	mov	r0,r1		/ ashc degenerates for odd reg
1:	jsr	pc,shift
	jbr	dsetNZ


i.ash:	mov	$rash,r5
	mov	$rash1-rash,r3	/ offset to neg. shift code
	jsr	pc,shift
	mov	regbase,r3
	mov	r0,-(r3)
	jbr	setNZ

rashc:	asl	r1		/ ashc positive
	rol	r0
2:	bvc	1f
	bis	$V,(r4)		/ set V bit if sign changed
1:	br	shloop

rash:	asl	r0		/ ash positive
	br	2b

rashc1:	asr	r0		/ ashc negative
	ror	r1
	br	shloop

rash1:	asr	r0		/ ash negative
	br	shloop

//
//	Shift: common subroutine for i.ash and i.ashc,
//	which performs the actual shift operation.
//	input:	r0,r1,r2,r4 as i.ash, i.ashc
//
//		r5	address of action code for pos shift.
//		r3	offset to action for neg. shift (i.e
//			r5+r3 is address for this code)
//	output:	r0,r1
//	destroys:
//		r2,r3,r5

shift:	clrb	(r4)		/ clear all condition codes
	bit	$40,r2		/ negative shift count ?
	beq	1f
	neg	r2
	add	r3,r5		/ action code for neg. shift
1:	bic	$!77,r2
	beq	1f		/ zero shift ?
2:	jmp	(r5)		/ perform action
shloop:				/ and return here
	dec	r2
	bne	2b
	bcc	1f
	bis	$C,(r4)		/ record carry bit
1:	rts	pc


//
//	Simulate div
//

i.div:
	clrb	(r4)		/ clear conditions
	mov	$-17.,r3	/ initialize loop counter
	clr	sign
	tst	r0
	bpl	1f
	com	sign
	neg	r1
	adc	r0
	neg	r0
1:	tst	r2
	bpl	1f
	comb	sign+1
	neg	r2

1:	tst	r2		/ divide by zero?
	bne	1f
	bis	$V|C,(r4)
	br	2f
1:	cmp	r0,r2		/ quotient > 15 bits ?
	blos	dloop
	bis	$V,(r4)
2:	jbr	rest01

dloop:	clc
	cmp	r2,r0
	bhi	1f
	sub	r2,r0
	sec
1:	rol	r1
	rol	r0
	bcc	1f
	halt			/ cannot happen !!
1:
	inc	r3
	bne	dloop


dend:	clc
	ror	r0		/ correct remainder
	tstb	sign
	beq	1f
	neg	r0
1:	tstb	sign+1
	beq	1f
	neg	r1
1:
	mov	r0,r2
	mov	r1,r0
	mov	regbase,r3
	mov	r0,-(r3)
	mov	r2,-(r3)
	jbr	setNZ



//
//	Simulate mul
//

i.mul:
	clrb	(r4)		/ clear all conditions
	clr	r5		/ r5 == sign of result
	mov	r0,r1

	bpl	1f
	com	r5
	neg	r1		/ note that $100000 is not complemented !
1:	tst	r2
	bpl	1f
	com	r5
	neg	r2		/ id.
1:	mov	$-16.,r3	/ initialize loop counter
	mov	$1,r4		/ a usefull constant inside dloop
	clr	r0

mloop:	bit	r4,r1
	beq	1f
	add	r2,r0		/ add r2 if r1 odd
1:	ror	r0
	ror	r1
	clc
	inc	r3
	bne	mloop		/ if not all bits handled

mulend:
	mov	$spsw,r4
	tst	r0		/ result > 16 bits ?
	beq	1f
2:	bis	$C,(r4)		/ no !
	br	3f
1:
	tst	r1		/ or result even > 15 bits 
	bmi	2b
3:
	tst	r5		/ negative result required ?
	beq	2f
minus:	neg	r1
	adc	r0
	neg	r0
2:	jbr	dsetNZ

.bss
spc:.=.+2
spsw:.=.+2
ssp:.=.+2
regnum:.=.+2
regbase:.=.+2
instr:.=.+2
sign:.=.+2
.data
reenter:0
pdp05:0
.text
