#define unsigned char *
/* unsigned definition by jal and jsz to fix date compare bug */
struct
	{
	char	minor;
	char	major;
	int	inumber;
	int	flags;
	char	nlinks;
	char	uid;
	char	gid;
	char	size0;
	int	size1;
	int	addr[8];
	unsigned actime[2];
	unsigned modtime[2];
	} inode;
char nextname[15] "		 ";
char filename[200];
int tblocks  0;
int totblks  0;
/* next line changed from cr0 to cr1 by l. heiser 11/15/74 */
char allnames[512]  "/bin/tp cr1";
char *allptr;
char *argtp[150];
int nfilenum 2;
int nfiles, nch;
int tnch 12;
unsigned timbuf[2];
char	*cbp;

char *tzname[2];
int	dmsize[];
char	cbuf[];
char	*cbp;

main(argc,argv)
	int argc;
	char *argv[];
	{
	allnames[7] = "\0";
	argtp[0] = allnames;
	argtp[1] = allnames + 8;
	allptr = allnames + 12;   /* start of filename vector for tp */

	printf("\nready tape %c? (y)",allnames[10]);
	while (getchar() != 'y');

	if (argc == 1)			   /* arg1 is the directory name,   */
		{			   /*  "/rnd" is not specified	    */
		argc = 2;		   /* date and time, etc. need	    */
		argv[1] = "/rnd";	   /* be inputted somehow	    */
		}
	if (*argv[1] >= '0' && *argv[1] <= '9')
		{
		getdate(argv[1]); /* fill timbuf   */
		argc--;
		argv++;
		}
	if (argc == 1)			   /* arg1 is the directory name,   */
		{			   /*  "/rnd" is not specified	    */
		argc = 2;		   /* date and time, etc. need	    */
		argv[1] = "/rnd";	   /* be inputted somehow	    */
		}
	while (--argc) pdir(*++argv,filename);
	writetape();
	printf("ALL DONE!\n");
	}

pdir(file,fn)
	char *file, *fn;
	{
	int fd, ftype;
	char *nfile;
	register char *snp, *lnp;
	char *argv[150];
	/* set up the small name pointer (snp)
		and the long name pointer (lnp)       */
	snp = file;
	lnp = fn;

	/* put in "/" at end of the long name, after first time */
	if (lnp != filename) *(lnp-1) = '/';
	/* if the directory was "/", the following line prevents "//..."  */
	if (lnp == filename+2 && *filename == '/') lnp--;

	/* copy the small name to the end of the long name	*/
	while (*lnp++ = *snp++);

	if (stat(filename,&inode) == -1)
		{
		printf("Not a valid directory!\n");
		return;
		}
	if ((ftype=((inode.flags>>13)&03)) == 02)
		{
		/* open up the directory  */
		fd = open(filename,0);
		if (fd < 0)	 /* failure! should not happen */
			{
			printf("Cannot open %s\n",filename);
			return;
			}

		getnext(fd);	/* skip over "." */
		getnext(fd);	/* and ".."	 */

		/* get all the files in the directory and recurse */
		while (nfile = getnext(fd)) pdir(nfile,lnp);
		close(fd);
		}
	else

	     if (ftype == 0 && (inode.modtime[0] >  timbuf[0] ||
			       (inode.modtime[0] == timbuf[0] &&
				inode.modtime[1] >= timbuf[1])))
		{
		nch = lnp - filename;
		tblocks  = nblock(inode.size0,inode.size1);
		if (totblks+tblocks >= 550)
			{
			writetape();
			argtp[1] = allnames+8;/* clear next time */
			allnames[10]++;
		     /* next line changed from allnames[10] = '0' to */
		     /*  allnames[10] = '1' by l. heiser 11/15/74 */
			if (allnames[10] == '8') allnames[10] = '1';
			nfiles = totblks = 0;
			printf("\nready tape %c? (y)",allnames[10]);
			while (getchar() != 'y');
			}
		else if (tnch+nch >= 450)
			{
			writetape();
			argtp[1] = allnames+9; /* don't clear next time */
			}
		nfiles++;
		tnch =+ nch;
		totblks =+ tblocks;
		printf("%d\t%d\t%d\t%d\t%d\t%s\n",nfiles,tblocks,totblks,
			nch,tnch,filename);
		argtp[nfilenum++] = allptr;
		strcopy(allptr,filename);
		while (*allptr++);
		}
	return; /* note that this is the only way out of pdir  */
	}



/* get the next file of the current open directory */
char *getnext(fildes)
	int fildes;
	{
	int filnum;
	do
		{
		if (read(fildes,&filnum,2) != 2) return;
		if (read(fildes,nextname,14) != 14) return;
		}
	while(filnum==0);
	return(nextname);
	}

/* find # of blocks in file */
nblock(size0,size1)
	char *size0, *size1;
	{
	register int n;
	n = ldiv(size0, size1, 512);
	if (size1&0777)
		  n++;
	return(n);
	}

/* string copy for filenames*/
strcopy (*fn1,*fn2)
	char *fn1, *fn2;
	{
	while (*fn1++ = *fn2++);
	}

/*write the tape*/
writetape()
	{
	int len;
	int pid;
	len = allptr - allnames;
	printf ("%d length\n",len);
	argtp[nfilenum] = 0;
	pid = fork();
	if (pid)
		{
		while (pid != wait());
		nfilenum = 2;
		allptr = allnames + 12;
		tnch = 12;
		return;
		}
	else
		{
		execv("/bin/tp",argtp);
		printf("FAILED!\n");
		}
	}
getdate(date)
	char *date;
	{
	register char *tzn;
	extern int timezone, *localtime();


	cbp = date;
	if(gtime()) {
		write(1, "bad conversion\n", 15);
		exit();
		}
	/* convert to Greenwich time, on assumption of Standard time. */
		dpadd(timbuf, timezone);
	/* Now fix up to local daylight time. */
		if (localtime(timbuf)[8])
			dpadd(timbuf, -1*60*60);
	  printf ("time in seconds %lx%lx \n",timbuf[0],timbuf[1]);

	}
gtime()
{
	register int i;
	register int y, t;
	int d, h, m;
	extern int *localtime();
	int nt[2];

	t = gpair();
	if(t<1 || t>12)
		goto bad;
	d = gpair();
	if(d<1 || d>31)
		goto bad;
	h = gpair();
	if(h == 24) {
		h = 0;
		d++;
	}
	m = gpair();
	if(m<0 || m>59)
		goto bad;
	y = gpair();
	if (y<0) {
		time(nt);
		y = localtime(nt)[5];
	}
	if (*cbp == 'p')
		h =+ 12;
	if (h<0 || h>23)
		goto bad;
	timbuf[0] = 0;
	timbuf[1] = 0;
	y =+ 1900;
	for(i=1970; i<y; i++)
		gdadd(dysize(i));
	while(--t)
		gdadd(dmsize[t-1]);
	gdadd(d-1);
	gmdadd(24, h);
	gmdadd(60, m);
	gmdadd(60, 0);
	return(0);

bad:
	return(1);
}

gdadd(n)
{
	register char *t;

	t = timbuf[1]+n;
	if(t < timbuf[1])
		timbuf[0]++;
	timbuf[1] = t;
}

gmdadd(m, n)
{
	register int t1;

	timbuf[0] =* m;
	t1 = timbuf[1];
	while(--m)
		gdadd(t1);
	gdadd(n);
}

gpair()
{
	register int c, d;
	register char *cp;

	cp = cbp;
	if(*cp == 0)
		return(-1);
	c = (*cp++ - '0') * 10;
	if (c<0 || c>100)
		return(-1);
	if(*cp == 0)
		return(-1);
	if ((d = *cp++ - '0') < 0 || d > 9)
		return(-1);
	cbp = cp;
	return (c+d);
}
