#
// a two pass assembler for the intel 8080 microprocessor
//	Bill Allen
//		Naval Postgraduate School
//		April, 1976


// after any of this assembler is recompiled, it must be initialized
//  before it will execute properly.  To initialize, become super user
//  and execute the command:

//		8080asm -i /src/8080asm/8080asminit

//  where 8080asm is the newly compiled version of the assembler.  With-
//  out this initialization, the assembler will not run (probably bus
//  error)

# include "8080asm.h"

int sttbl[] {0,1,1,0,1,0,3,3,3};	//state table for parser

char tfilname[] {"/tmp/80asma"};	//temp file for it
char initfnam[] {"/usr/bin/8080asminit"};	//initialize file name

int brkln1 077777;		//pass 1 break line number for debugging
int initflg 0;			//initialize flag
int numops;				//number of operands

int hopd(), hend(), send(), horg(), sorg(), hequ(), hset(), hif();
int hmacro(), hdb(), sdb(), hdw(), sdw(), hds(), sds();
int hsopd();
int p1gi();


char *ermsg[] {
	"label redefined",		//1
	"invalid label field",			//2
	"invalid opcode",				//3
	"no label for opd",				//4
	"opcode redefined",				//5
	"unable to evaluate expression",//6
	"forward reference in equate",	//7
	"label field on end statement",	//8
	"invalid first operand",		//9
	"invalid second operand",		//10
	"invalid third operand",		//11
	"illegal regster",				//12
	"undefined symbol in expression", //13
	"illegal register specifier",	//14
	"illegal constant"			//15
};

int instrlen[] {1,1,1,1,1,3,2,3,2};		//length of each instr format


main(argc,argv)
char **argv;
{
	register i;

	bmte = &(maintab[0]);
		emte = bmte + (sizeof maintab[0])*SZMT;
	if(argc<=1) {
usage:
		printf("Usage: 8080asm [-p] sourcefile [binaryfile] >listingfile\n");
		endit();
	}
	i = 1;
	if(argv[i][0] == '-') {		//may be print or initialize
		switch(argv[i++][1]) {

		case 'i':				//initialize the assembler
			initflg++;
			break;

		case 'p':				//produce a listing
			prtflg++;
			break;

		default:
			goto usage;
		}
	}
	ifn=openfi(argv[i++],0);	//open source file
	if(argc>i)
		bfn=openfi(argv[i],1);	//open binary file
	itfn = gettempf();	//get a temp file for it
	if(initflg) {		//initializing the main table
		lmte=bmte;		//beginning main table
		cszmt = SZMT;	//current size of main table
		for(i=0; i<=62; i=+2) {
			sirt[i] = &sirt[i];		//initialize the initial ref tables
			sirt[i+1] = 0;
			oirt[i] = &oirt[i];
			oirt[i+1] = 0;
		}

//make entries in main table for directives
		mdemt("opd",&hopd,0);		//opcode definition
		mdemt("end",&hend,&send);	//end statement
		mdemt("org",&horg,&sorg);	//set location counter
		mdemt("equ",&hequ,0);		//equate
		mdemt("set",&hset,0);		//set for cond assembly
		mdemt("if",&hif,0);			//conditional assembly
		mdemt("macro",&hmacro,0);
		mdemt("db",&hdb,&sdb);		//define byte
		mdemt("dw",&hdw,&sdw);		//define word
		mdemt("ds",&hds,&sds);		//define storage
		mdemt("sopd",&hsopd,0);		//symbol is operator

	}
	else {	//not initializing
		getsymtab();		//read initialized main table
	}

	fbufad = -1;			//no buffer yet
	itix = 0;				//no it yet
	absln = 1;
	sbuflen = -1;			//no source yet
	p2flg = 0;				//pass 1
	rlflg = 1;				//relocatable
	fchr = gchr();			//get first char
	mloop();
}


//main loop
mloop()
{
	register i;

	while(fchr!=EOF) {
		if(absln>=brkln1)	//break for debugging the assembler
			i=0;
		fcflg = 0;			//first time thru expr pass one
		cisit();			//create it for one statement
	}
	printf("no end statement\n");
	endit();
}

//directive to define an opcode
hopd()
{

	if(lbt[0]==0) {
		xerr(4);		//no label
		return;
	}
	setname();					//move label into main table
	if((lblpt=lemt(oirt))!=lmte) {
		xerr(5);				//label redefined
		return;
	}
	mmte();						//make main table entry
	expr(&p1gi);				//get opcode value
	if(itype != ITCN) {
		xerr(7);		//not a constant
		return;
	}
	lblpt->vl1 = ival;			//put value in main table
	if(fchr==',') {				//format modifier
		fchr=gchr();
		lblpt->flags =| fchr-'0';	//remember format
	}
	igrst();					//ignore rest of statement-comment
}

//set directive
hset()
{
	hequ();
}


//define a symbol as an operator
hsopd()
{

	lblpt = 0;
	hequ();
	if(lblpt)
		lblpt->flags =| SYOP;		//really is an operator
}

// equate directive
hequ()
{

	if(lbt[0] == 0) {
		xerr(4);		//no label
		return;
	}
	setname();
	if((lblpt=lemt(sirt))!=lmte) {
		if(lblpt->flags&SYDF) {
			xerr(1);		//already defined
			return;
		}
	}
	else
		mmte();
	lblpt->flags =| SYDF|SYEQ;	//defined & equate
	expr(&p1gi);
	if(itype != ITCN) {
		xerr(7);		//not a constant
		return;
	}
	lblpt->vl1 = ival;
	igrst();
}

// end statement
hend()
{

	lblpt = 0;	//no label
	opitb();	//output beginning of statement
	opito();	//output it ofr operands
	stbuf[0].itrl = itwc;	//number of it entries
	wostb();	//write out statement buffer
	if(itix)	//some it in buffer
		writbuf();	//write it out
	if(initflg) {
		putsymtab();
		printf("8080 assembler initialized\n");
		endit();
	}
	callp2();	//assembler pass 2
}

// define storage given number of bytes
hds()
{

	dlabl();	//define label maybe
	opitb();	//output it for beginning of statement
	expr(&p1gi);
	hds1();
}

// define byte directive
hdb()
{
	hdata(1);
}

//define word directive
hdw()
{
	hdata(2);	//defining words
}

// define bytes or words of data
//	call with:
//		1 => defining bytes
//		2 => defining words

hdata(mul)
{

	dlabl();		//define label
	opitb();		//beginning of statement
	numops = 1;		//at least one operand
	opito();		//output it for operands
	stbuf[0].itrl = itwc;	// # of it entries
	wostb();		//write out statement buffer
	loctr =+ numops*mul;	// count by bytes or words
}


//common subroutine
hds1()
{

	if(itype!=ITCN) {
		xerr(9);		//must be constant
		return;
	}

	if(reloc != 0)  {
		xerr(9);		//must be absolute
		return;
	}
	stbuf[3].itty = ITCN;		//constant
	stbuf[3].itop = ival;
	stbuf[0].itrl = 4;
	wostb();				//write out statement buffer
	loctr =+ ival;
	igrst();
}

// handle org statement
horg()
{

	dlabl();		//define label
	opitb();		//beginning of stmnt
	expr(&p1gi);	//value of org stmnt
	loctr=0;		//hds1 adds to loctr
	hds1();			//share code
}


// if directive
hif()
{
	return;
}

// define macro directive
hmacro()
{
	return;
}


//create intermediate text (it) for one statement
//	call with first character of statement in fchr

cisit()
{

	register (*dirop)(),i,first;	//temps

ciss1:
	first = 0;
	while(fchr==EOLC)
		fchr=gchr();		//ignore null lines

	if(fchr==';') {			//ignore comments
		igrst();
		goto ciss1;
	}


// get the opcode and label

cisi1:
	igblk();			//ignore blanks
	gterm();
	if(fchr==':') {			//there is a label
label:
		if(itype!=ITSY) {			//not a symbol
			uerr(2);
			lbt[0] = 0;		//no label
		}
		else {
			for(i=0; i<8; i++)
				lbt[i] = lmte->name[i];		//save label name
			if(fchr==':') fchr=gchr();		//ignore the colons
		}
		ligblk();
		gterm();
	}
	else
		lbt[0] = 0;			//no label
	igblk();
	if(itype!=ITSY) {	//not valid opcode
cisi3:
		uerr(3);		//invalid opcode
		igrst();
		goto ciss1;
	}
	if((opcpt=lemt(oirt))==lmte) {	//not in opcode table
		if(first++ == 0) {		//still may be label on equ
			if(lbt[0]) {	//need to define a label
				dlabl();
				first=0;	//can have multiple labels
			}
			goto label;
		}
		else
			goto cisi3;
	}
	if(opcpt->flags&OPDR) {	// its a directive
		dirop = opcpt->vl1;			//call routine to handle directive
		(*dirop)();
		return;
	}

	format = (opcpt->flags&OPFF);	//format of this instr
	dlabl();			//define label
	opitb();			//beginning of statement
	opito();			//output it for operands

//end of statement
	stbuf[0].itrl = itwc;	//number of it entries
	wostb();			//write out statement buffer
	loctr = loctr + instrlen[format];
}


//define a label if there is one to define
//	call with:
//		label name in lbt if it exists
//		else lbt[0] == 0

dlabl()
{
	register i;

	if(lbt[0]) {	//got a label
		for(i=0; i<8; i++)
			lmte->name[i] = lbt[i];	//put label in main table
		lblpt=lemt(sirt);	//look up label
		if(lblpt != lmte) {		//new table entry
			if((lblpt->flags)&SYDF) {
				uerr(1);
				lblpt = 0;
				return;
			}
		}
		else {
			mmte();		//make label entry in main table
		}
		lblpt->flags =| SYDF;	//defined
		lblpt->vl1 = loctr;		//label value
	}
	else
		lblpt = 0;
}

// output it for operands
//		gets intpu from gterm
//		puts output in stbuf using itwc as an index
//		itwc should point at the next entry to be made in stbuf

opito()
{

	while(1) {
		gterm();	//get a term
		opitoo();	//output it for one operand
		if(ival==EOLC && itype==ITSP)	//end of operands
			return;
		if(fchr==EOLC) {
			fchr=gchr();
			return;
		}
	}
}


//output it for one operand

opitoo()
{

	register i;

	if(itype==ITSP) {	//special symbol
		if(ival==',')	//another operand
			numops++;
		if(ival==' ' || ival==';') {		//end of operands
			while(fchr!=EOLC)		//ignore rest of statement
				fchr=gchr();
			return;
		}
		if(ival==EOLC)
			return;
	}

	stbuf[itwc].itty = itype;		//type of it entry

//put symbol in it buffer
	if(itype==ITSY) {
		i=lemt(sirt);		//look up it main table
		stbuf[itwc].itop = i;	//ptr to symbol entry
		if(i==lmte)			//first occurrance
			mmte();
		itwc++;				//count entries in it buffer
		return;
	}

// special characters and constants
	stbuf[itwc].itop = ival;
	itwc++;
}

//output it for beginning of statement

opitb()
{

	stbuf[0].itty = ITBS;	//beginning of statement
	if(fchr!=EOLC)
		stbuf[0].itop = absln;	//absolute line number
	else
		stbuf[0].itop = absln-1;
	stbuf[1].itty = ITSY;	//label entry
	stbuf[1].itop = lblpt;	//pointer to smbol or 0

//put opcode in it buffer
	stbuf[2].itty = ITSY;
	stbuf[2].itop = opcpt;	//pointer to opcode in main table
	itwc = 3;				//next available slot
}

// enter an operand in the symbol table
//	error if operand is not a single symbol
//	error if operand is already ext, ent, or eqr
//	returns:
//		pointer to symbol table entry

eopst()
{

	gterm();
	if(itype!=ITSY) {
		xerr(9);		//not a symbol
		return;
	}
	lblpt = lemt(sirt);			//look up in main table
	if((lblpt->flags&SYEP) || (lblpt->flags&SYXR) || (lblpt->flags&
		SYER))  {xerr(9); return;}		//already defined
	if(lblpt==lmte)				//new entry
		mmte();
	return(lblpt);
}


// get an input term  (symbol, constant, or special character)
//	call with:
//		the first character in fchr
//	returns:
//		item type in itype
//		item value in ival if item is a constant or special character
//		if it is a symbol it is placed at the end of the main table

gterm()
{

	register mode, tmode, i;
	char *j;
	int num;
	char istr[80];

	mode = 2;	//beginning state
	i = 0;

//loop to put item on istr
	while(fchr>=' ') {		//until a control char
		tmode = 6;
		if((fchr>='A'&&fchr<='Z') || (fchr>='a'&&fchr<='z'))
			tmode=3;
		else
			if(fchr>='0'&&fchr<='9')
				tmode=0;
		tmode = sttbl[tmode+mode];	//new state
		if(tmode==3) break;			//end of item
		mode = tmode;
		istr[i++] = fchr;			//save character
		fchr=gchr();
	}

// end of item
	switch(mode) {

	case 0:			//symbol
		istr[i] = '\0';		//end of symbol
		itype = ITSY;		//symbol
		pack(istr,lmte);	//put symbol at end of main table
		j = lemt(sirt);		//look up symbol--may be operator
		if((j->flags)&SYOP) {	//it is an operator
			itype = ITSP;		//turn it into a special char for expr
			ival = j->vl1;
			igblk();			//ignore blanks
		}
		return;

	case 1:			//constant
		if(constant(&num,istr,i)==0) {
			uerr(17);			//illegal constant
			num = 0;
		}
		ival = num;
		itype = ITCN;
		return;

	case 2:			//just a special char
		if(fchr=='$') {	//value of $ is location counter
			itype=ITCN;
			ival=loctr;
		}
		else {		//return special char
			itype=ITSP;
			ival=fchr;
		}
		fchr=gchr();		//get next car
		return;

	default:
		abort();		//not possible
	}
}

//convert ascii constant to binary
constant(pnum,pstr,idx)
int *pnum;
char *pstr;
{

	register trdx,i,j;

	*pnum = 0;
	switch(pstr[idx-1]) {	//last char of string tells radix

	case 'h':	//hexidecimal
		trdx = 16;
		break;

	default:
		idx++;		//no mode specifing char

	case 'd':		//decimal
		trdx = 10;
		break;

	case 'o':
	case 'q':		//octal
		trdx = 8;
		break;

	case 'b':		//binary
		trdx = 2;
		break;
	}

	for(i=0; i<idx-1; i++) {
		j = pstr[i];
		if(j>='0' && j<='9')
			j =- '0';
		else
			if(j>='a' && j<='f')
				j = j - 'a' + 10;
			else
				return(0);

		if(j<0 || j>=trdx)
			return(0);
		*pnum = (*pnum*trdx) + j;
	}
	return(1);
}

// method for looking up entries in the main table
//
// Note:	The entry to be looked up must be placed at the end
//			of the main table.  The global cell 'lmte'(last main
//			entry) points to the next available entry in the main
//			table.  The address of an initial reference table must
//			also be provided.

//	1)	Compute the hash code for the symbol and add it to the base address
//		of the initial reference table given as input.  Thus, two words are
//		accessed which define the chain on which the symbol must be if it is
//		in the table at all.

//	2)	Alter the table link of the last symbol in the chain so that it 
//		points to the symbol being looked up.  Note that the symbol to be 
//		looked up is always placed at the end of the main table before 
//		calling the lookup routine.  This essentially adds one more element
//		to the end of the chain, namely the symbol to be looked up.

//	3)	Now start at the first symbol in the chain and follow the chain
//		looking for a symbol equal to the smbol being looked up.  It is
//		quaranteed that such a symbol will be found because it is always 
//		the last symbol on the chain.

//	4)	When the symbol is found, check to see if it is the last symbol
//		on the chain.  If not, the symbol being looked for is in the table
//		and has been found.  If it is the last symbol, the symbol being 
//		looked up is not in the table.

//	5)	In the case the looked up symbol is not found, it is usually added
//		to the end of the table.  This is done simply b changing the 
//		initial reference table entry which points to the previous
//		last symbol on the chain so that is now points to the symbol at the
//		end of the main table.  In case the symbol just looked up is not to
//		be added to the main table then no action is needed .  This means
//		that the table link of the last symbol on a chain may point any-
//		where.

// look up entry in the main table
//		call with:
//			address of initial reference table
//			entry to be looked up at the end of the main table
//		returns:
//			a pointer to the entry.  if this pointer is equal to
//			lmte then the symbol was not previously in the table.

lemt(airt)
int *airt;
{

	register i, *mtpt;

	nclmt =+ 1;		//number of calls on lemt
	pirt = airt + hash();	//pointer to entry in irt
	mtpt = pirt->irfe;		//pointer to first entry in chain
	if(mtpt==0)				//empty chain
		mtpt = lmte;		//start at end of main table
	else
		(pirt->irle)->tlnk = lmte;	//last entry in chain is new symbol

//loop to locate entry in main table
lemtl:
		for(i=0; i<8; i++) {
			if(mtpt->name[i] != lmte->name[i]) {
				mtpt = mtpt->tlnk;	//go to next entry in chain
				goto lemtl;
			}
		}
		return(mtpt);
}

//make an entry in the main table
// assumes:
//	entry to be made is pointed at by lmte
//	pirt points to the correct initial reference table entry

mmte()
{

	pirt->irle = lmte;		//pointer to last entry in chain
	if(pirt->irfe == 0)		//first entry in chain
		pirt->irfe = lmte;
	lmte =+ sizeof maintab[0];			//bump last main table entry pointer
	if(lmte>=emte) {		//main table overflow
		printf("main table overflow -- abort\n");
		endit();
	}
}

// make an entry in the main table for a directive
//	call with:
//		pointer to string containing directive name
//		address of routine to handle directive in pass one
//		address of routine to handle directive in pass two

mdemt(mdstr,mdad1,mdad2)
{

	register *mdept;

	pack(mdstr,lmte);		//pack name at end of main table
	mdept=lemt(oirt);		//look up in opcode table
	if(mdept != lmte) {		//best not be there already
		uerr(5);
		abort();
		return;
	}
	mmte();					//make main table entry
	mdept->flags =| OPDR;	//directive
	mdept->vl1 = mdad1;		//address of pass one routine
	mdept->vl2 = mdad2;		//address of pass two routine
}

// compute a hash code for the last entry in the main table
//	returns the hash code

hash()
{

	register ht1, i;	//temps

	ht1 = 0;
	for(i=0; i<8; i++) 
		ht1 =+ lmte->name[i];
	ht1 = (ht1&0377) + ((ht1>>8)&0377);
	ht1 =& 076;		//make has code even and between 0 and 63
	return(ht1);
}

// pack a string into an entry in the main table
//	call with:
//		pointer to the string
//		pointer to desired entry in the main table

pack(pkstr,pkptr)
char *pkstr;
struct symtab *pkptr;
{

	register i;

	i = 0;
	while(pkstr[i])
		pkptr->name[i] = pkstr[i++];
	while(i<8)
		pkptr->name[i++] = '\0';	//pad with nulls
}
// function to get characters for source file

gchr()
{

	register chr1;

gchr1:
	if(sbuflen<=0){		//nothing on input buffer
		sbuflen=read(ifn,sbuf,512);	//read in source
		if(sbuflen<=0)
			return(EOF);			//end of file
		sbufix = 0;
	}
	chr1 = sbuf[sbufix++];
	sbuflen--;
	if(chr1 == EOLC) {		//end of line
		if(p2flg==0)		//pass 1 only
			absln++;
	}
	else
		if(chr1=='\t') {	//convert tabs to spaces
			if(p2flg==0)	//pass 1 only
				chr1 = ' ';
		}
		else
			if(chr1<' ')		//ignore control chars except EOLC
				goto gchr1;
	return(chr1);
}

// check number
//	call wit:
//		character to check
//	returns
//		1 if number else 0

cknum(cknm)
{

	if(cknm<'0' || cknm>'9') return(0);
	return(1);
}

//write out intermediate text for one statement
//	call with
//		the it for the statement in stbuf

wostb()
{

	register woix;

	if(stbuf[0].itty != ITBS) abort();	//not beginning of stmt
	for(woix=0; woix<stbuf[0].itrl; woix++)
		woit(&stbuf[woix]);		//write out one it entry(2 words)
	debug();		//call debug package
}

// write out one it entry -- two words
woit(itwo)
int *itwo;
{

	if(itix > ITBSZ-2) {		//no room in buffer
		writbuf();				//write it buffer
		itix = 0;
		oitcnt++;				//count it buffers written
	}
	itbuf[itix++] = *itwo++;	//first word
	itbuf[itix++] = *itwo++;	//second word
}

//write it buffer to it file
writbuf()
{

		if(write(itfn,itbuf,ITBSZ*2) != ITBSZ*2) {
			printf("I/O write error on it file\n");
			endit();
		}
}


//user source error
//	call with:
//		number to indicate reason for error
//	types the error number and the line number on which
//	the error occured.

terr(errn)
{
	register eln;

	if(fchr=='\n')
		eln = absln-1;
	else
		eln = absln;

	ecnt++;		//count errors
	if(p2flg)	//pass 2 get two stars
		printf("%d ** %s\n",absln,ermsg[errn-1]);
	else
		printf("%d * %s\n",eln,ermsg[errn-1]);
}

//user error that causes te statement to be abandoned
//	call with:
//		error number

xerr(xern)
{

	terr(xern);		//type error message
	sabort++;		//aborting the statement
	if(p2flg)		//pass two
		return;
	igrst();		//pass rest of source
}

//user error -- not fatal
uerr(uern)

{

	terr(uern);
}

// abort the assembly
abort()
{

	printf("internal error--abort\n");
	endit();
}

//start up pass 2
callp2()
{

	pass2();
}

//ignore rest of statement

igrst()
{

	while(fchr!=EOLC)		//until end of line
		fchr=gchr();
	fchr=gchr();
	while(fchr==EOLC)		//ignore null lines
		fchr=gchr();
}

//ignore blanks
igblk()
{

	while(fchr==' ')
		fchr=gchr();
	if(fchr==';')	//comment
		while(fchr!=EOLC)	//ignore rest of line
			fchr=gchr();
}

//ignore blanks after a label
ligblk()
{

	while(fchr==' ')
		fchr=gchr();
	if(fchr==';')	//comment
		while(fchr!=EOLC)	//ignore rest of line
			fchr=gchr();
	if(fchr==EOLC) {
		fchr=gchr();
		ligblk();
	}
}

// exit from the assembler
endit()
{
	if(itfn)
		unlink(tfilname);		//delete temporary file
	putchar('\n');
	exit();
}

// open files
//	call with:
//		pointer to name of file to open
//		flag for how to open
//			0 => read
//			1 => write

openfi(pname,hflag)
{

	register fd;

	if(hflag)
		fd = creat(pname,0640);	//open for writing
	else
		fd = open(pname,hflag);
	if(fd < 0) {	//open faled
		printf("unable to open %s\n",pname);
		endit();
	}
	return(fd);
}

// get a temp file for the intermediate text

gettempf()
{

	register i,j;

	for(i=0; i<=26; i++) {
		if((j=creat(tfilname,0400))>=0)
			return(j);
		tfilname[10]++;
	}
	printf("Unable to open temporary file\n");
	endit();
}

// move label name from lbt to main table entry pointed to by lmte
setname()
{

	register i;

	for(i=0; i<8; i++) {
		lmte->name[i] = lbt[i];
		lbt[i] = '\0';				//null padded
	}
}

// get the initialized main table and initial reference tables from
//	the initialize file
getsymtab()
{

	register fd,i,j;

	if((fd=open(initfnam,0)) < 0) {
		printf("Unable to open init file: %s\n",initfnam);
		endit();
	}
	if(read(fd,sirt,SZIRT*2) != SZIRT*2) {
rerr:
		printf("Unable to read init file: %s\n", initfnam);
		endit();
	}

	if(read(fd,oirt,SZIRT*2) != SZIRT*2)
		goto rerr;

	if((i=read(fd,&maintab[0],SZMT*sizeof maintab[0])) <= 0)
		goto rerr;

	if((i%sizeof (maintab[0])) != 0)
		goto rerr;

	j = &maintab[0];
	j =+ i;
	lmte = j;
	close(fd);
}

// write the initialization file
putsymtab()
{

	register fd,i;

	if((fd=creat(initfnam,0644))<0) {
		printf("Unable to write init file: %s\n", initfnam);
		return;
	}

	if(write(fd,sirt,SZIRT*2) != SZIRT*2) {
werr:
		printf("Write error on init file: %s\n", initfnam);
		return;
	}

	if(write(fd,oirt,SZIRT*2) != SZIRT*2)
		goto werr;

	i = lmte - &maintab[0];		//length of current main table
	if((i % sizeof maintab[0]) != 0) {
		printf("Invalid main table written\n");
	}
	if(write(fd,&maintab[0],i) != i)
		goto werr;
	close(fd);
}
