#

/* intray - letter manipulator
 * Needs the POP windowing package
 * usually found in /lib/libw.a
 */


/* All complaints and comments to:
 *
 * Jon Rowson
 * Computer Systems Laboratory
 * Queen Mary College
 * University of London
 *
 * Apologies for the incompleteness of
 * the intray system - a complete version
 * may follow.
 */

#define LSIZE	32

struct letter {
	char l_name[10];
	char l_time[26];
	char *l_block;
	char l_mark;
	char l_del;
};

struct letter mail[LSIZE];

struct send {
	char name[10];
} senders[LSIZE];


struct popdesc {
	int h1,h2,v1,v2;
};

#define NPOPS	9
struct popdesc popopen[NPOPS] {
	1,38,1,1,		/* for titles */
	1,80,3,10,		/* for letters  */
	70,80,1,2,		/* for marks */
	45,53,1,1,		/* for page number */
	41,79,12,12,		/* for messages */
	65,80,15,15,		/* for save box name */
	65,80,16,16,		/* for mailbox name */
	65,66,17,17,		/* for current letter number */
	65,66,18,18,		/* for number of letters */
};

int pops[NPOPS];
#define TPOP	pops[0]
#define LPOP	pops[1]
#define MARKPOP	pops[2]
#define PAGEPOP	pops[3]
#define MESSPOP	pops[4]
#define SAVEPOP	pops[5]
#define MAILPOP	pops[6]
#define IPOP	pops[7]
#define NLPOP	pops[8]


int mmpop,smpop,cmpop;



struct mdesc {
	int md1,md2,md3,md4,md5;
};

struct mdesc mmd {
	1,15,4,5,16
};

struct mdesc cmd {
	1,6,6,2,12
};
struct mdesc smd {
	1,6,6,1,24
};

struct menu {
	char *mname;
	int (*l_func)();
	int (*f_func)();
};


struct menu mainmenu[] {
	"forall",	&forall,	0,
	"reverse",	&reverse,	0,
	"next",		&next,		0,
	"previous",	&previous,	0,
	"read",		&l_read,	0,
	"print",	&l_print,	&f_print,
	"save",		&l_save,	&f_print,
	"mark",		&l_mark,	0,
	"delete",	&l_delete,	&f_delete,
	"clear",	&l_clear,	0,
	"exit",		&pexit,		0,
	"",		0,		0,
	"savebox  ......",	&r_save,		0,
	"mailbox  ......",	&r_mail,		0,
	"i",		0,		0,
	"nooflets",	0,		0,
	0,
};


struct menu secmenu[] {
	"read",		&l_read,	0,
	"print",	&l_print,	&f_print,
	"save",		&l_save,	&f_print,
	"mark",		&l_mark,	0,
	"clear",	&l_clear,	0,
	"delete",	&l_delete,	&f_delete,
	0
};

struct menu condmenu[] {
	"if marked",	&if_mark,	0,
	"if sender",	&if_sender,	&selsender,
	0
};

struct menu dummy[12];
struct menu *dml[] {
	dummy,
	0,
};


struct menu selmenu[12];
struct menu *selml[] {
	selmenu,
	0,
};

struct menu *mml[] {
	mainmenu,
	0,
};

struct menu *cml[] {
	secmenu,
	condmenu,
	0,
};

struct menu *sml[] {
	secmenu,
	0
};


char m_name[128];
char s_name[128];
char t_name[128];
struct iobuf {
	int des;
	int nch;
	char *nxt;
	char buf[512];
};
struct iobuf inbuf, tbuf;
int useri, selsen, letc;
int mreset();
char *marks	"**********\n**********";



main(argc,argv)
char **argv;
{
register struct menu *m;
register i;

	if (argc >= 2)
		strcopy(*++argv, m_name);
	else
	if (argc == 1)
		strcopy(".mail",m_name);

	strcopy("mbox",s_name);
	if (fopen(m_name,&inbuf) < 0)
		exit();

	/* open pops */
	for (i=0; i<NPOPS; i++) {
		pops[i] = popen(&popopen[i]);
		pnorm(pops[i]);
	}
	ppage(LPOP);
	pbreak(LPOP,'#',&mreset);
	pnoecho(LPOP);
	mmpop = msetup(&mml, &mmd);
	pborder(mmpop,'-','-');
	pfprintf(SAVEPOP, s_name);
	pfprintf(MAILPOP, m_name);


	useri = 0;
	hinit();
	for (;;) {
		setexit();
		l_title(useri);
		while ((m = mselect(mmpop, &mml, &mmd)) == 0);
		if (pgetc(MESSPOP,1,0) !=  ' ') {
			pborder(MESSPOP,' ',' ');
			pclear(MESSPOP);
		}
		if (m->l_func)
			(*m->l_func)(useri);
		if (m->f_func)
			(*m->f_func)();
	}

	pexit();
};


forall()
{
register struct menu *m;
register i;
register (*f_cond)();

	smpop = -1;
	cmpop = msetup(&cml, &cmd);
	pbreak(cmpop,'#',&mreset);
	pborder(cmpop,'-','!');
	while ((m = mselect(cmpop, &cml, &cmd)) == 0);
	f_cond = 0;
	if (m >= condmenu) {		/* conditional selected */
		if (m->f_func)
			(*m->f_func)();
		f_cond = m->l_func;
		pclear(cmpop);
		smpop = msetup(&sml, &smd);
		pbreak(smpop,'#',&mreset);
		while ((m = mselect(smpop, &sml, &smd)) == 0);
		pclear(smpop);
	}
	else
		pclear(cmpop);
	pborder(cmpop,' ',' ');
	for (i=0; i <= letc; i++) {
		if ((f_cond == 0) || (*f_cond)(i))
			(*m->l_func)(i);
	}

	if (m->f_func)
		(*m->f_func)();
	pclose(cmpop);
	if (smpop != -1)
		pclose(smpop);
}


previous()
{
	if (--useri < 0)
		useri = letc;
}

next()
{
	if (++useri > letc)
		useri = 0;
}
#define CLEAR	12


reverse()
{
}


l_read(i)
{
register char *s, c;
int lc, pc;

	l_title(i);
	popreset();
	s = mail[i].l_block;
	while (*s++ != '\n');		/* ignore title here */
	lc = 0, pc = 1;
	pfprintf(PAGEPOP, "Page 1");
	pselect(LPOP);
	while ((c = *s++) != '\0') {
		if (pputc(c) == CLEAR) {
			pmove(PAGEPOP,5,0);
			pfprintf(PAGEPOP, "%d", ++pc);
			lc = 0;
		}
		else
			lc++;
	}
	if (lc) {
		phome(LPOP);
		pread();
	}
}


l_delete(i)
{
	mail[i].l_del++;
	free(mail[i].l_block);
}

f_delete()
{
register struct letter *lfront, *lback;
int front, back;

	for (front=back=0, lfront=lback=mail; front <= letc; front++,lfront++)
		if (lfront->l_del == 0) {
			strcopy(lfront->l_name, lback->l_name);
			strcopy(lfront->l_time, lback->l_time);
			lback->l_mark = lfront->l_mark;
			lback->l_block = lfront->l_block;
			back++, lback++;
		}

	if ((letc = back-1) < 0) {
		messet();
		pfprintf(MESSPOP," No letters left in %s", m_name);
		unlink(m_name);
		pexit();
	}

	/* open mailbox file for recreation */
	if (fcreat(m_name,&tbuf) == -1) {
		messet();
		pfprintf(MESSPOP," Cannot recreate %s",m_name);
		pexit();
	}

	/* now output every letter that
	 * is left in the cache freestore
	 */

	putc('\n',&tbuf);
	for (front=0; front <= letc;)
		l_out(front++);

	pclear(NLPOP);
	pfprintf(NLPOP,"%d",letc+1);
	f_print();
}

l_print(i)
{
int spool[2];
register pid;

	if (tbuf.des == 0) {
		pipe(spool);
		if ((pid = fork()) == -1) {
			messet();
			pfprintf(MESSPOP, " Can't spool");
			mreset();
		}
		if (pid == 0) {
			close(0);
			close(spool[1]);
			if (dup(spool[0]) != 0) {
				messet();
				pfprintf(MESSPOP, " Bad dup");
				pexit();
			}
			execl("/bin/lpr","/bin/lpr",0);
		}
		close(spool[0]);
		tbuf.des = spool[1];
	}
	l_out(i);
}

f_print()
{
	fflush(&tbuf);
	close(tbuf.des);
	tbuf.des = 0;
}

struct inode {
	char i_pad[9];
	char i_size1;
	int i_size;
	char i_pad1[24];
};

l_save(i)
{
register n, offset, block;
struct inode inod;

	if (tbuf.des == 0) {
		if ((tbuf.des = open(s_name,2)) == -1) {
			if (fcreat(s_name, &tbuf) == -1) {
				messet();
				pfprintf(MESSPOP," Can't open %s",s_name);
				mreset();
			}
			putc('\n',&tbuf);
		}
		else {
			fstat(tbuf.des, &inod);
			if (inod.i_size1 != 0) {
				messet();
				pfprintf(MESSPOP," Save file over 64K");
				mreset();
			}
			block = (inod.i_size >> 9) & 0177;
			offset = inod.i_size & 0777;
			seek(tbuf.des, block, 3);
			n = read(tbuf.des, tbuf.buf, 512);

			/* reset read/write pointer
			 * to start of block read
			 * and set buffer pointers.
			 */
			seek(tbuf.des, block, 3);
			tbuf.nch = 512 - n;
			tbuf.nxt = tbuf.buf + n;
		}
	}

	l_out(i);
}

l_mark(i)
{
	mail[i].l_mark = 1;
}


l_clear(i)
{
	mail[i].l_mark = 0;
}


strcopy(s1,s2)
char *s1,*s2;
{
	while (*s2++ = *s1++);
}


l_title(i)
{
register char *s, c;
register struct letter *l;
char buffer[512];

	l = &mail[i];
	s = l->l_block;

	popreset();
	if (l->l_mark) {
		if (pgetc(MARKPOP,0,0) != '*') {
			phome(MARKPOP);
			pfprintf(MARKPOP,marks);
		}
	}
	else
	if (pgetc(MARKPOP,0,0) != ' ')
		pclear(MARKPOP);

	/* check that title not already displayed */
	pgetl(TPOP,0,buffer);
	if (linemat(buffer,s))
		return;

	/* it isn't so clear up first */
	pclear(TPOP);
	pselect(TPOP);
	while ((c = *s++) != '\n')
		pputc(c);
	pclear(IPOP);
	pfprintf(IPOP,"%d",i+1);
}

if_mark(i)
{
	return(mail[i].l_mark);
}

if_send(i)
{
	return(strmat(mail[i].l_name, &senders[selsen]));
}

strmat(s1,s2)
char *s1,*s2;
{
register char c;

	while ((c = *s1++) == *s2++)
		if (c == '\0')
			return(1);
	return(0);
}

linemat(s1,s2)
char *s1,*s2;
{
register char c1, c2;

	while ((c1 = *s1++) == (c2 = *s2++))
		if ((c1 == '\0') || (c1 == '\n'))
			return(1);
	if (((c1 == '\0') || (c1 == '\n')) &&
			((c2 == '\0') || (c2 == '\n')))
		return(1);
	return(0);
}



r_save()
{

	pselect(SAVEPOP);
	pclear(SAVEPOP);
	pedit(s_name);
}

r_mail()
{
register struct letter *l;
register i;

	pselect(MAILPOP);
	pclear(MAILPOP);
	pedit(t_name);

	if (fopen(t_name,&inbuf) < 0) {
		messet();
		pfprintf(MESSPOP," Cannot open %s",t_name);
		pclear(MAILPOP);
		pprintf(m_name);
		reset();
	}
	else
		strcopy(t_name,m_name);

	for (i=0,l=mail; i<=letc; i++,l++)
		free(l->l_block);
	useri = 0;
	hinit();
	phome(mmpop);
	reset();
}


/* outputs a letter into tbuf
 *
 */

l_out(i)
{
register char *s, c;

	s = mail[i].l_block;
	while ((c = *s++) != '\0')
		putc(c,&tbuf);
	c = '\n';
	putc(c,&tbuf);
	putc(c,&tbuf);
}


/* clears page and letter
 * pop if filled.
 */
popreset()
{

	if (pgetc(PAGEPOP,0,0) != ' ') {
		pclear(PAGEPOP);
		pclear(LPOP);
	}
}


selsender()
{
register struct menu *m;
register char *s;
register spop;

	for (s = senders,m = selmenu; *s != '\0'; s =+ 10,m++)
		m->mname = s;

	m->mname = 0;
	pclear(cmpop);
	spop = msetup(&selml, &cmd);
	pbreak(spop,'#',&mreset);
	while ((m = mselect(spop,&selml,&cmd)) == 0);
	pclose(spop);
	for (s = senders,selsen = 0; *s != '\0'; s =+ 10, selsen++)
		if (m->mname == s)
			return;
}


mreset()
{
int dpop;

	dpop = msetup(&dml, &cmd);
	if (pgetc(dpop,0,0) != ' ') {
		pclear(dpop);
		pborder(dpop,' ',' ');
	}
	pclose(dpop);
	pclose(cmpop);
	pclose(smpop);
	reset();
}


messet()
{
	pborder(MESSPOP,'*','*');
}




/* The folllowing functions all
 * deal with the reading in of
 * the mailbox file into memory.
 */





char *s, *b;
int offset;
int offsave;
int size;


hinit()
{
register i;
register char c;

	offset = 0;
	offsave = -1;
	letc = -1;
	senders[0].name[0] = '\0';
	while ((c = mgetc()) == '\n');
	if (c != 'F') {
		messet();
		pfprintf(MESSPOP," %s is not a mailbox",m_name);
		pexit();
	}
	for(;;) {
		if ((c == 'F') && (offsave <= offset-2)) {
			if (letc >= 0)
				mail[letc].l_block = bputc(b,s++,0);
			if ((b = alloc(size = 512)) == -1)
				nospace();
			s = 0;
			letc++;
			b = bputc(b,s++,c);

			gfrom();
			gname();
			gtime();
		}
		else
			b = bputc(b,s++,c);

		while ((c = bmgetc()) != '\n');
		offsave = offset;
		while ((c = mgetc()) == '\n');
		if (c < 0)
			break;
	}

	mail[letc].l_block = bputc(b,s++,0);
	close(inbuf.des);
	pclear(NLPOP);
	pfprintf(NLPOP,"%d", letc+1);
}


mgetc()
{
	offset++;
	return(getc(&inbuf));
}


bmgetc()
{
register char c;
	c = mgetc();
	b = bputc(b,s++,c);
	return(c);
}
gname()
{
register char *st, c, *se;
int n;

	st = &mail[letc].l_name[0];
	n = 0;
	while ((c = bmgetc()) != 040) {
		if (n++ < 8)
			*st++ = c;
	}
	*st = '\0';
	st = &mail[letc].l_name[0];
	for (se = senders; *se != '\0'; se =+ 10)
		if (strmat(st,se))
			return;
	strcopy(st,se);
	se =+ 10;
	*se = '\0';
}


gtime()
{
register i;
register char *st,c;

	st = &mail[letc].l_time[0];
	for(i=0; i++ < 24;)
		*st++ = bmgetc();
	*st = '\0';
	while ((c = mgetc()) != '\n');
	b = bputc(b,s++,'\n');
}

gfrom()
{
register i;

	for (i=0;i<4;i++)
		bmgetc();
}


/* this routine stores char c
 * at address (b+s) but doing
 * any necessary block extensions.
 * The current size of the block
 * is in bsize.
 */
char *bputc(b1,b2,c)
char *b1, *b2;
{
register char *new, *old;
char *newh, *oldh;

	if (b2 >= size) {	/* extension necessary */
		oldh = old = b1;
		b1 =+ size;		/* top of old block */
		size =+ (size >> 1);
		if ((newh = new = alloc(size)) == -1)
			nospace();
		while (old < b1)
			*new++ = *old++;
		free(oldh);
		b1 = newh;
	}
	*(b1 + b2) = c;
	return(b1);
}


nospace()
{

	messet();
	pfprintf(MESSPOP," Not enough space");
	pexit();
}
