#
/*
 *	Copyright 1973 Bell Telephone Laboratories Inc
 */

/*
 * general TTY subroutines, part 2
 */
#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../tty.h"
#include "../proc.h"
#include "../inode.h"
#include "../file.h"
#include "../reg.h"
#include "../conf.h"

#define BRKBIT	1
/*
 * The actual structure of a clist block manipulated by
 * getc and putc (mch.s)
 */
struct cblock {
	struct cblock *c_next;
	char info[6];
};

/* The character lists-- space for 6*NCLIST characters */
struct cblock cfree[NCLIST];
/* List head for unused character blocks. */
struct cblock *cfreelist;

/*
 * structure of device registers for KL, DL, and DC
 * interfaces-- more particularly, those for which the
 * SSTART bit is off and can be treated by general routines
 * (that is, not DH).
 */
struct {
	int ttrcsr;
	int ttrbuf;
	int tttcsr;
	int tttbuf;
};


ttbreak(atp)
struct tty *atp;
{
	register struct tty *tp;
	register int *addr;

	tp = atp;
	addr = tp->t_addr;
	tp->t_state =& ~TIMEOUT;
	addr->tttcsr =& ~BRKBIT;
	ttstart(tp);
}
/*
 * Restart typewriter output following a delay
 * timeout.
 * The name of the routine is passed to the timeout
 * subroutine and it is called during a clock interrupt.
 */
ttrstrt(atp)
{
	register struct tty *tp;

	tp = atp;
	tp->t_state =& ~TIMEOUT;
	ttstart(tp);
}
/*
 * Start output on the typewriter. It is used from the top half
 * after some characters have been put on the output queue,
 * from the interrupt routine to transmit the next
 * character, and after a timeout has finished.
 * If the SSTART bit is off for the tty the work is done here,
 * using the protocol of the single-line interfaces (KL, DL, DC);
 * otherwise the address word of the tty structure is
 * taken to be the name of the device-dependent startup routine.
 */
ttstart(atp)
struct tty *atp;
{
	register int *addr, c;
	register struct tty *tp;
	struct { int (*func)(); };
	int sps;
/* modified for raw transmission ... transmit all 8 bits */

	tp = atp;
	addr = tp->t_addr;
	sps = PS->integ;
	spl5();

	if (tp->t_state&SSTART)
		(*addr.func)(tp);
	else if ((addr->tttcsr&DONE)==0 || tp->t_state&TIMEOUT);
	else if ((c=getc(&tp->t_outq)) >= 0) {
/* check for raw mode here
 * this is a fudge for the BREAK character
 * if ODDP and EVENP are both off, we want full true 8-bit
 * and BREAKCH is transmitted.
 * If one or both are on, we send BREAK signal
 */
		if (tp->t_flags&RAW) {
			if ((c!=CBREAK) || ((tp->t_flags&(ODDP|EVENP))==0))
				addr->tttbuf = c;
			else
				goto sendbrk;
		}

		else if (c<=0177)
			if (c==CBREAK) {
sendbrk:
				addr->tttcsr =| BRKBIT;
				tp->t_state =| TIMEOUT;
				timeout(ttbreak,tp,12);
			} else addr->tttbuf = c | (partab[c]&0200);
		else {
			timeout(ttrstrt, tp, c&0177);
			tp->t_state =| TIMEOUT;
		}
	}
	PS->integ = sps;
}

