#
#include "common.h"

/*  combine two areas.  i.e. transliterate contents of x,y,w,h according */
/*  to 4 rules depending on contents of cells of area centered at kx,ky */

	int IXX[8]  { 1, 0,-1, 0,
			-1, 0, 1, 0};
	int IXY[8]  { 0,-1, 0, 1,
			 0, 1, 0,-1};
	int IYX[8]  { 0, 1, 0,-1,
			 0, 1, 0,-1};
	int IYY[8]  { 1, 0,-1, 0,
			 1, 0,-1, 0};


combn (ix,iy,iw,ih,ipct,kx,ky,iway,ir0,ir1,ir2,ir3)
{

	int ftrul [4][4];
	register int j,k;
	int ibyte,index,iskip,idlsk;
	int ixf,iyf,mpy,ipont,mdarg,ibt,indxf,numf,newn;
	int ib,il,ir,it,numt,iprob,irule,ibytf,i7;

	char ok;
/*      IXY is +1,0, or -1 depending on whether +1 in y on affected area */
/*      x,y,w,h corresp. to +1, 0, or -1 from pickup area (8 orientations) */

	if (frzzt)
		klear(&frzzt);

/*      rectify bounds, check validity of parameters */
	rctfy (ix,iy,iw,ih,&il,&ir,&ib,&it,&ok);

	if( !ok)return;
	if(min04(ir0,ir1,ir2,ir3) < 0)return;
	if(max04(ir0,ir1,ir2,ir3) > 3333)return;
	if(iway-- < 1 || iway > 7 || ipct < 1)return;
	
/*      initialize random skipping */
        iprob = 2* ipct-ipct/51;
        ipont = ne(1,199);
        iskip = ne(0,197);
        idlsk = ne(0,195);

/*      initialize from-to transliteration matrix */
        ftrul [0][0] = ir0;
        ftrul [1][0] = ir1;
        ftrul [2][0] = ir2;
        ftrul [3][0] = ir3;

	for (j=0;j<4;j++) {
		irule = ftrul[j][0];
		ftrul [j][0] = ((irule/1000 % 10) % 4);
		ftrul [j][1] = ((irule/ 100 % 10) % 4);
		ftrul [j][2] = ((irule/  10 % 10) % 4);
		ftrul [j][3] = ((irule      % 10) % 4);
	}

/*      do affected area column by column left to right */
	for (j=il;j<=ir;j++) {
		ibyte = j % 7;
		index = nperw * ib + j/7;
		iskip = (iskip+idlsk) % 198;

/*      start cursor(ixf,iyf) as displacement from kx,ky according to iway */
		ixf = kx - (ix - j)* IXX[iway] - (iy - ib)* IXY[iway];
		iyf = ky - (iy-ib) * IYY[iway] - (ix-j) * IYX[iway];
		mpy = 12 - 2 * ibyte;		/* set up shifts */
/*      process the column */
		for (k=ib;k<=it;k++) {
			if (ipct < 100) {
				mdarg = ipont+iskip;
				ipont = mdarg % 199;
				if (IRAN[ipont] >= iprob)
					goto lab18;

			}
			if(ixf < 0 || ixf >= nperl || iyf < 0 || iyf >= nperl)
				goto lab18;
/*      do process the cell. fetch both, look up, replace if different */
			ibytf = ixf % 7;
			indxf = nperw * iyf + ixf/7;
			numf = (LINE[indxf] >> (12 - 2* ibytf)) & 03;
			i7 = LINE[index];
			numt = (i7>>mpy) & 03;
			newn = ftrul [numf][numt];
			if (newn != numt)
				LINE[index] = (i7 & ~(03<<mpy)) | (newn<<mpy);
/*      for next pass of inner loop, prepare to index, jog ixf,iyf cursor */
lab18:
			index =+ nperw;
			ixf =+ IXY[iway];
			iyf =+ IYY[iway];
lab20:
		}
	}
}
