#-h-  cprint                      746  ascii   02/02/82  13:40:21
 ## common block to hold info for pr tool
 #  put on a file called 'cprint'
 #  used only by the pr tool

 common /cprint/  mar1, mar2, bmar, dohead, dotail, plen
        integer mar1    #distance between top of page and header
                        #(default = 3)
        integer mar2    #distance between header and text
                        #(default = 2)
        integer bmar    #distance between text and bottom of page
                        #(default = 6)
        integer dohead  #flag to cause/suppress printing of header
                        # (default = YES)
        integer dotail  #flag to cause/suppress printing of bottom
                        #margin  (default = YES)
        integer plen    #page length (default = 66)
#-t-  cprint                      746  ascii   02/02/82  13:40:21
#-h- tpr.r                       3423  ascii   02/02/82  13:40:22
#-h-  print                      1441  local   12/24/80  13:03:50

  # include ratdef
 define(MARGIN1,3)
 define(MARGIN2,2)
 define(BMARGIN,3)
 define(PAGELEN,66)

 ## print - print files with headings
 DRIVER(print)
    character name(FILENAMESIZE)
    integer getarg, open, ctoi
    integer fd, i, j
    include cprint
    string null ""

    mar1 = MARGIN1		#set defaults
    mar2 = MARGIN2
    bmar = BMARGIN
    dohead = YES
    plen = PAGELEN
    fd = ERR
    call query ("usage:  pr [-ln] [file].")
    for (i = 1; getarg(i, name, FILENAMESIZE) ^= EOF; i = i + 1)
	{
       if (name(1) == MINUS & name(2) != EOS)
                {                  #it is anticipated that more
                                   #options may be added in the future
		if (name(2) == LETL | name(2) == BIGL) #set page length
			{
                         j = 3
                         plen = ctoi(name, j)
                         if ((plen-mar1-mar2-bmar-2) <= 0)
                              call error ("page too small.")
			}
		else
			call remark ("ignoring invalid argument.")
		}
        else if (name(1) == MINUS & name(2) == EOS)
	        {
		fd = STDIN
		call fprint (null, STDIN)
		}
	else
		{
       		fd = open(name, READ)
       		if (fd == ERR)
          		call cant(name)
       		call fprint(name, fd)
       		call close(fd)
                }
       }
    if (fd ==ERR)    # no input file specified
       call fprint(null, STDIN)
   DRETURN
    end
#-t-  print                      1441  local   12/24/80  13:03:50
#-h-  fprint                      785  local   12/24/80  13:03:50
 # fprint - print file "name" from  fd
    subroutine fprint(name, fd)
    integer line(MAXLINE), name(ARB)
    integer getlin
    integer fd, lineno, pageno

    include cprint

    pageno = 0
    lineno = 0
    while (getlin(line, fd) ^= EOF) {
       if (lineno == 0)
          {
          pageno = pageno + 1
          if (dohead == YES)
		{
          	call skip(mar1)
          	call head(name, pageno)
          	call skip(mar2)
                lineno = mar1 + mar2 + 1
                }
          }
       call putlin(line, STDOUT)
       lineno = lineno + 1
       if (lineno + bmar >= plen)
          {
          call skip(bmar)
          lineno = 0
          }
       }
    if (lineno > 0)
       {
       call skip(plen-lineno)
        call skip(bmar)
	}
    return
    end
#-t-  fprint                      785  local   12/24/80  13:03:50
#-h-  head                        266  local   12/24/80  13:03:51
 # head - print top of page header
    subroutine head(name, pageno)
    integer name(ARB)
    character cdate(9), ctime(9)
    integer now(7)
    integer pageno
    string blanks "   "
    string page " Page  "

    call putlin(name, STDOUT)
    call putlin (blanks, STDOUT)
    call getnow (now)
    call fmtdat (cdate, ctime, now, 0)
    call putlin (cdate, STDOUT)
    call putch (BLANK, STDOUT)
    call putlin (ctime, STDOUT)
    call putlin (blanks, STDOUT)
    call putlin(page, STDOUT)
    call putdec(pageno, 1)
    call putc(NEWLINE)
    return
    end
#-t-  head                        266  local   12/24/80  13:03:51
#-h-  skip                        154  local   12/24/80  13:03:51
 # skip - output  n  blank lines
    subroutine skip(n)
    integer i, n

    for (i = 1; i <= n; i = i + 1)
       call putc(NEWLINE)
    return
    end
#-t-  skip                        154  local   12/24/80  13:03:51
#-t- tpr.r                       3423  ascii   02/02/82  13:40:22
