/*****************************************************************************
 * xs_wprintf: fprintf-like function for StaticText widgets
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <varargs.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/StaticText.h>

void xs_wprintf(va_alist)
  va_dcl
{
  Widget    w;
  char     *format;
  va_list   args;
  char      str[1000];  /* DANGER: Fixed buffer size */
  Arg       wargs[1];

  /*
   * Init the variable length args list.
   */
  va_start(args);
  /*
   * Extract the destination widget.
   * Make sure it is a subclass of StaticText.
   */
  w = va_arg(args, Widget);
  if(!XtIsSubclass(w, staticTextWidgetClass))
     XtError("xs_wprintf() requires a StaticText Widget");
  /*
   * Extract the format to be used.
   */
  format = va_arg(args, char *);
  /*
   * Use vsprintf to format the string to be displayed in the
   * StaticText widget.
   */
  vsprintf(str, format, args);

  XtSetArg(wargs[0], XtNstring, str);
  XtSetValues(w, wargs, 1);     

  va_end(args);
}
