/*****************************************************************************
 * str2ver.c: Convert a string to a verlevel.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "libXs.h"

Boolean
xs_cvt_str_to_verlevel(dpy, args, nargs, fromVal, toVal, data)
  Display     *dpy;
  XrmValuePtr  args;
  Cardinal    *nargs;
  XrmValuePtr  fromVal, toVal;
  XtPointer   *data;
{
  static verlevel result;
  /*
   * Make sure the number of args is correct.
   */
  if (*nargs != 0)
    XtWarning("String to verlevel conversion needs no args");
  /*
   * Convert the string in the fromVal to a verlevel pt.
   */
  if(!strcmp(fromVal->addr, "LEVEL1"))
    result =  LEVEL1;
  else if(!strcmp(fromVal->addr, "LEVEL2"))
    result =  LEVEL2;
  else if(!strcmp(fromVal->addr, "LEVEL3"))
    result =  LEVEL3;
  else if(!strcmp(fromVal->addr, "LEVEL4"))
    result =  LEVEL4;
  else {
     XtDisplayStringConversionWarning(dpy, fromVal->addr, 
                                      "Verlevel");
     return FALSE;
  }
  /*
   * Make the toVal point to the result.
   */
  toVal->size = sizeof (verlevel); 
  *(verlevel *)toVal->addr = result; 
  return TRUE;
}
