/*****************************************************************************
 * checkbox.c: Demonstrate the CheckBox widget.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/ControlAre.h>
#include <Xol/CheckBox.h>

main(argc, argv)
  int     argc;
  char   *argv[];
{
  Widget  toplevel, con, checkbox;
  int n;
  Arg wargs[2];
  void checkbox_callback();

  toplevel = OlInitialize(argv[0], "Checkbox", NULL, 0, 
                          &argc, argv);
  con = XtCreateManagedWidget("con", controlAreaWidgetClass, 
                              toplevel, NULL, 0);
  /*
   * Create checkbox widget.
   */
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "OL_LEFT Position"); n++;
  checkbox = XtCreateManagedWidget("checkbox",  checkBoxWidgetClass,
                                  con, wargs, n);
  XtAddCallback(checkbox, XtNselect, checkbox_callback, NULL);
  XtAddCallback(checkbox, XtNunselect, checkbox_callback, NULL);

  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void 
checkbox_callback(w, client_data, call_data)
  Widget     w;
  XtPointer  client_data, call_data;
{
  Arg warg[2];
  int n;
  Boolean set;

  n = 0;
  XtSetArg(warg[n], XtNset, &set); n++;
  XtGetValues(w, warg, n);
  n = 0;
  if(set == TRUE) {
      XtSetArg(warg[n], XtNlabel, "OL_RIGHT Position"); n++;
      XtSetArg(warg[n], XtNposition, OL_RIGHT); n++;
  } else {
      XtSetArg(warg[n], XtNlabel, "OL_LEFT Position"); n++;
      XtSetArg(warg[n], XtNposition, OL_LEFT); n++;
  }
  XtSetValues(w, warg, n);
}
