/*-------------------------------------------------------------*/
/*  File:  swindow.c 
 *
 *  Demonstrates the use of the ScrolledWindow widget with a
 *  StaticText as its child widget.
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/StaticText.h>
#include <Xol/ScrolledWi.h>

static char text[] = 

"This is a StaticText widget\n\
in a ScrolledWindow widget. \n\
When you scroll the text, the\n\
ScrolledWindow repositions the\n\
StaticText window, which, in\n\
turn, redraws the text,\n\
effectively scrolling it.\n";

/* Callback */
static void slider_moved();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, st;

/* Create the ScrolledWindow widget */    
    w = XtVaCreateManagedWidget("SWindow",
                      scrolledWindowWidgetClass, parent,
                      XtNwidth,            235,
                      XtNheight,           150,
                      XtNvStepSize,        20,
                      XtNhStepSize,        20,
                      NULL);

/* Create the StaticText widget as a child of the 
 * ScrolledWindow widget. 
 */
    st = XtVaCreateManagedWidget("SText",
                      staticTextWidgetClass, w,
                      XtNwidth,            230,
                      XtNheight,           150,
                      XtNstring,           text,
                      NULL);

    return w;
}
