/*-------------------------------------------------------------*/
/*  File:  form.c
 *
 *  Demonstrates the use of the Form widget.
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/Form.h>
#include <Xol/ControlAre.h>
#include <Xol/ScrolledWi.h>
#include <Xol/MenuButton.h>
#include <Xol/OblongButt.h>
#include <Xol/Text.h>

/* Labels for the OblongButtons used in pop-up menu */
static char* choices[] =
{
    "New...", "Open...", "Close", "Save", "Print...", "Exit"
};

/* Callback */
static void button_select();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, mbar, mbtn, menu, b, swin, tw;
    int i;

/* Create the Form widget */
    w = XtVaCreateManagedWidget("form",
                    formWidgetClass, parent,
                    NULL);
                
/* Add other widgets to the Form. First an area for menu */

    mbar = XtVaCreateManagedWidget("menubar",
                    controlAreaWidgetClass, w,
                    NULL);

/* Add a MenuButton to the menu area */
    mbtn = XtVaCreateManagedWidget("FileMenuButton",
                      menuButtonWidgetClass, mbar,
                      XtNlabel,         "File",
                      XtNtitle,         "File",
                      XtNpushpin,       OL_OUT,
                      NULL);

/* Get the menu pane's ID */
    XtVaGetValues(mbtn, XtNmenuPane, &menu, NULL);
    
/* Add the OblongButton widgets to the menu pane */
    for(i = 0; i < XtNumber(choices); i++)
    {
        b = XtVaCreateManagedWidget(choices[i],
                    oblongButtonWidgetClass, menu,
                    XtNlabel,   choices[i],
                    NULL);

/* Make the first menu item the default */
        if(i == 0) XtVaSetValues(b, XtNdefault, True, NULL);

/* Add callback to each oblong button. In this case, we are
 * using a single callback, but you can have a separate
 * callback for each button.
 */        
        XtAddCallback(b, XtNselect, button_select, 
                      (XtPointer)choices[i]);
    }

/* Add a ScrolledWindow and within it a Text widget */

    swin =  XtVaCreateManagedWidget("scrollwin",
                        scrolledWindowWidgetClass, w,
                        XtNyRefWidget,    mbar,
                        XtNyAddHeight,    True,
                        XtNxResizable,    True,
                        XtNyResizable,    True,
                        XtNyAttachBottom, True,
                        XtNxAttachRight,  True,
                        NULL);

    tw = XtVaCreateManagedWidget("text",
                        textWidgetClass, swin,
                        XtNheight,      500,
                        XtNwidth,       500,
                        NULL);
    return w;
}
/*-------------------------------------------------------------*/
static void button_select(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    printf("%s SELECTED\n", (char*) client_data);

/* Exit program if the menu choice is "Exit" */
    if(strcmp((char*)client_data, "Exit") == 0)
    {
        XtCloseDisplay(XtDisplay(w));
        exit(0);
    }
}
