#
#define STOP	-1

struct menu {
	char *mstring;
	int color;
	int mpad;
};

struct mdesc {
	int mdpad1;
	int mdline;
	int mdpad[3];
};


struct mdesc mdan {
	1,3,2,1,10
};

struct menu manother[] {
	"Another ?",	0,	0,
	"or STOP",	STOP,	0
};
struct menu *mlan[] {
	manother,
	0
};

#define STARS	0
#define ATS	1
#define DOLLS	2
#define PLUS	3
#define AMPS	4
#define POUNDS	5


struct menu *mlcolor[] {
	mcolors,
	0
};
struct menu mcolors[] {
	"OOOO", STARS, 0,
	"[][]", ATS, 0,
	"I--I", DOLLS, 0,
	" Give", STOP,	0,
	"!!!!",	PLUS,	0,
	"<><>",	AMPS,	0,
	"XXXX",	POUNDS,	0,
	"up ?",	STOP,	0,
	0
};

struct mdesc mdcolor {
	15,8,4,2,6
};


struct {
	int poppad[4];
} popopen[] {
	1,11,1,1,		/* name */
	1,10,17,17,		/* games won */
	1,10,18,18,		/* games lost */
	67,71,2,2,		/* BULL */
	74,78,2,2,		/* COWS */
	12,14,17,17,		/* games won total */
	12,14,18,18,		/* games lost total */
	37,65,1,3,		/* hidden choice */
	1,21,15,15,		/* result window */
	69,69,4,18,		/* bulls scored */
	75,75,4,18,		/* cows score */
	39,69,4,18,		/* clear board */
	17,22,6,6,		/* pieces */
};

char *popstring[] {
	"FASTER MIND",
	"Games won",
	"Games lost",
	"BLACK",
	"WHITE"
};
#define TWON	&popopen[5]
#define TLOST	&popopen[6]
#define HCHOICE	&popopen[7]
#define RESW	&popopen[8]
#define BULLS	&popopen[9]
#define COWS	&popopen[10]
#define BOARD	&popopen[11]
#define PIECES	&popopen[12]

struct mdesc mdmove {
	38,4,1,4,7
};
struct menu mmove[] {
	"",	0,	0,
	"",	1,	0,
	"",	2,	0,
	"",	3,	0,
};
struct menu *mlmove[] {
	mmove,
	0
};

int try[4], chosen[4];

int popcolor;
int popresult;
int popchosen;
int popnwon, popnlost;
int anpop;
int popbull, popcow;

int lost, won;

main()
{
int n;
int i;

	for(i=0; i<5; i++) {
		n = popen(&popopen[i]);
		pfprintf(n, popstring[i]);
		pclose(n);
	}
	popnwon = popen(TWON);
	popnlost = popen(TLOST);
	pfprintf(popnwon, "%d", won);
	pfprintf(popnlost, "%d", lost);
	phome(popnwon);
	phome(popnlost);
	popresult = popen(RESW);
	popcow = popen(COWS);
	popbull = popen(BULLS);
	noroll(popcow);
	noroll(popbull);
	anpop = msetup(&mlan, &mdan);
	popchosen = popen(HCHOICE);
	pselect(popchosen);
	noroll(popchosen);
	pnoitt(popchosen);
	hideline(0);
	hideline(2);
	popcolor = msetup(&mlcolor, &mdcolor);
	n = popen(PIECES);
	pfprintf(n, "Pieces");
	pclose(n);
	won = lost = 0;

	do {
		hideline(1);
		choose();
		n = 0;
		for(i=0; i<8; i++)
			if (n = domove(i)) {
				break;
			}
		if (n != 1) {
			showchoice();
			pfprintf(popresult, "Better luck next time");
			pfprintf(popnlost, "%d", ++lost);
			phome(popnlost);
		}
		else {
			pfputc(popresult,7);
			pfprintf(popresult, "Game won in %d moves", ++i);
			phome(popresult);
			pfputc(popresult,7);
			showchoice();
			pfprintf(popnwon, "%d", ++won);
			phome(popnwon);
		}
	}
	while (another(i) != STOP);

	pexit();
}



another(nc)
{
struct menu *p;
int popboard;
int n;

	p = mselect(anpop, &mlan, &mdan);
	if (p->color != STOP) {
		phome(popbull);
		phome(popcow);
		popboard = popen(BOARD);
		n = 0;
		while (nc--) {
			pcline(popboard,n);
			pcline(popbull,n);
			pcline(popcow,n);
			n =+ 2;
		}
		pclose(popboard);
		pclear(popresult);
	}
	return(p->color);
}


score()
{
int cmat[4], tmat[4];
int cows, bulls;
int i,j;

	cows = bulls = 0;
	for (i=0; i<4; i++) {
		cmat[i] = 1;
		tmat[i] = 1;
	};

	for(i=0; i<4; i++)
		if (try[i] == chosen[i]) {
			bulls++;
			tmat[i] = cmat[i] = 0;
		}
	for (i=0; i<4; i++)
		for (j=0; j<4; j++)
			if((i!=j)&&(chosen[i]==try[j])&&cmat[i]&&tmat[j]) {
				cows++;
				tmat[j] = cmat[i] = 0;
			}

	pfprintf(popbull, "%d", bulls);
	pfprintf(popcow, "%d", cows);
	phseek(popbull,0,0);
	phseek(popcow,0,0);
	pvseek(popbull,1,2);
	pvseek(popcow,1,2);

	if (bulls == 4)
		return(1);
	else
		return(0);
}


hideline(n)
{
int i;

	pmove(popchosen,0,n);
	for(i=0;i<29;i++)
		pputc('*');
}


choose()
{
int i,n;
int tvec[2];

	time(tvec);
	srand(tvec[1]);
	for (i=0; i<4; i++) {
		while ((n = (rand()&01600) >> 7) > 5);
		chosen[i] = n;
	}
}



showchoice()
{
int i, n;
struct menu *p;

	pmove(popchosen,1,1);
	for (i=0; i<4; i++) {
		n = chosen[i];
		p = &mcolors[n];
		if (n > 2)
			p++;
		pprintf(" %s", p->mstring);
		pputc(' ');
		phseek(popchosen, 1, 1);
	}
	pflush();
}



domove(mi)
{
int popmove;
int putcount;
int i;
struct menu *p, *mp;

	mdmove.mdline = 4 + (mi << 1);
	popmove = msetup(&mlmove, &mdmove);
	putcount = 0;
	for (i=0; i<4; i++)
		try[i] = -1;
	do {
		p = mselect(popcolor, &mlcolor, &mdcolor);
		if (p->color == STOP) {
			pclose(popmove);
			return(-1);
		}
		mp = mselect(popmove, &mlmove, &mdmove);
		pfprintf(popmove, " %s", p->mstring);
		phseek(popmove,1,-5);
		i = mp->color;
		if (try[i] == -1)
			putcount++;
		try[i] = p->color;
	}
	while (putcount < 4);
	pclose(popmove);
	if (score())
		return(1);
	return(0);
}


noroll(popid)
{
int n;

	n = pgmode(popid);
	n =& ~020;
	psmode(popid,n);
}
