#

/*// produce a debug listing of intermediate text if dbflg != 0 */

#include "8080asm.h"

int dbflg 0;		/*//1=> debug listing */

debug()
{

	register ix, xtyp, xval;

	if(dbflg==0) return;
	printf("%d<%x>%d",stbuf[0].itop,loctr,stbuf[0].itrl);
	if(stbuf[1].itop!=0) {	/*//label */
		printf(" %.8s:",stbuf[1].itop);
	}

/*//loop to output opcode and operands */

	for(ix=2; ix<stbuf[0].itrl; ix++) {
		xtyp = stbuf[ix].itty;
		xval = stbuf[ix].itop;
		if(xtyp==ITBS) {			/*//beginning of statement */
			printf(" ***ERROR***\n");
			return;
		}

		if(xtyp==ITSY) {			/*//symbol */
			printf(" %.8s",xval);	/*//print symbol */
			if(ix==2) continue;		/*//opcode */
			putchar('=');
			if(xval->flags&SYDF) {	/*//defined */
				if(xval->flags&SYXR)	/*//external */
					putchar('e');
				else {
					if(xval->flags&SYRL)
						putchar('r');	/*//relocatable */
					else
						putchar('a');	/*//absolute */
					printf(" %d",xval->vl1);
				}
			}
			else
				putchar('u');		/*//undefined */
		}
		else if(xtyp==ITCN) {	/*//constant */
			printf(" %d",xval);
		}
		printf("; ");
	}	/*//endfor */
	printf("\n");
}
