
// Segment TE2

GET "te.hdr"

// Result of this routine may be:-
//    0 - abandon (after Quit)
//    1 - finish normally
//    2 - rewind and re-edit
//    3 - abandon (after offline command error)

LET EDIT() = VALOF
$(1
   REPEATING := FALSE

SW:
   IF 'a' LE COMM LE 'z' THEN
      COMM := COMM + 'A' - 'a'

   A1, A2, STATE := 1, 0, 0
   DELETING := FALSE
   SW.COMM := COMM		// Copy not destroyed by 'NUMARGS'

   SWITCHON COMM INTO
   $(SW
      DEFAULT:
      UNKNOWN:
         WRITEF("Illegal command *'%C*'*N", COMM)
         GOTO CMDERR

      NULLCTX:
         WRITES("Null context*N")

         // Swallow rest of line on error

      CMDERR:
         IF OFFLINE THEN
         $( WRITES("Abandon*N")
            RESULTIS 3
         $)
         UNTIL COMM = '*N' DO COMM := RDCH()
         NOTK := TRUE

      CASE 'V':
      CASE '?':
         OUT(COMM = '?' -> 1, 0)
         UNCHANGED := TRUE
         ENDCASE

      CASE ENDSTREAMCH:
         IF CMISAV NE 0 THEN    // Command file is open
         $( ENDREAD()
            EDITS := CMISAV
            CMISAV := 0
            SELECTINPUT(EDITS)
            ENDCASE
         $)

      CASE 'W':
      CASE '**':
         CHANGE(BIGNUM)
         RESULTIS COMM = '**' -> 2, 1

      CASE 'Q':
         RESULTIS 0         // Abandon edit

      CASE 'X':
         OFFLINE := NOT OFFLINE
         ENDCASE

      CASE '!':      // *** Special for UNIX version ***
         UNIX()
         ENDCASE

      CASE 'C':
         UNLESS CHANGECOM() GOTO CMDERR
         LOOP

      CASE 'O':
         UNLESS CHANGEOUT() GOTO CMDERR
         LOOP

      CASE '*N':
         UNLESS QUIET \/ UNCHANGED DO OUT(0)
         NOTK := TRUE	// K is very transitory!
         UNCHANGED := TRUE
         ENDCASE
   
      CASE 'U':
         QUIET := NOT QUIET

      CASE '*S':
      CASE '*T':
      CASE #15:	// Space, tab, CR
         ENDCASE
   
      CASE '-':
         DELETING := TRUE
   
      CASE '+':
         NUMARGS(1)
         CHANGE(CURRENT + A1)
         LOOP

      CASE 'N':
         NEXTLINE()
         ENDCASE

      CASE 'I':
      CASE 'H':
      CASE 'M':
         NUMARGS(1)
         IF STATE = 0 DO A1 := CURRENT
         CHANGE(A1)
         IF SW.COMM = 'I' DO INSERT()
         IF SW.COMM = 'H' DO UNLESS CHANGEIN(0) GOTO CMDERR
         LOOP

      CASE 'S':
         UNLESS CHANGEIN(1) GOTO CMDERR
         LOOP

      CASE '=':
         NUMARGS(1)
         IF STATE = 0 THEN
         $( WRITES("Missing number*N")
            GOTO CMDERR
         $)
         CURRENT := A1
         LOOP

      CASE '#':
         NUMARGS(1)
         IF POINTER + A1 > LINEL THEN A1 := LINEL - POINTER
         FOR I = 1 TO A1 DO
         $( POINTER := POINTER + 1
            LINEV!POINTER := -1
         $)
         UNLESS A1 = 0 DO CND := TRUE
         UNCHANGED := FALSE	// Enable verification
         LOOP

      CASE '^':
      CASE '>':
         NUMARGS(1)
         POINTER := POINTER + A1
         IF POINTER > LINEL DO POINTER := LINEL
         LOOP

      CASE '_':
      CASE '<':
         IF CND DO CONDENSE()
         POINTER := 0
         ENDCASE

      CASE '%':
         NUMARGS(1)
         IF POINTER + A1 > LINEL DO A1 := LINEL - POINTER
         FOR I = 1 TO A1 DO
         $( POINTER := POINTER + 1
            IF 'a' LE LINEV!POINTER LE 'z' THEN
            LINEV!POINTER := LINEV!POINTER + 'A' - 'a'
         $)
         LOOP

      CASE '$':
         NUMARGS(1)
         IF POINTER + A1 > LINEL DO A1 := LINEL - POINTER
         FOR I = 1 TO A1 DO
         $( POINTER := POINTER + 1
            IF 'A' LE LINEV!POINTER LE 'Z' DO
            LINEV!POINTER := LINEV!POINTER + 'a' - 'A'
         $)
         LOOP

      CASE 'T':
         NUMARGS(1)
         FOR I = 1 TO A1 DO
         $( CHANGE(CURRENT + 1)
            IF EXHAUSTED BREAK
            VERLINE()
         $)
         UNCHANGED := TRUE
         LOOP

      CASE 'Z':
         COMM := RDCH()
         IF COMM = '*N' THEN
         $( ZCH := 'Z'
            LOOP
         $)
         ZCH := COMM
         ENDCASE

      CASE 'A':
      CASE 'B':
      CASE 'E':
         ABEG.ARGS()
         IF (ABEG.SIZE = 0) & (REPLSIZE = 0) GOTO NULLCTX

         COMPRESS()
         $( LET P, Q = POINTER, LINEL - ABEG.SIZE
            $( P := INDEX(P, Q, ABEG.CON, ABEG.SIZE)
               IF P < 0 THEN
               $( WRITES("No match*N")
                  WIDEN()
                  GOTO CMDERR
               $)
               IF ABEG.SIZE = 0 THEN
               $( IF ABE.COMM = 'A' DO P := LINEL
		  IF ABE.COMM = 'E' GOTO NULLCTX
               $)

               Q := P + ABEG.SIZE

               IF ABE.COMM = 'B' DO Q := P
               IF ABE.COMM='A' DO P := Q

               SUBST(P, Q)
               WIDEN()
               UNCHANGED := FALSE
               LOOP
            $)
         $)

      CASE ':':
         WRITES(VALOF SWITCHON TCH INTO
         $( DEFAULT  : RESULTIS "P"
            CASE '*N': RESULTIS "NL"
            CASE FMFD: RESULTIS "FF"
            CASE VTAB: RESULTIS "VT"
         $)  )
         NEWLINE()
         ENDCASE

      CASE ';':
         COMM :=  RDCH() REPEATWHILE COMM='*S'
         IF 'a' LE COMM LE 'z' THEN
            COMM := COMM + 'A' - 'a'
            SWITCHON COMM INTO
            $( DEFAULT : WRITES("Illegal terminator code*N")
                         GOTO CMDERR
               CASE 'P': TCH := 0; ENDCASE
               CASE 'N': TCH := '*N'; ENDCASE
               CASE 'F': TCH := FMFD; ENDCASE
               CASE 'V': TCH := VTAB
            $)
            ENDCASE

      CASE '*"':
         CHANGE(CURRENT + 1)

      CASE '*'':
         IF ABE.COMM = '*S' THEN    // No previous context command
         $( OUT(0)
            UNCHANGED := TRUE    // Simulate V command
            ENDCASE
         $)
         REPEATING := TRUE
         COMM := ABE.COMM
         GOTO SW

      CASE ',':
         CHANGE(CURRENT + 1)

      CASE '&':
         IF FL.COMM = '*S' THEN
         $( OUT(0)    // No previous F, L, DF or DL command
            UNCHANGED := TRUE      // Simulate V command
            ENDCASE
         $)

         REPEATING := TRUE

FLLAB:
      CASE 'L':
      CASE 'F':
      CASE -'L':
      CASE -'F':
      $( LET VER = FALSE
         AND P, Q = ?, ?

         LF.ARG()
         IF FL.COMM < 0 THEN DELETING := TRUE

         IF LF.SIZE = 0 GOTO NULLCTX

         $( IF EXHAUSTED THEN
            $( UNCHANGED := FALSE
               BREAK
            $)
            COMPRESS()
            P := POINTER
            Q := FL.COMM = 'L' \/ FL.COMM = -'L' -> LINEL-LF.SIZE, P
            UNLESS LF.SIZE > LINEL - P DO
               IF INDEX(P, Q, LF.CON, LF.SIZE) GE 0 THEN
               $( WIDEN()
                  IF VER THEN UNCHANGED := FALSE
                  BREAK
               $)
            NEXTLINE()
            VER := TRUE
         $) REPEAT
         LOOP
      $)

      CASE 'K':
         NOTK := NOT NOTK
         ENDCASE

      CASE 'G':
         ABEG.ARGS()

         IF ABEG.SIZE = 0  GOTO NULLCTX

         $( LET P = POINTER
            AND SUBSW = FALSE

            $( COMPRESS()
               P := INDEX(P, LINEL-ABEG.SIZE, ABEG.CON, ABEG.SIZE)
               IF P < 0 BREAK
               SUBST(P, P + ABEG.SIZE)
               SUBSW := TRUE
               P := P + REPLSIZE
            $) REPEAT

            IF SUBSW UNLESS QUIET DO OUT(0)
            NEXTLINE()
         $) REPEATUNTIL EXHAUSTED

         IF QUIET DO NEWLINE()
         RESULTIS 2

      CASE 'D':
      CASE 'R':
         NUMARGS(2)
         IF STATE = 0 & SW.COMM = 'D' & (COMM = 'F' \/ COMM = 'L') DO
         $( DELETING := TRUE
            GOTO FLLAB
         $)
         IF STATE = 0 DO A1, A2 := CURRENT, CURRENT
         IF STATE = 1 DO A2 := A1

         CHANGE(A2)
         DELETING := TRUE
         CHANGE(A1 + 1)
         IF SW.COMM = 'R' DO INSERT()
         LOOP
   $)SW
   COMM := RDCH()
$)1 REPEAT

LET CHANGECOM() = VALOF
$( LET FILE = VEC 40
   AND COUNT = 0
   AND EC = ?

   COMM := RDCH() REPEATWHILE COMM = '*S'
   IF COMM = '*N' DO
   $( WRITES("Missing filename*N")
      RESULTIS FALSE
   $)

   UNTIL COMM = '*N' \/ COMM='*S' DO
   $( COUNT := COUNT + 1
      PUTBYTE(FILE, COUNT, COMM)
      COMM := RDCH()
   $)

   PUTBYTE(FILE, 0, COUNT)

   EC := FINDFASTINPUT(FILE)
   IF EC < 0 THEN
   $( IOERROR(-EC, FILE)
      RESULTIS FALSE
   $)

   TEST CMISAV = 0 THEN
      CMISAV := EDITS
   OR
   $( SELECTINPUT(EDITS)
      ENDREAD()
   $)

   EDITS := EC
   SELECTINPUT(EDITS)
   RESULTIS TRUE
$)

AND CHANGEOUT() = VALOF
$( LET FILE = VEC 40
   AND COUNT = 0
   AND EC = ?

   COMM := RDCH() REPEATWHILE COMM = '*S'
   IF COMM = '**' DO
   $( COMM := RDCH()
      TEST OSAV = 0 THEN    // Use alternate output file
      $( WRITES("No alternate*N")
         RESULTIS FALSE
      $)
      OR
      $( TEST OSAV = OTXT THEN
         $( SELECTOUTPUT(TEXTOUT)
            TEXTOUT := OSAV
         $)
         OR
            SELECTOUTPUT(OSAV)
         ENDWRITE()
         SELECTOUTPUT(VEROUT)
         WRITES("Closed*N")
         OSAV := 0
         RESULTIS TRUE
      $)
   $)

   UNTIL COMM = '*N' \/ COMM = '*S' DO
   $( COUNT := COUNT + 1
      PUTBYTE(FILE, COUNT, COMM)
      COMM := RDCH()
   $)

   PUTBYTE(FILE, 0, COUNT)

   TEST COUNT = 0 THEN    // Command to swop output file
   $( TEST OSAV = 0 THEN
      $( WRITES("No alternate output*N")
         RESULTIS FALSE
      $)
      OR
         WRITES(OSAV = OTXT -> "Selected*N", "Alt selected*N")

      $( LET X = TEXTOUT
         TEXTOUT := OSAV
         OSAV := X
      $)
   $)
   OR

   // Select new alternate output file

   $( IF OSAV NE 0 THEN     // Close any existing alternate output
      $( SELECTOUTPUT(OTXT = TEXTOUT -> OSAV, TEXTOUT)
         ENDWRITE()
         SELECTOUTPUT(VEROUT)
         OSAV := 0
      $)

      EC := FINDFASTOUTPUT(FILE)
      IF EC < 0 THEN
      $( IOERROR(-EC, FILE)
         RESULTIS FALSE
      $)
      WRITES("Created*N")

      OSAV := OTXT
      TEXTOUT := EC
   $)
   RESULTIS TRUE
$)

.
