
// File TE.BPL

// Identification: 01

// TITAN editor program (UNIX version)

// R.D. Eager UKC   04-May-77

// Segment TE1

GET "te.hdr"
GET "ioerr.hdr"
GET "syshdr.bpl"

LET START() BE
$( LET A = VEC OLINEMAX + 40   // Allow space for tab expansion
   AND B = VEC CTXMAX
   AND C = VEC CTXMAX
   AND D = VEC CTXMAX
   AND IV = VEC 40
   AND ITVS = VEC 40
   AND OTVS = VEC 40
   AND IED = ?
   AND ITV, OTV = ?, ?
   AND UB = VEC 50
   AND TF1 = "XXXXXXed.tmp"
   AND TF2 = "XXXXXXin.tmp"
   AND TEMPOUT = VEC 7
   AND TEMPIN = VEC 7
   AND OLDTTYV = VEC 2
   AND NEWTTYV = VEC 2
   AND RMES = "Rename error %N %S -> %S*N"
   AND EDTYP = 0    // Tentatively file to temp

   // EDTYP = -1   - means temporary file in use for input
   // EDTYP =  0   - means use temporary file for output
   // EDTYP = +1   - means ordinary file-to-file edit

   RESET.LEVEL := LEVEL()

   // Close SYSIN and SYSOUT in order to release unwanted
   // buffer space.

   ENDREAD(); ENDWRITE()   // SYSIN and SYSOUT are selected on entry
   SYSIN := STDIN            // Use standard I/O streams instead
   SYSOUT := STDOUT

   $( LET PID = SYSCALL(SY.GETPID)   // Generate unique temporary filenames

      FOR I = 6 TO 1 BY -1 DO
      $( LET C = (PID & #7) + '0'
         PUTBYTE(TF1, I, C)
         PUTBYTE(TF2, I, C)
         PID := PID >> 3
      $)
   $)

   SYSCALL(SY.GTTY, SYSIN - 1, OLDTTYV << 1)  // Save tty settings
   SYSCALL(SY.SIGNAL, S.SIGINTR, RESET.AND.EXIT)  // Arrange to catch interrupts
   FOR I = 0 to 2 DO NEWTTYV!I := OLDTTYV!I   // Copy tty settings
   PUTBYTE(NEWTTYV, 2, #177)    // Subtly alter so that # can be used
   SYSCALL(SY.STTY, SYSIN - 1, NEWTTYV << 1)  // Do an 'stty erase <delete>'

   SELECTOUTPUT(SYSOUT)

   EDITS, VEROUT := SYSIN, SYSOUT
   LINEV, LF.CON, ABEG.CON, REPLV := A, B, C, D
   OFFLINE := FALSE
   ITV, OTV := ITVS, OTVS
   ITVSS := ITVS      // For external use by UNIX() routine
   UNIXBUFFER := UB
   UNIXBUFFER!0 := 0    // Initialise to null string

   UNLESS 1 LE ARGC LE 2 DO
   $( WRITES("Arg count*N")
      GOTO RESET.AND.EXIT
   $)

   IF ARGC = 2 THEN
   $( IF GETBYTE(ARGV!2, 1) = '-' THEN    // We have parameters
      $( LET X = ARGV!2      // Make params argument 1
         ARGV!2 := ARGV!1
         ARGV!1 := X
      $)

      IF GETBYTE(ARGV!1, 1) = '-' THEN   // Process parameters
      $( LET PARAM = GETBYTE(ARGV!1, 2)
         TEST PARAM = 'c' \/ PARAM = 'C' THEN
         $( ARGV!1 := ARGV!2   // Move args down
            ARGC := 1
            $( LET EC = FINDOUTPUT(ARGV!1)
               IF EC < 0 THEN
               $( IOERROR(-EC, ARGV!1)
                  GOTO RESET.AND.EXIT
               $)

               SELECTOUTPUT(EC)
               ENDWRITE()
               SELECTOUTPUT(SYSOUT)
            $)
         $)
         OR
         $( WRITES("Bad arg*N")
            GOTO RESET.AND.EXIT
         $)
      $)
   $)

   COPYNAME(ARGV!1, ITV)
   COPYNAME(ARGC = 2 -> ARGV!2, "", OTV)

   ZCH := 'Z'     // 'Insert' terminator
   QUIET := FALSE
   CMISAV := 0    // No auxiliary command file
   ABE.COMM, FL.COMM := '*S', '*S'

STAR:
   SELECTINPUT(EDITS)
   SELECTOUTPUT(VEROUT)

   TEXTIN := FINDFASTINPUT(ITV)
   IF TEXTIN < 0 THEN
   $( IOERROR(-TEXTIN, ITV)
      GOTO RESET.AND.EXIT
   $)

   TEST (GETBYTE(OTV, 0) = 0) \/ TESTIOSAME(ITV, OTV) THEN    // Editing file 'to itself'
      COPYNAME(TF1, OTV)
   OR
      EDTYP := 1	// File to file

   TEXTOUT := FINDFASTOUTPUT(OTV)
   IF TEXTOUT < 0 THEN
   $( IOERROR(-TEXTOUT, OTV)
      GOTO RESET.AND.EXIT
   $)

   LINEL, REPLSIZE := 0, 0
   POINTER := 0
   NOTK := TRUE
   CURRENT, EMPTY, EXHAUSTED := 0, TRUE, FALSE
   DELETING, UNCHANGED := FALSE, TRUE	// Suppress line 0!!
   OSAV, OTXT := 0, TEXTOUT
   ISAV, ITXT := 0, TEXTIN
   NEWIN := FALSE
   PART, CND := FALSE, FALSE

   COMM := '*S'

   WRITES("Ready*N")

   IED := EDIT()

   IF IED = 0 GOTO RESET.AND.EXIT    // Edit abandoned by Q command

   SELECTINPUT(TEXTIN)
   ENDREAD()

   SELECTOUTPUT(TEXTOUT)
   ENDWRITE()

   IF ISAV NE 0 THEN
   $( SELECTINPUT(ISAV)
      ENDREAD()
   $)

   IF OSAV NE 0 THEN
   $( SELECTOUTPUT(OSAV)
      ENDWRITE()
   $)

   IF IED = 3 THEN         // Offline command error
   $( DELETEFILE(OTV)      // Nascent output file
      IF EDTYP < 0 THEN    // Temp-to-temp edit
         DELETEFILE(ITV)   // - delete temporary input file
      GOTO RESET.AND.EXIT
   $)

   SELECTOUTPUT(VEROUT)

   IF IED = 1 THEN    // Normal termination
   $( LET T = ?

      IF EDTYP > 0 GOTO RESET.AND.EXIT    // File-to-file edit

      DELETEFILE(ITVS)    // Delete original input file
      IF EDTYP < 0 THEN DELETEFILE(ITV)    // Temp-to-temp edit - delete temporary input file

      // Rename output file to original input filename

      T := RENAMEFILE(OTV, ITVS)
      IF T < 0 THEN
         WRITEF(RMES, -T, OTV, ITVS)
      GOTO RESET.AND.EXIT
   $)

   // Case where file is to be 'rewound' (IED = 2)

   TEST EDTYP > 0 THEN
   $( COPYNAME(OTVS, ITVS)
      EDTYP := 0
   $)
   OR
   $( LET T = ?
      ITV := IV
      COPYNAME(TF2, ITV)
      DELETEFILE(ITV)
      T := RENAMEFILE(OTV, ITV)
      IF T < 0 THEN
      $( WRITEF(RMES, -T, OTV, ITV)
         GOTO RESET.AND.EXIT
      $)
      EDTYP := -1        // Temp to temp
   $)
   COPYNAME("", OTV)

   GOTO STAR

   // Interrupt handler - also used on general exit to reset tty

RESET.AND.EXIT:
   LONGJUMP(RESET.LEVEL, HERE)     // Reset stack
HERE:
   SYSCALL(SY.STTY, SYSIN - 1, OLDTTYV << 1)  // Restore initial tty settings
   FINISH
$)

AND TESTIOSAME(IS, OS) = VALOF
$( LET VI = VEC 17
   AND VO = VEC 17
   AND TS = VEC 40

   IF SYSCALL(SY.STAT, BCSTR(IS, TS) << 1, VI << 1) < 0 RESULTIS FALSE
   IF SYSCALL(SY.STAT, BCSTR(OS, TS) << 1, VO << 1) < 0 RESULTIS FALSE

   RESULTIS (VI!0 = VO!0) & (VI!1 = VO!1)
$)

AND COPYNAME(SRC, DST) BE
$( LET LEN = GETBYTE(SRC, 0)
   IF LEN > 40 THEN
   $( IOERROR(E.PNTL, SRC)
      GOTO RESET.AND.EXIT   // LONGJUMP done at other end!!
   $)

   FOR I = 0 TO LEN DO
      PUTBYTE(DST, I, GETBYTE(SRC, I))
$)

AND IOERROR(CODE, DSD) BE
$( SELECTOUTPUT(SYSOUT)
   SWITCHON CODE INTO
   $( CASE E.NEX : WRITES("I can*'t find ") ; ENDCASE
      CASE E.NA  : WRITES("Protection violation: ") ; ENDCASE
      CASE E.PNTL: WRITES("Pathname too long: "); ENDCASE
      DEFAULT    : WRITEF("Problem %N with file ", CODE)
   $)
   WRITEF("*'%S*'*N", DSD)
   IF OFFLINE THEN
   $( WRITES("Abandon*N")
      FINISH
   $)
$)

.
