#
/*
 *	fpsim.c
 *	Program to look for floating point instructions in 'as'
 *	code and replace them by
 *	jsr pc,fpsim
 *	fpinstruction
 *	except for setf, setd, seti and setl
 *	sequences of instructions are only preceded by a single
 *	call to the routine.
 *	Deals with two commands on  a line (separated by ;) be
 *	effectively removing the ';'
 *	Should 'hopefully' deal with hand-coded as but there may
 *	be problems
 *	To use the program, the code for fp.o in /lib/liba.a
 *	must be modified in two ways:
 *	1)	make sure the 'lookahead' code from UNIX News Vol 1 No 6
 *	has been installed.
 *	2)	The entry fpsim to fp.o must be installed - get this from ucsd_fort
 *		on Chicago distribution
 *
 *	Call to the program is
 *		fpsim ifile ofile
 *	where ifile is the file to be modified and ofile is the destination
 *	if '-' is used as ifile, the source is copied to /tmp/nofpXXX
 *	and this file is used as source.
 *	Peter Collinson UKC
 *	November 1977
 */

/* instruction types */
#define	SETF	1
#define	SETD	2
#define	SETI	3
#define	SETL	4
#define	FL	5

/* Buffers and pointers */
char	ipbuf[518];			/* buffer for input file getc */
char	ibuf[2048];			/* buffer for line processing */
char	*colon;				/* Points to character position after last colon on line */
char	*equals;			/* points to equals sign if any found */
char	*label;				/* Points to label field in instruction */
char	*ins;				/* points to ins field in instruction */
char	insbuf[6];			/* contains instruction mnemonic for matching */

char tmp[]	"/tmp/nofpXXXXX";	/* temporary file */
int	tmpfile	0;		/* set if file established */
extern 	fout;
char	sn[] "%s\n";		/* useful string */

/* Code tables */

char	setf[]	"bic	$m.ext, fpsr";
char	setd[]	"bis	$m.ext, fpsr";
char	seti[]	"bic	$m.lngi, fpsr";
char	setl[]	"bis	$m.lngi, fpsr";
char	fpsim[]	"jsr	pc, fpsim";
char	glo[]	".globl	fpsim, fpsr, m.ext, m.lngi";
int	gloflg;				/* if set causes above line to be printed */

/* Decode table for instructions */
struct match
{	int	val;
	char	*mnem;
} match[] {
	SETF,	"setf",
	SETD,	"setd",
	SETI,	"seti",
	SETL,	"setl",
	FL,	"cfcc",
	FL,	"clrf",
	FL,	"negf",
	FL,	"absf",
	FL,	"tstf",
	FL,	"movf",
	FL,	"movif",
	FL,	"movfi",
	FL,	"movof",
	FL,	"movfo",
	FL,	"movie",
	FL,	"movei",
	FL,	"addf",
	FL,	"subf",
	FL,	"mulf",
	FL,	"divf",
	FL,	"cmpf",
	FL,	"modf",
	FL,	"ldfps",
	FL,	"stfps",
	FL,	"stst",
	FL,	"ldexp",
	FL,	"stexp",
	0
};



leave()
{	if(tmpfile) unlink(tmp);
	exit(1);
}
main(argc, argv)
int argc; char **argv;
{	signal(2, leave);

	if(argc < 3)
		error("Arg count");
	if(argv[1][0] == '+') {	gloflg++; argv++; argc--;	}
	if(argv[1][0] == '-') copytmp(argv[2]);
	else
	if(fopen(argv[1], ipbuf) < 0)
		error("Cannot open: %s", argv[1]);
	if((fout = creat(argv[2], 0666)) < 0)
	{	fout = 2;
		error("Cannot creat: %s", argv[2]);
	}
	fileprocess();
	flush();
	if(tmpfile) unlink(tmp);
	exit(0);
}


fileprocess()
{	register char c, *op;
	register int lastone;
	lastone = 0;
	if(gloflg) printf(sn, glo);

	for(;;)
	{	if(linein() == 0) return;
		if(equals || notins())
		{	if(label) lastone = 0;
			printf(sn, ibuf);
		}
		else
		{	if(label)
			{	lastone = 0;	/* force a call to fpsim if label */
				c = *ins;
				*ins = '\0';
				printf("%s", label);
				*ins = c;
			}
			if(*ins == '\0') printf("\n");
			else
			switch(matchins())
			{
			case SETI:	op = seti; goto prset;
			case SETD:	op = setd; goto prset;
			case SETF:	op = setf; goto prset;
			case SETL:	op = setl;
			prset:		printf(sn, op);
					lastone = 0;
					continue;

			case FL:	if(lastone == 0)
						printf(sn, fpsim);
					lastone++;
					goto rem;
			default:	lastone = 0;
			rem:		printf(sn, ins);
			}
		}
	}
}


/* Basic line reading routine */
int linein()
{	register char c,*p;
	register int comment;
	sn[2] = '\n';
	comment = 0;
	colon = 0;
	equals = 0;
	p = ibuf;
	while(c = getc(ipbuf))
	{	if(c <= 0) return(0);
		if(c == '\n' || c == ';') break;
		*p++ = c;
		if(c == '/') comment++;
		if(comment) continue;
		if(c == ':') colon = p;
		else
		if(c == '=') equals = p;
	}
	sn[2] = c;
	*p++ = '\0';
	return(1);
}

/* tests for line in ibuf being and instruction which it
 * is worth investigating further
 * also sets up field pointers
 */

int notins()
{	register char *p, *q;
	label = 0;			/* set start of label field off */
	p = ibuf;			/* set working pointer */
	if(colon)			/* If we have a colon - we certainly have a label */
	{	label = ibuf;		/* at the start of the buffer */
		p = colon;		/* Move working pointer */
	}
	/* ignore leading spaces and tabs */
	for(ins = p; (*p == ' ' || *p == '\t'); p++);
	/* copy mnemonic into insbuf */
	for(q = insbuf; (*p >= 'a' && *p <= 'z'); *q++ = *p++);
	*q = '\0';
	return(q == insbuf);
}

/*
 * match the match array with contents of ins buffer 
 */

int matchins()
{	register char *p;
	register struct match *m;
	for(m = &match[0]; m->val; m++)
		if(compstr(m->mnem, insbuf)) return(m->val);
	return(0);
}

int compstr(str1, str2)
char *str1, *str2;
{	register char *a, *b, c;
	a = str1; b = str2;
	while(c = *a++)
		if(c != *b++) return(0);
	return(*b == '\0');
}

pidfn()
{	register i,j,c;
	int p;

	p = getpid();
	i = 0;
	while(tmp[i] != 'X') i++;
	i =+ 4;
	for(j = 0; j < 5; j++)
	{	c = (p%10) + '0';
		p =/ 10;
		tmp[i--] = c;
	}
}

copytmp(f)
char *f;
{	register int ffd, tfd, ct;
	char b[512];
	tmpfile++;

	pidfn();
	if((ffd = open(f, 0)) < 0)
		error("Cannot open: %s", f);
	if((tfd = creat(tmp, 0666)) < 0)
		error("Cannot creat /tmp file");
	while((ct = read(ffd, b, 512)) > 0)
		if(write(tfd, b, ct) < 0)
			error("Error in writing /tmp file");
	close(tfd);
	close(ffd);
	if(fopen(tmp, ipbuf) < 0)
		error("Cannot read /tmp file");
}

error(format, arg)
char *format, *arg;
{	flush();
	fout = 2;
	printf("fpsim:- ");
	printf(format, arg);
	printf("\n");
	flush();
	leave();
}
