#

/*
 * qstat - reports the status of queues, deletes queue entries
 * The various flags define the attributes of a queue entry,
 * and every entry, with all these attributes is listed/deleted.
 * The defaults are, list the default queue, and kill the request
 * currently being serviced in the default queue.
 */


#define	true	0177777
#define	false	0
#define	SUPERUSER	0
#define	SUPERGROUP	3
#define	OPERATORS	3
#include	"lpdaemon.h"
int		name_flag, uid_flag, gid_flag, title_flag, serial_flag;
int		cancel, long_listing, kill_current, pid;
int		low_serial, high_serial;
int		override;
int		semfd;
char		qletter, uid, gid;
char		filename[ FILENMLNG];
char		title[ TITLELNG];





main( argc, argv )
int	argc;
char	**argv;
	{
	register char	*arg, *p, c;
	int		i;

	uid = getuid();
	gid = getgid();
	semfd = semopen( QLOCK );
	qletter = '\0';

	argc--;    argv++;
	while ( argc-- > 0 )  {
		p = arg = *argv++;
		if ( *p != '-' )  {
			serial_flag = true;
			low_serial = atoi( p );
			while ( '0' <= *p  &&  *p <= '9' )
				p++;
			if ( *p == '-' )
				high_serial = atoi( ++p );
			else	high_serial = low_serial;
			if ( high_serial == 0 )
				high_serial = low_serial;
			continue;
			}
		c = *++p;
		if ( *++p != '\0'  &&  *p != '=' )
			c = '\0';

		switch ( c )  {

		case 'l':
			long_listing = true;
			break;
		case 'u':
			uid_flag = true;
			break;
		case 'g':
			gid_flag = true;
			break;
		case 'p':
			name_flag = true;
			strcopy( ++p, filename, TITLELNG );
			break;
		case 't':
			title_flag = true;
			strcopy( ++p, title, FILENMLNG );
			break;
		case 'o':
			if ( uid== SUPERUSER  ||  gid== SUPERGROUP
					||  gid== OPERATORS )
				override = true;
			else	printf("qstate: No permission for -o flag\n");
			break;
		case 'c':
			cancel = true;
			break;
		default:
			printf("qstate: Unknown flag:  %s\n", arg );
			exit(-1);
			}
		}

	if ( cancel )  {
		if ( !name_flag && !uid_flag && !gid_flag &&
			!title_flag && !serial_flag )
				kill_current = true;
		if ( qletter == 0 )
			qletter = DEFAULTQ;
		cancel_printing( qletter );
		}
	else	queue_stat( qletter );
	}




queue_stat( qid )
char	qid;
	{
	register char	*p;
	int		i;

	if ( qid )
		prqueue( qid );
	else	for ( p= knownqs;  *p;  p++ )
			prqueue( *p );
	return;
	}




prqueue( qid )
char	qid;
	{
	register int	qfd;
	register char	*p, *s;
	int		count;

	qname[ QNAMELNG] = qid;
	printf("  Q: %c", qid );
	if ( (qfd= open( qname, 0)) < 0 )  {
		printf(" is not known\n");
		return;
		}
	seek( qfd, 2, 0 );
	read( qfd, &pid, 2 );
	if ( pid != 0 )
		printf("  (daemon active)\n");
	else	printf("\n");

	count = 0;
	while ( read( qfd, &lpq, LPQLNG) == LPQLNG )  {
		if ( lpq.num_copies <=0  ||  !found_entry() )
			continue;
		if ( count++ == 0 )  {
			printf(" time  #cp title          ser#  user");
			if ( long_listing )
				printf("           filename       #blks tab skip");
			printf("\n");
			printf(" ----- --- -------------- ----- --------------");
			if ( long_listing )
				printf(" -------------- ----- --- ----");
			printf("\n");
			}
		if ( lpq.printing )
			printf("*");
		else	printf(" ");
		s =  ctime( lpq.date );
		printf("%5.5s " , s+11 );
		printf("%3d ", lpq.num_copies);
		printf("%-14.14s ", lpq.title);
		printf("%-5l ", lpq.serial );
		printf("%-14.14s" , lpq.from);
		if ( long_listing )  {
			for ( p= lpq.filename; *p; p++ );
			while ( *--p!= '/'  &&  p>= lpq.filename );
			printf(" %-14.14s", ++p );
			printf(" %-5d", lpq.fblocks & 0377 );
			printf(" %-3d", lpq.htabsize );
			printf(" %-3d", lpq.vtabsize );
			}
		printf("\n");
		}
	if ( count == 0 )
		printf("  No entries\n");
	close( qfd );
	}




cancel_printing( qid )
char	qid ;
	{
	register char	*s, *p ;
	register int	qfd ;
	int		i, count;

	qname[ QNAMELNG] = qid;
	if ( (qfd= open( qname, 2)) < 0)  {
		printf("qstate: Can't open queue: %s\n", qname );
		exit( -1);
		}
	count = 0;
	seek( qfd, 4, 0 );
	while ( true )  {
		lock( semfd );
		if ( read( qfd, &lpq, LPQLNG) < LPQLNG )  {
			unlock( semfd );
			break;
			}
		if ( lpq.num_copies <= 0  ||  !found_entry() )  {
			unlock( semfd );
			continue;
			}
		if ( lpq.uid!= uid  &&  !override )  {
			unlock( semfd );
			printf("qstate: Cannot cancel  %s\n", lpq.title );
			continue;
			}

		count++;
		lpq.num_copies = 0 ;
		seek( qfd, -LPQLNG, 1 );
		write( qfd, &lpq, LPQLNG );
		if ( lpq.printing )  {
			seek( qfd, 2,  0 );
			read( qfd, &pid, 2 );
			kill( pid, 15);
			}
		unlock( semfd );
		if ( lpq.lpdfile )
			unlink( lpq.filename );
		}
	close( qfd );
	if ( count == 0 )
		printf("No match\n");
	}




found_entry()
	{

	if ( kill_current )
		return( lpq.printing ?  true:  false );
	if ( name_flag  &&  !strcmp( filename, lpq.filename ) )
		return( false );
	if ( uid_flag  &&  uid != lpq.uid )
		return( false );
	if ( gid_flag  &&  gid != lpq.gid )
		return( false );
	if ( serial_flag  &&
		( lpq.serial < low_serial  ||  lpq.serial > high_serial) )
			return( false );
	if ( title_flag  &&  !strcmp( title, lpq.title ) )
		return( false );
	return( true );
	}




strcopy( from, to, length )
char	*from, *to;
int	length;
	{
	register char	*s1, *s2;
	s1 = from;    s2 = to;
	while ( (*s2++ = *s1++)  &&  (s1-from) < length );
	}




strcmp( str1, str2 )
char	*str1, *str2;
	{
	register char	*s1, *s2;

	s1 = str1;    s2 = str2;
	while ( *s1++ == *s2  &&  *s2++ != '\0' );
	return( *(s1-1)=='\0' && *(s2-1)=='\0' ?  true : false );
	}
