#
/*
 *	fastdown, E.S.Jones - fast version of shutdown and backdown
 *	Issues warning messages to all users, then kills all processes
 *	in order of priority (copied from Peter C.'s killunix).
 */


main( argc, argv )
int	argc;
char	**argv;
	{
	int	single, anywall, finished, pid, newpid;
	char	c, *unix;

	/* Check for super-user */
	if ( getuid() != 0)  {
		printf( "Must be super-user to run fastdown\n" );
		exit(-1);
		};

	argc--;    argv++;
	single = 0;
	unix = "/unix";
	if ( argc > 0 )
		if ( **argv == '-' )  {
			single = 1;
			argc--;    argv++;
			}
	if ( argc > 0 )  {
		unix = *argv;
		argc--;    argv++;
		}
	printf("System:  %s\n", unix );
	if ( argc > 0 )  {
		printf("Usage is:  /etc/fastdown (-s) (exec file)\n");
		exit();
		}

	/* Wait 15 seconds to shutdown */
	wall("FAST SHUTDOWN IN 15 SECONDS\n", &anywall );
	sleep(15);
	nointerrupts();
	wall( "Shutting down\n", &anywall );

	killprocs( unix);
	sync();

	/* Generate a new shell */
	if ( single )  {
		printf("\nSystem is now in single user mode\n\n");
		finished = 0;
		while ( finished == 0 )  {
			pid = getpid();
			newpid = fork();
			if ( pid != getpid())
				execl( "/bin/sh", "-", 0 );
			while ( wait() != newpid );
			printf("Logout (y) ? ");
			if ( (c=getchar()) == 'y' )
				finished = 1;
			while ( c != '\n' )
				c = getchar();
			}
		killprocs( unix );
		}
	sync();
	sleep(2);
	printf("\nHALT THE PROCESSOR\n\n");
	}
