#

#define	BLOCKS		48

int	file_1, file_2, cyl, tot_errs, errs, offset;
int	nblks, wds;
char	*size, *dsize, *p;
int	data_1[BLOCKS*256+1], data_2[BLOCKS*256+1];

main( argc,argv )
int	argc;
char	**argv;
	{
	register int	*point_1, *point_2, *limit;

	argv++;    argc--;
	if ( argc != 3 )  {
		printf("Usage is:  rkcmp {device 1} {device 2} {disk size blocks decimal}\n");
		exit(-1);
		}

	if ( (file_1= open( *argv, 0)) < 0 )  {
		printf("Can't read:  %s\n", *argv );
		exit();
		}
	if ( (file_2= open( *++argv, 0)) < 0 )  {
		printf("Can't read:  %s\n", *argv );
		exit();
		}
	size = 0;
	for ( p= *++argv;  *p;  p++ )
		if ( '0' <= *p  &&  *p <= '9' )
			size = 10*size + *p - '0';
		else	{
			printf("Non numeral in disk size\n");
			exit();
			}
	dsize = size;
	tot_errs = 0;
	offset = 256;

	while ( size )  {
		nblks =  size > BLOCKS ? BLOCKS: size;
		size  =- nblks;
		wds = nblks*256;
		data_1[wds] =  1;
		data_2[wds] = -1;
		limit = &data_1[wds];
		errs = 0;
		if ( read( file_1, data_1, wds*2)  < 0  ||
				read( file_2, data_2, wds*2)  <0 )  {
			printf("Read error block:  %d\n", dsize-size-nblks);
			continue;
			}
		point_1 = data_1 + offset;
		point_2 = data_2 + offset;
		while ( point_1 < limit )  {
			while ( *point_1++ == *point_2++ );
			if ( point_1 <= limit )
				errs++;
			}
		if ( tot_errs == 0  &&  errs > 0 )
			printf(" Blk\tErrors\n");
		if ( errs > 0 )
			printf(" %3d\t %4d\n", dsize-size-nblks, errs);
		tot_errs =+ errs;
		offset = 0;
		}
	if ( tot_errs > 0 )
		printf("Total\t %4d\n", tot_errs);
	else
		printf("Disk cmp OK\n");
	}
