#define	PRBUSY	13	/* exit status from child if can't open printer */
#define	PR_TTY	01
#define	PR_LA	02
#define	USETABS	04
#define	NEEDCR	010
#define	BANNER	020
#define	BIGBAN	040
#define	ACCT	0100
#define	SIMFORM	0200
#define	WINDUP	0400
#define	ONEDONE	0x4000		/* internal flag: printer has been initialized */

#define	BANSIZ	200
#define	BIGBSIZ	800

#define	BIGNUM	0x7fffffffL	/* A rather large number */

/* Signal Definitions :- */
#define	CSIG	6	/* Communication signal (from 'opctl') */
#define	NEW	7	/* Indicates new entry in directory	*/
#define	MERGE	8	/* Request to reread /etc/printers data file */
#define	FAIL	6
#define	SUCCEED	7	/* signals returned to 'opctl' */

/* Easier ways to move data (for the typist) */
#define	STRCPN(a, b)	strncpy(a, b, sizeof(a))
#define	STRCPM(a,b)	strncpy(a, b, sizeof(a)-1)
struct pr {
	char	comm;		/* printer command (on or off (+, -)) */
	char	reqlen;		/* number chars of class that must match */
	char	speed;		/* printer baud rate code (for async lines) */
	short	opts;		/* printer options (banner, ...) */
	char	class[CLSIZE];	/* the class type of this printer */
	char	prnm[DIRSIZ+1];		/* actual special file name in /dev */
	char	prinit[3*DIRSIZ+4];	/* printer initialization file */
	char	locn[40];	/* where the printer actually lives */

	int	ppid;		/* process # of job on this printer */
	int	pjob;		/* job number on this printer */
	int	pbias;		/* bias for non std jobs on this printer */
};

extern	struct pr *lastpr;

#define	PR	register struct pr *
#define	printers pr = prt; pr < lastpr; pr++
#define	ever	;;

struct job {
	int	jnum;			/* spool job number */
	char	jclass[CLSIZE-1];	/* class of job currently on printer */
	char	pname[DIRSIZ];		/* name of printer */
};

struct lpdcmd {
	int	xjob;		/* pid of opctl */
	int	cjob;		/* spool job # */
	int	xfn;		/* function to apply */
	char	xname[DIRSIZ];	/* printer dev name (kick only) */
};

#ifdef	LPR
struct act {			/* paper accounting */
	short	a_uid;
	short	a_gid;
	short	a_flags;
	int	a_pjob;
	int	a_pages;
	char	a_pname[DIRSIZ];
};
#define	A_ABT	01
#define	A_REQ	02
#define	A_REP	04
#define	A_KILL	010
#define	A_STOP	020
#endif

#define	LPD_ABT		'a'
#define	LPD_REP		'r'
#define	LPD_REQ		'q'
#define	LPD_PAUS	'p'
#define	LPD_CONT	'c'
#define	LPD_KILL	'z'
#define	LPD_STOP	's'
#define	LPD_KICK	'k'
