/*
 *	Routines to handle the /etc/printers file
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <setjmp.h>
#include "local.h"
#include "spool.h"
#include "globals.h"

FILE *ifd;		/* fd for /etc/printers */
struct pr line;
#define	FLD(a, b, c)	b=field(a, sizeof(a)-1, b, c)

rline()
{
	register c, i;

	if ((c = get()) <= 0)
		return(0);
	if (c != '+')
		c = '-';
	line.comm = c;

	if ((c = get()) <= 0)
		return(0);
	if (c < '0' || c > '9')
		c = '9';
	line.reqlen = c - '0';
	if ((c = get()) <= 0)
		return(0);
	if (c < 'A' || c > 'O')
		c = '@';
	line.speed = c - '@';
	i = 0;
	while ((c = get()) > 0 && c != ' ' && c != '\t' && c != ',') switch(c) {
		case 'b':	i |= BANNER;		break;
		case 'B':	i |= BIGBAN;		break;
		case 't':	i |= PR_TTY;		break;
		case 'l':	i |= PR_LA;		break;
		case 'p':	i |= 0;			break;		/* reserved to indicate real line printer */
		case 'a':	i |= ACCT;		break;
		case 'n':	i |= NEEDCR;		break;
		case 'T':	i |= USETABS;		break;
		case 'F':	i |= SIMFORM;		break;
		case 'w':	i |= WINDUP;		break;
	}

	if (c <= 0)
		return(0);

	line.opts = i;

	if ((c = skip(c)) <= 0)
		return(0);

	FLD(line.class, c, 0);
	if ((c = skip(c)) <= 0)
		return(0);
	if (strlen(line.class) > line.reqlen)
		line.pbias = strlen(line.class) - line.reqlen;
	else
		line.pbias = 0;
	FLD(line.prnm, c, 0);
	c = skip(c);
	FLD(line.prinit, c, 0);
	c = skip(c);
	FLD(line.locn, c, 1);
	return(1);
}

skip(c)
register c;
{
	while (c > 0 && (c == ' ' || c == '\t'))
		c = get();
	if (c != ',')
		return(c);
	do
		c = get();
	while (c > 0 && (c == ' ' || c == '\t'));
	return(c);
}

field(p, len, c, flag)
register char *p;
register len, c, flag;
{
	while (c > 0 && (flag || c != ' ' && c != '\t' && c != ',')) {
		if (len > 0)
			*p++ = c, len--;
		c = get();
	}
	*p = '\0';
	return(c);
}

get()
{
	register c;

	c = getc(ifd);

	if (c == EOF)
		c = -1;
	if (c == '\n')
		c = 0;
	return(c);
}

merge()
{
	PR pr;

	if ((ifd = fopen(ifile, "r")) == NULL)
		return;

	while (rline()) {
		for (printers)
			if (strcmp(pr->prnm, line.prnm) == 0 &&
					strcmp(pr->class, line.class) == 0)
				break;
		if (pr >= &prt[TABSIZE])
			continue;
		strcpy(pr->prnm, line.prnm);
		strcpy(pr->class, line.class);
		strcpy(pr->prinit, line.prinit);
		strcpy(pr->locn, line.locn);
		pr->opts = line.opts;
		pr->comm = line.comm;
		pr->reqlen = line.reqlen;
		pr->pbias = line.pbias;
		pr->speed = line.speed;
		if (pr >= lastpr)
			lastpr++;
	}
	fclose(ifd);
	maxchild = 0;
	for (printers)
		if (pr->comm != '-' || pr->ppid != 0)
			maxchild++;
}
