/*
 *	OPQ:
 *		lists the lpd queue
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include "local.h"
#include "spool.h"

#define	MAXARGS		200		/* anything too big to contemplate */

struct qjob {
	char	j_fnm[DIRSIZ+1];
	short	j_uid;
	int	j_num;
	long	j_pri;
	struct	qjob *j_nxt;
	struct	qjob *q_nxt;
};
#define	NIL ((struct qjob *) 0)

struct	qjob	*jobhead = NIL;
struct	qjob	*qhead = NIL;

struct	direct	spoold;
struct	pr	prt[TABSIZE];
struct	pr	*lastpr = prt;


int	aflag;
int	lflag;
int	sflag;
int	oflag;
int	eflag;
int	devflg;

char	device[CLSIZE];

char	lpd[] = SPOOLDIR;
char	jobf[] = JOBFILE;
char	ifile[] = IFILE;

int	jcnt;
int	arg[MAXARGS];

FILE	*dfd;
FILE	*cmd;

int	tolist;
int	prcount;
int	maxchild;		/* we don't want this, but it keeps 'merge' happy */

char	nbuf[DIRSIZ+1];
struct	stat	statb;

/***
  GLOBAL VARS GO HERE
 ***/

char	*rindex();
char	*calloc();
struct pr *active();

main(argc, argv)
char **argv;
{
	PR pr;
	register struct qjob *jp;
	register char *p, c;
	PR apr;

	while (--argc > 0)
		if ( *(p = *++argv) == '-' ) while (c = *++p) switch (c) {

		case 'l':	lflag++;	break;
		case 'a':	aflag++;	break;
		case 's':	sflag++;	break;
		case 'o':	oflag++;	break;
		case 'e':	eflag++;	break;

		case 'd':	if (p[1] != '\0')
					p++;
				else if (argc > 1 && argv[1][0] != '-')
					argc--, p = *++argv;
				else
					p++;
				if (!devflg) {
					STRCPM(device, p);
					devflg++;
				}
				if (*p == '\0')
					p--;
				while (p[1] != '\0')
					p++;
				break;

		default:	usage();

		} else break;

	jcnt = 0;
	while (argc-- > 0) {
		if (!isdigit(*p))
			usage();
		arg[jcnt++] = atoi(p);
		p = *++argv;
	}

	merge();
	getactive();

	if ((dfd = fopen(lpd, "r")) == NULL) {
		fprintf(stderr, "Opq: can't open spool directory\n");
		exit(1);
	}
	if (chdir(lpd) < 0) {
		fprintf(stderr, "Opq: spool directory chdir foulup\n");
		exit(1);
	}

	if (devflg) for (printers)
		if ((oflag || pr->comm != '-') && thispr(pr))
			prcount++;

	if (devflg && prcount == 0) {
		fprintf(stderr, "No '%s' printers available\n", device);
		exit(1);
	}

	while (fread(&spoold, sizeof spoold, 1, dfd) == 1)
		if (!breakup())
			savejob();

	if (jobhead == NIL && !eflag)		/* no queued jobs at all */
		exit(0);

	for (printers) {
		if (!oflag && pr->comm == '-')
			continue;
		if (devflg && !thispr(pr))
			continue;
		zeroq();
		for (jp = jobhead; jp != NIL; jp = jp->j_nxt) {
			if (!devok(jp, pr) || (apr = active(jp->j_num))
						&& apr != pr		)
				continue;
			enter(jp);
		}

		if (eflag) {
			if (qhead == NIL) {
				if (lflag)
					printf
					(	"%6s: (/dev/%s) %s\n"
						,pr->class
						,pr->prnm
						,pr->locn
					);
				else
					printf("%s\n", pr->class);
			}
			continue;
		}

		tolist = 0;
		for (jp = qhead; jp; jp=jp->q_nxt)
			if ((jcnt == 0 || argjob(jp)) && (aflag || owner(jp)))
				tolist++;
		if (tolist == 0)
			continue;

		if (prcount != 1)
			if (lflag)
				printf
				(	"%s (/dev/%s)%s %s\n"
					,pr->class
					,pr->prnm
					,pr->comm == '-' ? " OFF" : ""
					,pr->locn
				);
			else
				printf
				(	"%s:%s\n"
					,pr->class
					,pr->comm == '-' ? " OFF" : ""
				);

		for (jp = qhead; jp != NIL; jp = jp->q_nxt)
			if ((jcnt == 0 || argjob(jp)) && (aflag || owner(jp)))
				putitem(jp, pr);
	}
}

usage()
{
	fprintf(stderr, "Usage: opq [-lasoe] [-dDEV] [JOB] ...\n");
	exit(1);
}

savejob()
{
	register struct qjob *jp;

	STRCPM(nbuf, spoold.d_name);
	if (stat(nbuf, &statb) < 0)
		return;

	if ((jp = (struct qjob *)calloc(sizeof(struct qjob), 1)) == NIL) {
		fprintf(stderr, "Opq: out of memory\n");
		exit(1);
	}

	STRCPM(jp->j_fnm, spoold.d_name);
	jp->j_uid = statb.st_uid;
	jp->j_num = atoi(rindex(nbuf, '.') + 3);
	jp->j_nxt = jobhead;
	jobhead = jp;

	/****
	 ****	GET SIZE OF FILES TO BE PRINTED
	 ****	& LAST MOD TIME OF 'df' FILE - EVAL PRI
	 ****/
/** for now: **/	jp->j_pri = statb.st_mtime;
}

devok(jp, pr)
register struct qjob *jp;
PR pr;
{
	register char *p;
	char dev[CLSIZE];
	for (p = dev; p < &dev[CLSIZE]; *p++ = '\0')
		;

	p = rindex(jp->j_fnm, '.');

	strncpy(dev, &jp->j_fnm[2], p - &jp->j_fnm[2]);

	return(checkpr(pr, dev));
}

argjob(jp)
register struct qjob *jp;
{
	register j = jp->j_num;
	register i;

	for (i = 0; i < jcnt; i++)
		if (arg[i] == j)
			return(1);

	return(0);
}

owner(jp)
struct qjob *jp;
{
	return(getuid() == jp->j_uid);
}

zeroq()
{
	qhead = NIL;
}

enter(jp)
register struct qjob *jp;
{
	register struct qjob *q;
	register struct qjob **l;

	l = &qhead;
	for (q = qhead; q != NIL; l = &q->q_nxt, q = q->q_nxt)
		if (jp->j_pri < q->j_pri) {
			jp->q_nxt = *l;
			*l = jp;
			return;
		}

	jp->q_nxt = NIL;
	*l = jp;
}

putitem(jp, pr)
register struct qjob *jp;
PR pr;
{
	int fd;
	char c;
	int flag;
	int	copies;
	char	realfname[100];
	char	person[12];
	char	lbuf[1024];
	int	job;
	char	submitted[28];

 
	STRCPM(nbuf, jp->j_fnm);
	if( (cmd=fopen(nbuf, "r")) == NULL ){
		/*  woops .. cannot access spool commands file  */
	/**
		printf("Cannot open %s\n", nbuf);
	**		- a very quiet error - job just finished **/
		return;
	}
 
	flag = 1;
	copies = 1;
	submitted[0] = '\0';
	realfname[0] = '\0';
	person[0] = '\0';
	/*  loop round here extracting  commands  */
	for (;;) {
		switch (c = getc(cmd)) {
 
		/*  print a file  */
		case 'F':
			getline(lbuf);
			if (stat(lbuf, &statb) < 0) continue;
			if (flag) {
				flag = 0;
				job = jp->j_num;
				printf("%6d", job);
				if (active(job) == pr)
					putchar('*');
				else
					putchar(' ');
				if (lflag) {
					printf(" %s", person);
					submitted[16] = '\0';
					printf("\t%s", &submitted[4]);
				}
			}
			else if (lflag || sflag) {
				printf("\n       ");	/*  job number  */
				if (lflag) printf("   \t            ");		/*  user and date/time  */
			}
			if (lflag) {
/***			now done above ...
				if (stat(lbuf, &statb) < 0) statb.st_size = 0;
***/
				printf(" %9d", statb.st_size);
				printf(" %2d", copies);
			}
			if (sflag) printf("  (%s)", lbuf+strlen(lpd)+1);
			if (lflag) printf(" %s", realfname);
			if (lflag || sflag) continue;
			putchar('\n');
			fclose(cmd);
			return;
 
		/*  login person id  */
		case 'L':
			getline(person);
			continue;
 
		/*  number of copies  */
		case 'N':
			getline(lbuf);
			copies = atoi(lbuf);
			continue;
 
		/*  real file name  */
		case 'R':
			getline(realfname);
			continue;
 
		/*  time submitted  */
		case 'S':
			getline(submitted);
			continue;
 
		/*  end of command file  */
		case EOF:
			if (!flag)
				putchar('\n');
			fclose(cmd);
			return;
 
		/*  ignore all other commands  */
		default:
			getline(lbuf);
			continue;
		}
	}
 
}

breakup()
{
	if (spoold.d_ino == 0)
		return(1);

	if (spoold.d_name[0] != 'd' || spoold.d_name[1] != 'f')
		return(1);

	return(0);
}

getline(buf)
char buf[];
{
	register char *p;
	register c;

	for (p = buf; (*p = c = getc(cmd)) != '\n' && c > 0; p++)
		;
	*p = '\0';
}
