/*
 *	Priority calculation for LPD
 *
 *		mtime:	time the file was last modified
 *		size :	estimated total print size
 *		bias :	some extra info calculated by out caller
 *
 *	returns priority ( smaller number --> higher priority )
 */

#include <sys/types.h>

calcpri(mtime, size, bias)
register time_t mtime;
register long	size;
int		bias;
{
	time_t now;

	time (&now);
	size >>= 10;
	now -= mtime;
	size -= now >> 6;
	size += bias;
	return(size);
}
