/*
 * getty -- adapt to terminal speed on dialup, and call login
 */

#include <sgtty.h>
#include <signal.h>
#include <ident.h>
#define ERASE	'\b'
#define KILL	'@'

#define DC1	0x11
#define DC2	0x12
#define DC3	0x13
#define DC4	0x14

struct sgttyb tmode;

struct tchars tc ={
	0177, ctl('\\'), ctl('q'), ctl('s'), ctl('d'), 0200
};

struct sgttychr chr ={
	ctl('a'), 033, ctl('o'), ctl('r'), ctl('x'), 0
};

struct sgttydel nodel ={
	0, 0, 0, 0, 0, 0
};

struct sgttydel tabdel ={
	0, 0, XTABS, 0, 0, 0
};
struct sgttydel intdel ={
	5, 0, 0, 5, 0, 0
};
struct sgttydel tekdel ={
	0, 0, XTABS, 80, 0, 0
};
struct sgttydel clrdel ={
	0, 0, XTABS, 5, 0, 0
};

struct sgttyst state;

struct	tab {
	char	tname;		/* this table name */
	char	nname;		/* successor table name */
	int	oflags;		/* output flags */
	int	iflags;		/* initial flags */
	int	fflags;		/* final flags */
	int	ispeed;		/* input speed */
	int	ospeed;		/* output speed */
	char	*imsg;		/* initialization message */
	char	*message;	/* login message */
	struct sgttydel *mdel;	/* delay algorithms for message */
	struct sgttydel *tdel;	/* delay algorithms to use */
	int	ttype;		/* terminal type */
	char	depth;		/* # lines */
	char	width;		/* # columns */
} itab[] = {

/* Table '0' - 1 - 2 - 3,  9600 300 1200 2400 - Gandalf service 55 */

	'0', 1,
	ANYP+CRMOD, ANYP+RAW, ANYP+ECHO+KNL+RO_VDU,
	B9600, B9600,
	"\033d\030\f",
	"\n\rlogin: ",
	&clrdel, &tabdel,
	UNKNOWN, 0, 0,

	1, 2,
	ANYP+CRMOD, ANYP+RAW, ANYP+ECHO+KNL+RO_HARD,
	B300, B300,
	"\n\n\r",
	"\n\r\nlogin: ",
	&tabdel, &tabdel,
	UNKNOWN, 0, 0,

	2, 3,
	ANYP+CRMOD, ANYP+RAW, ANYP+ECHO+KNL+RO_VDU,
	B1200, B1200,
	"\033d\030\f",
	"\n\rlogin: ",
	&clrdel, &tabdel,
	UNKNOWN, 0, 0,

	3, '0',
	ANYP+CRMOD, ANYP+RAW, ANYP+ECHO+KNL+RO_VDU,
	B2400, B2400,
	"\033d\030\f",
	"\n\rlogin: ",
	&clrdel, &tabdel,
	UNKNOWN, 0, 0,

/* Table '2'-'3', 1200 300 : Gandalf Service 05 */

	'2', '3',
	ANYP+CRMOD, ANYP+RAW, ANYP+ECHO+KNL+RO_VDU,
	B1200, B1200,
	"\033d\030\f",
	"\n\rlogin: ",
	&clrdel, &tabdel,
	UNKNOWN, 0, 0,

	'3', '2',
	ANYP+CRMOD, ANYP+RAW, ANYP+ECHO+KNL+RO_HARD,
	B300, B300,
	"\n\r\n",
	"\n\r\nlogin: ",
	&tabdel, &tabdel,
	UNKNOWN, 0, 0,

/* Intecolor 8001 - TABLE 'I' */
	'I', 'I',
	ANYP+CRMOD+LCASE+UCASE+DCASE, ANYP+RAW+LCASE+UCASE+DCASE, ANYP+ECHO+KNL+LCASE+UCASE+DCASE+RO_VDU,
	B9600, B9600,
	"\377\033f\033k\036\020\035\022\017\014",
	"\r\n\nlogin: ",
	&intdel, &intdel,
	INT8001, 48, 80,

/* Intecolor 8001 (new version) - Table 'i' */
	'i', 'i',
	ANYP+CRMOD, ANYP+RAW, ANYP+ECHO+KNL+RO_VDU,
	B9600, B9600,
	"\377\033f\033k\036\020\035\022\017\014",
	"\r\n\nlogin: ",
	&intdel, &intdel,
	INT8001, 48, 80,

/* tektronix 4012 - table 't' */
	't', 't',
	ANYP+CRMOD, ANYP+RAW, ANYP+ECHO+KNL+RO_VDU,
	B9600, B9600,
	"\033\014\n\n\n\n\n\n\n\n\n\n\n\n\n\n",
	"\r\n\nlogin: ",
	&tekdel, &tekdel,
	TEK4012, 35, 72,

/* Table '4' - 300 - Console */

	'4', '4',
	ANYP+CRMOD, ANYP+CBREAK+CRMOD, ANYP+ECHO+KNL+CRMOD,
	B300, B300,
	"\r\n\n",
	"\nlogin:\n",
	&tabdel, &tabdel,
	LA36, 66, 132,

};

#define	NITAB	sizeof itab/sizeof itab[0]
#define	EOT	04		/* EOT char */

char	name[16];
int	crmod;
int	upper;
int	lower;
int	digit;

char partab[] = {
	0001,0201,0201,0001,0201,0001,0001,0201,
	0202,0004,0003,0205,0005,0206,0201,0001,
	0201,0001,0001,0201,0001,0201,0201,0001,
	0001,0201,0201,0001,0201,0001,0001,0201,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0201
};

main(argc, argv)
char **argv;
{
	register struct tab *tabp;
	char tname;

/*
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_DFL);
*/
	tname = '0';
	if (argc > 1)
		tname = argv[1][0];
	for (;;) {
		for(tabp = itab; tabp < &itab[NITAB]; tabp++)
			if(tabp->tname == tname)
				break;
		if(tabp >= &itab[NITAB])
			tabp = itab;
		ioctl(0, TIOCFLUSH, 0);		/* clear out the crap */
		tmode.sg_ispeed = tabp->ispeed;
		tmode.sg_ospeed = tabp->ospeed;
		tmode.sg_flags = tabp->oflags;
		ioctl(0, TIOCSETP, &tmode);
/*
		ioctl(0, TIOCGETS, &state);
*/
		ioctl(0, TIOCSETC, &tc);
		ioctl(0, TIOCSCHR, &chr);
		ioctl(0, TIOCSDEL, tabp->mdel);
		state.sg_ttype = tabp->ttype;
		state.sg_depth = tabp->depth;
		state.sg_width = tabp->width;
		ioctl(0, TIOCSETS, &state);
		ioctl(0, TIOCHPCL, 0);
		puts(tabp->imsg);
		puts(myname);
		puts("\n\r");
		puts(tabp->message);
		tmode.sg_flags = tabp->iflags;
		ioctl(0, TIOCSETP, &tmode);
		if(getname()) {
			if (!(upper||lower||digit))
				continue;
			tmode.sg_erase = ERASE;
			tmode.sg_kill = KILL;
			tmode.sg_flags = tabp->fflags;
			if(crmod)
				tmode.sg_flags |= CRMOD;
			if(upper)
				tmode.sg_flags |= LCASE;
			if(lower)
				tmode.sg_flags &= ~LCASE;
			ioctl(0, TIOCSETP, &tmode);
			chr.sg_brkin = 0177;
			ioctl(0, TIOCSCHR, &chr);
			ioctl(0, TIOCSDEL, tabp->tdel);
			putchr('\n');
			execl("/bin/login", "login", name, 0);
			exit(1);
		}
		tname = tabp->nname;
	}
}

getname()
{
	register char *np;
	register c;
	char cs;

	crmod = 0;
	upper = 0;
	lower = 0;
	digit = 0;
	np = name;
	for (;;) {
		if (read(0, &cs, 1) <= 0)
			exit(0);
		if ((c = cs&0177) == 0)
			return(0);
		if (c==EOT)
			exit(1);
		if (c=='\r' || c=='\n' || np >= &name[16])
			break;

#ifdef MELB_TTY
		/* This is just for the 7/16 serial loader */
		switch(c) {

		case DC1: case DC2: 
		case DC3: case DC4: 
			continue;

		default:
			putchr(cs);
			break;
		}
#else
		putchr(cs);
#endif
		if (c>='a' && c <='z')
			lower++;
		else if (c>='A' && c<='Z') {
			upper++;
			c += 'a'-'A';
		} else if (c==ERASE) {
			if (np > name)
				np--;
			continue;
		} else if (c==KILL) {
			putchr('\r');
			putchr('\n');
			np = name;
			continue;
		} else if(c == ' ')
			c = '_';
		else if (c >= '0' && c <= '9')
			digit++;
		*np++ = c;
	}
	*np = 0;
	if (c == '\r')
		crmod++;
	return(1);
}

puts(as)
char *as;
{
	register char *s;

	s = as;
	while (*s)
		putchr(*s++);
}

putchr(cc)
{
	char c;
	c = cc;
	c |= partab[c&0177] & 0200;
	write(1, &c, 1);
}
