/*
 *   this is a version of 'tp' modified by Ian Johnstone (AGSM)
 *   in PDP-11 assembler,
 *
 *   translated to C : Robert Elz, Melb Uni, Oct 78.
 *
 */
#include <sys/types.h>
#include <stdio.h>
#include <sys/stat.h>

#define TAPESIZE 2400	/* default tape length (feet) */
#define TBLOKSIZ 16384	/* blocksize on tape - selected for
			   various PDP-11 hardware reasons */
#define TBLOKING (TBLOKSIZ/512)	/* disc blocks per tape block */
#define	NRZRECLEN ((TBLOKSIZ+534+799)/800)	/* 800 bpi record length (inches) */


#define	IFMT	060000
#define IFILE	000000
#define IFDIR	040000
#define IFBLK	020000
#define IFCHR	060000

#define EEXIST	17

#define SETUID	04000
#define SETGID	02000
#define STICKY	01000
#define RPERM	04
#define WPERM	02
#define XPERM	01

/* tape directory access macros
 *
 *   -   provide m/c independance  (wrt PDP-11 backwards integers)
 *       (and wrt Interdata alignment problems)
 *
 *
 *	I apologise for the absurd complexity of these, but with
 *	any luck at all, they should work OK as is. The only problem
 *	is that they assume the ability to do things to register long's
 *	and that characters are assumed to be unsigned. This is no problem
 *	on the Interdata, & on the VAX the problem can be overcome by the
 *	use of the type 'unsigned char' - but on a PDP-11 ??
 *
 *	On the PDP-11 if you really need to, these can be replaced
 *	by much simpler access mechanisms, but please leave this code
 *	here for us.
 *
 */
typedef		unsigned char	chr;

#define CMODE 114
#define CUID  116
#define CGID 117
#define CSIZE 118
#define CTIME 122
#define CTAPEA 126

#define DIRSIZE 128
#define DIRUPLIM (TBLOKSIZ-15*DIRSIZE)

#define cpathname ((char *)&dbuf[0])

#define gcmode ((dbuf[CMODE+1]<<8)|dbuf[CMODE])
#define gcuid dbuf[CUID]
#define gcgid dbuf[CGID]
#define gcsize ((((((dbuf[CSIZE+1]<<8)|dbuf[CSIZE])<<8)|dbuf[CSIZE+3])<<8)|dbuf[CSIZE+2])
#define gcmaj dbuf[CSIZE+3]
#define gcmin dbuf[CSIZE+2]
#define gctime ((((((dbuf[CTIME+1]<<8)|dbuf[CTIME])<<8)|dbuf[CTIME+3])<<8)|dbuf[CTIME+2])
#define gctapea ((dbuf[CTAPEA+1]<<8)|dbuf[CTAPEA])

#define scmode(c) {register ii=c;dbuf[CMODE+1]=ii>>8;dbuf[CMODE]=ii;}
#define scuid(u) {dbuf[CUID]=u;}
#define scgid(g) {dbuf[CGID]=g;}
#define scsize(s) {register long ii=s;dbuf[CSIZE+2]=ii;ii>>=8;dbuf[CSIZE+3]=ii;\
			ii>>=8;dbuf[CSIZE]=ii;ii>>=8;dbuf[CSIZE+1]=ii;}
#define scmajmin(mm) {register ii=mm;dbuf[CSIZE]=dbuf[CSIZE+1]=0;\
			dbuf[CSIZE+2]=ii;dbuf[CSIZE+3]=ii>>8;}
#define sctime(t) {register long ii=t;dbuf[CTIME+2]=ii;ii>>=8;dbuf[CTIME+3]=ii;\
			ii>>=8;dbuf[CTIME]=ii;ii>>=8;dbuf[CTIME+1]=ii;}
#define sctapea(a) {register ii=a;dbuf[CTAPEA]=ii;dbuf[CTAPEA+1]=ii>>8;}

#define NFILES	0
#define DTIME	2
#define DBLK	6

#define ghnfiles ((tapeb[NFILES+1]<<8)|tapeb[NFILES])
#define ghdtime  ((((((tapeb[DTIME+1]<<8)|tapeb[DTIME])<<8)| \
			tapeb[DTIME+3])<<8)|tapeb[DTIME+2])
#define ghdblks ((tapeb[DBLK+1]<<8)|tapeb[DBLK])

#define shnfiles(n) {register ii=n;tapeb[NFILES+1]=ii>>8; \
			tapeb[NFILES]=ii;}
#define shdtime(t) {register long ii=t;tapeb[DTIME+2]=ii;ii>>=8; \
			tapeb[DTIME+3]=ii;ii>>=8;tapeb[DTIME]=ii;\
			ii>>=8;tapeb[DTIME+1]=ii;}
#define shdblks(d) {register ii=d;tapeb[DBLK+1]=ii>>8; \
			tapeb[DBLK]=ii;}

char ldt[] = "/etc/last-dump-time";
char *mt = "/dev/rmt0";
char *tmpdirname = "/tmp/dtp_temp";

chr tapeb[TBLOKSIZ];
chr dbuf[DIRSIZE];
chr namewk[CMODE];	/* assumes CMODE is first after path name */

int sflag, cflag, uflag, vflag, qflag, iflag, dflag;

		/* CAUTION: Version 6 format times */
time_t dumptime, seltime;
int narg, rnarg;
char *p, **parg;
int (*command)();
int nfiles, nused;
int ndirblks;
int tlen;
int tpsize = TAPESIZE;
int fio, dirfd;
int dirlast = -1;
int tapad;
int *ebufpt = (int *)((char *)tapeb + DIRSIZE);
char xxbuf[BUFSIZ];

struct stat statb;

intr()
{
	unlink(tmpdirname);
	exit(0);
}

main(argc,argv)
char **argv;
{
	register char *p, c, cc;
	register i;
	int cmexit(), cmn(), cml(), cmx();
#define isdigit(c) ((cc=(c))>='0' && cc<='9')

	if(signal(2,1)==0)
		signal(2,intr);
	setbuf(stdout, xxbuf);
	time(&dumptime);
	rnarg = narg = argc;
	command = cmexit;
	argv++;

	if(argc<2)
		useerr();

	p = *argv++;
	parg = argv;

	while(c = *p++)

		switch(c) {

			case '-' : break;
			case '1' :
			case '0' : mt[8] = c; break;
			case 'f' : if(i = atoi(p)) {
					tpsize = i;
					while(isdigit(*++p));
				   } break;
			case 't' : if((rnarg = --narg) < 1 )
					useerr();
				   tmpdirname = *parg++;
				   break;
			case 'o' : if((rnarg = --narg) < 1)
					useerr();
				   mt = *parg++;
				   break;
			case 'x' : setcom(cmx); break;
			case 'n' : setcom(cmn); break;
			case 'l' : setcom(cml); break;
			case 's' : sflag++;
				   if(i = atoi(p)) {
					while(isdigit(*++p));
					seltime = dumptime - 3600*i;
				   } else {
					if((i = open(ldt, 0)) < 0  ||
						read(i, &seltime, sizeof seltime) != sizeof seltime) {
						printf("Dtp: can't read %s\n", ldt);
						done();
					}
					close(i);
				   }
				   break;
			case 'c' : cflag++; break;
			case 'u' : uflag++; break;
			case 'v' : vflag++; break;
			case 'q' : qflag++; break;
			case 'i' : iflag++; break;
			case '.' : dflag++; break;
			default  : useerr();
		}

	optape();

	if((dirfd = creat(tmpdirname, 0600)) < 0 ||
			close(dirfd), (dirfd=open(tmpdirname,2))<0 ) {
		printf("Dtp: can't create %s\n", tmpdirname);
		done();
	}

	(*command)();

	exit(0);

#undef isdigit
}

setcom(cmd)
int (*cmd)();
{
	int cmexit();

	if(command == cmexit)
		command = cmd;
	else
		useerr();
}

optape()
{
	register m;
	int cmn();

	m = command == cmn ? 1 : 0;

	if((fio = open(mt, m)) < 0) {
		printf("Dtp: can't open %s\n", mt);
		done();
	}
}

useerr()
{
	printf("Usage: dtp {lnx} [ name ] ...\n");

	done();
}

cmexit()
{
	printf("Dtp: no function specified\n");

	done();
}

cmn()
{
	register i, tlen;

	if(cflag) useerr();

	getfiles();

	tlen = (nfiles * DIRSIZE + TBLOKSIZ-1) / TBLOKSIZ;
	tlen += (tapad + TBLOKING-1) / TBLOKING;
	tlen *= (NRZRECLEN + 11) / 12;

	if(tlen > tpsize) {
		printf("tape too small for files\n%d' tape required\n", tlen);
		done();
	}
	fflush(stdout);

	make();

	if(uflag) {
		if((i = creat(ldt, 0600)) < 0   ||
			write(i, &dumptime, sizeof dumptime) != sizeof dumptime) {

			printf("Dtp: can't update %s\n", ldt);

			done();
		}
	}
	usage();
}

cml()
{
	int taboc();

	if(cflag || qflag) useerr();

	rddir();

	printf("\n\nThis dump initiated on %s", ctime(&dumptime));

	if(vflag)
		printf("\n   mode     uid gid   tapa       size   date   time  name\n\n");

	gettape(taboc);

	usage2();
}

cmx()
{
	int xtract();

/****				I don't agree with this restriction
	if(cflag && qflag) useerr();
****/

	rddir();
	tread();
	gettape(xtract);
	done();
}

usage()
{
	printf("%d tape blocks\n", nused);
	usage2();
}

usage2()
{
	printf("%d files on tape\n", nfiles);
	done();
}

done()
{
	printf("END\n");
	fflush(stdout);
	unlink(tmpdirname);
	exit(0);
}

rddir()
{
	register i;

	lseek(dirfd, 0L, 0);
	tread();
	dwrite();

	ndirblks = ghdblks;
	nfiles = ghnfiles;
	dumptime = ghdtime;
	for(i=1; i < ndirblks; i++) {
		tread();
		dwrite();
	}
}

wrdir()
{
	lseek(dirfd, 0L, 0);
	dread();

	shnfiles(nfiles);
	shdtime(dumptime);
	fstat(dirfd, &statb);
	shdblks((statb.st_size+(TBLOKSIZ-1))/TBLOKSIZ);

	do
		twrite();
	while(dread());
}

tread()
{
	register i;

	i = read(fio, tapeb, TBLOKSIZ);

	if(i == 0 || i == TBLOKSIZ)
		return(i);

	trderr();
	return(1);
}

trderr()
{
	register *p;

	printf("Dtp: tape read error\n");

	if(!iflag)
		done();

	for(p = (int *)tapeb; p < (int *)tapeb + (sizeof tapeb/sizeof(int)); *p++ = 0)
		;
}

dread()
{
	register i;

	if((i = read(dirfd, tapeb, TBLOKSIZ)) < 0
		|| i & (DIRSIZE-1) )

		drderr();

	return(i);
}

eread()
{
	register i;

	if((i = read(dirfd, dbuf, DIRSIZE)) < 0 || i &~ DIRSIZE)

		drderr();

	return(i);
}

drderr()
{
	printf("Dtp: directory file read error\n");
	done();
}

twrite()
{
	nused++;

	if(write(fio, tapeb, TBLOKSIZ) != TBLOKSIZ)

		twrerr();
}
twrerr()
{
	printf("Dtp: tape write error\n");
	done();
}

dwrite()
{
	if(write(dirfd, tapeb, TBLOKSIZ) != TBLOKSIZ)

		dwrerr();
}

dwrerr()
{
	printf("Dtp: directory file write error\n");
	done();
}

ewrite(f)
{
	register *p, *q, i;

	if(f)
		dirlast = 0;

	if((char*)(q = ebufpt) >= (char *)tapeb + TBLOKSIZ) {

		if(write(dirfd, tapeb, TBLOKSIZ) != TBLOKSIZ)

			dwrerr();

		q = (int *)tapeb;
	}

	p = (int *)dbuf;

	for(i = 0; i < DIRSIZE; i += sizeof(int))
		*q++ = *p++;

	ebufpt = q;
}

verify(c)
register c;
{
	register ch;

	if(qflag || vflag) {

		printf("%c %s%s", c, cpathname, qflag ? " ? " : "\n");

		if(qflag) {
			fflush(stdout);
			c = ch = getchar();
			while(ch != '\n')
				ch = getchar();
			if(c == 'x')
				done();
			return(c == 'y');
		}
	}
	return(1);
}

getfiles()
{
	register char *p, *q;
	register i;

	if(narg == 2) {
		cpathname[0] = '.'; cpathname[1] = 0;
		callout();
	}

	while(narg-- > 2) {
		for(p = *parg++, q = cpathname; *q++ = *p++; );
		callout();
		dirlast = -1;
	}

	if((i = (ebufpt - (int *)tapeb)*sizeof(int)) > 0)
		if(write(dirfd, tapeb, i) != i)
			dwrerr();
}

expand()
{
	register char *p, *q;
	register dfd, i;
	register char *r;
	struct {
		short inumb;
		char dname[16];
	} catlb;

	if((dfd = open(cpathname, 0)) < 0)
		fserr();

	while((i = read(dfd, &catlb, 16)) != 0) {

		if(i < 0)
			fserr();

		if(catlb.inumb == 0)
			continue;

		if(!dflag) {
			if(catlb.dname[0] == '.')
				continue;
		} else {
			if(catlb.dname[0] == '.' &&
				(catlb.dname[1] == 0 ||
					catlb.dname[1] == '.' && catlb.dname[2] == 0
				)  )
					continue;
		}

		catlb.dname[14] = '\0';			/* sentinel */
		for(p = tmpdirname, q = catlb.dname; *p; p++, q++)
			if(*p != *q)
				break;
		if(!(*p || *q))
			continue;

		for(p = cpathname; *p; p++) ;
		r = p;
		if(p[-1] != '/')
			*p++ = '/';
		for(q = catlb.dname; *p++ = *q++; ) ;
		callout();
		*r = 0;
	}
	close(dfd);
}

callout()
{
	register i;

	if(stat(cpathname, &statb) < 0)
		fserr();

	if (sflag && seltime < statb.st_ctime)
		if((statb.st_mode&S_IFMT) != S_IFDIR)
			return;

	if(!verify('a'))
		return;

	nfiles++;

	scsize(0);
	scuid(statb.st_uid);
	scgid(statb.st_gid);
	sctime(statb.st_mtime);
	sctapea(tapad);
	i = statb.st_mode;
	scmode(i);
	switch( i & S_IFMT ) {
	case S_IFREG:
	case S_IFDIR:
	case S_IFCHR:
	case S_IFBLK:
		i &= IFMT;
		break;
	default:
		printf("Can't dump funny file type\n");
		return;
	}

	if((i&IFMT) == IFILE) {
		scsize(i=statb.st_size);
		tapad += (i + 511) >> 9;
		ewrite(1);
		return;
	}
	if((i&IFMT) != IFDIR) {
		scmajmin(statb.st_rdev);	/* maj/min dev code */
		ewrite(1);
		return;
	}
	if(dirlast <= 0 && ebufpt > (int *)tapeb + DIRUPLIM/sizeof(int)) {
		i = (ebufpt - (int *)tapeb) * sizeof(int);
		if(write(dirfd, tapeb, i) != i)
			dwrerr();
		ebufpt = (int *)tapeb;
	}

	ewrite(0);
	dirlast++;
	expand();
	if(dirlast != 0) {
		nfiles--;
		i = qflag, qflag = 0;
		verify('d');
		qflag = i;
	}
}

gettape(fn)
int (*fn)();
{
	register char *p, *q;
	register i,n,c;

	do {
		if((n = nfiles) > 0) {
			lseek(dirfd, (long)DIRSIZE, 0);
			i = 0;
			while(eread() && n-- > 0) {
				if(rnarg > 2) {
					p = cpathname;
					q = *parg;
					while((c = *p) && *q==c)
						p++, q++;
					if(c && c != '/')
						continue;
					if((c = *q) && c != '/')
						continue;
				}
				(*fn)();
				i++;
			}
			if(i == 0 && rnarg > 2)
				printf("Dtp: %s not found\n", *parg);
		}
		parg++;
	} while(--narg > 2);
}

int bufsiz, fsiz;
chr *bufpt;

make()
{
	register i, ffd;
	bufpt = tapeb;
	bufsiz = TBLOKSIZ;

	wrdir();
	lseek(dirfd, (long)DIRSIZE, 0);

	while(eread()) {
		if((gcmode&IFMT)!=IFILE)
			continue;
		if((fsiz=gcsize)==0) {
			stat(cpathname, &statb);
			if(statb.st_size!=0)
				phserr('B');
			continue;
		}
		if((ffd=open(cpathname,0))<0)
			phserr('O');
		else {

			while((i = read(ffd, bufpt, bufsiz)) != 0) {

				if(i < 0) {
					phserr('R');
					break;
				}
				bufpt += i;
				bufsiz -= i;

				if((fsiz-=i) < 0) {
					phserr('B');
					i = -1;
					break;
				}
				if(bufsiz == 0) {
					twrite();
					bufpt = tapeb;
					bufsiz = TBLOKSIZ;
				}
			}
			close(ffd);

			if(i == 0 && fsiz != 0)
				phserr('S');
		}

		while(bufsiz & 511) {
			bufsiz--;
			*bufpt++ = 0;
		}
		if(bufsiz==0) {
			twrite();
			bufpt = tapeb;
			bufsiz = TBLOKSIZ;
		}
	}
	if(bufsiz != TBLOKSIZ)
		twrite();
}

taboc()
{
	register c, m;
	register *t;
	time_t tvec;
	int *localtime();

	if(vflag) {

		switch((m = gcmode)&IFMT) {
			case IFILE: c = '-'; break;
			case IFDIR: c = 'd'; break;
			case IFBLK: c = 'b'; break;
			case IFCHR: c = 'c'; break;
		}
		putchar(c);

		pmode(m>>6, m&SETUID ? 's' : 0);
		pmode(m>>3, m&SETGID ? 's' : 0);
		pmode(m, 0);

		putchar(m&STICKY ? 't' : ' ');

		printf(" %3d %3d ", gcuid, gcgid);
		printf("%6d ", gctapea);

		switch(m&IFMT) {
			case IFILE: printf("%10d", gcsize); break;
			case IFBLK:
			case IFCHR: printf("   %3d,%3d", gcmaj, gcmin);
					break;
			case IFDIR: printf("          "); break;
		}

		tvec = gctime;
		t = localtime(&tvec);
		printf(" %02d/%02d/%02d %02d:%02d ", t[5],t[4]+1,t[3], t[2],t[1]);
	}
	printf("%s\n", cpathname);
}

pmode(m, c)
register m;
{
	putchar(m&RPERM ? 'r' : '-');
	putchar(m&WPERM ? 'w' : '-');
	if(c)
		putchar(c);
	else
		putchar(m&XPERM ? 'x' : '-');
}

xunlnk()
{
	if(stat(cpathname, &statb) >= 0  &&  (statb.st_mode&S_IFMT) != S_IFDIR)
		unlink(cpathname);
}

xtract()
{
	register chr *p;
	register m, i;
	extern errno;
	time_t tvec[2];

	if(((m=gcmode)&IFMT) != IFILE && cflag) {

		register chr *q, *s;

		m &= ~0100000;
		if((m&IFMT) == IFDIR) {
			i = 0;
			m &= ~IFMT;
			m |= S_IFDIR;
		} else {
			i = gcmaj << 8 | gcmin;
			if ((m & IFMT) == IFCHR) {
				m &= ~IFMT;
				m |= S_IFCHR;
			} else {
				m &= ~IFMT;
				m |= S_IFBLK;
			}
		}
		if(!verify('c'))
			return;
		xunlnk();

		if(mknod(cpathname, m&0160777, i) < 0) {
			if(errno != EEXIST || (m&S_IFMT)!=S_IFDIR) {
				crterr(0);
				return;
			}
			stat(cpathname, &statb);
			if((statb.st_mode&S_IFMT) != S_IFDIR) {
				crterr(0);
				return;
			}
		}
		if ((m & S_IFMT) == S_IFDIR) {
			p = (chr *)cpathname;
			s = p+1;
			q = namewk;
			while(*q++ = *p)
				if(*p++ == '/')
					s = p;
			q[-1] = '/';
			*q++ = '.';
			*q = 0;
			link(cpathname, namewk);
			*q++ = '.';
			*q = 0;
			i = *--s;
			*s = 0;
			link(cpathname, namewk);
			*s = i;
		}
	} else {

		register siz, ofd;

		if ((m&IFMT) != IFILE)
			return;
		if(!verify('x'))
			return;
		i = tapad;
		siz = gctapea;
		while((i = (i+TBLOKING)&~(TBLOKING-1)) <= siz) {
			tread();
			tapad = i;
		}
		xunlnk();
		if((ofd = creat(cpathname,gcmode))<0) {
			crterr(1);
			return;
		}
		i = (siz & (TBLOKING-1)) << 9;
		siz = gcsize;
		p = i + tapeb;
		i = TBLOKSIZ-i;

		while(siz>0) {
			if(i > siz)
				i = siz;
			if(write(ofd,p,i) != i) {
				crterr(1);
				close(ofd);
				return;
			}
			if((siz -= i) > 0) {
				tread();
				p = tapeb;
				i = TBLOKSIZ;
				tapad += TBLOKING;
			}
		}
		close(ofd);
		chown(cpathname, gcuid, gcgid);
		tvec[1] = gctime;
		tvec[0] = time((time_t *)0);	/* access time not on tape */
		utime(cpathname, tvec);
	}
}

crterr(f)
{
/*
 *	I must confess to not quite understanding the use of
 *	'utime' in this routine
 */
	static int tvec[2] = {0, 0};

	if(f)
		utime(cpathname, tvec);

	printf("Dtp: %s -- create/write error\n", cpathname);
}

fserr()
{
	printf("Dtp: cannot open %s\n", cpathname);
	done();
}

phserr(c)
{
	register s = bufsiz;
	register chr *p = bufpt;
	register f = fsiz;

	if(c=='B') {
		p += f;
		s -= f;
	} else
		while(f-- > 0) {
			if(s-- == 0) {
				twrite();
				p = tapeb;
				s = TBLOKSIZ-1;
			}
			*p++ = 0;
		}
	bufpt = p;
	bufsiz = s;

	printf("Dtp: phase error %c: %s\n", c, cpathname);
}
