#include	"mac.h"
#include	"mac.x"


getsym()
{
	register int i;
	register int j;
	register char *s;
	register char cc;


	switch (j = ccode(cc = *p++))  {

			/* space/tab field */
		case 0x03:
			i=1;
			while (*p  == ' ' || *p == '\t')  {
				i++;
				p++;
				}
			sym = SPA;
			mem = i;
			return;

			/* delimiter */
		case 0x04:
			sym = DEL;
			mem = ',';
			return;

			/* end-of-line */
		case 0x06:
			sym = EOL;
			mem = NUL;
			return;

			/* character constant */
		case 0x0a:
			sym = CON;
			i = 0;
			while ((cc = getch()) != '\'')  {
				/* machine dependant !! */
				i = (i<<8) | cc;
				}

			mem = i;
			return;

			/* literal */
		case 0x0b:
			sym = LPL;
			mem = '=';
			return;

			/* string "----" */
		case 0x09:
			s = clabel;
			i = 0;
			while ((cc = getch()) != '"')  {
				if (i++ > MAXOPR-2)
					break;
				*s++ = cc;
				}
			*s = '\0';
			sym = STR;
			mem = i;
			return;

			/* comment */
		case 0x07:
			while (*p != '\n')
				p++;
			sym = COM;
			mem = NUL;
			return;

			/* end-of-file */
		case 0x05:
			sym = EoF;
			mem = NUL;
			return;

			/* label */
		case 0x0c:		/* local label */
		case 0x01:
			s = clabel;
			*s++ = cc;
			i = 1;
			while ((j = ccode(cc = *p)) == 1  ||  j == 2)  {
				*s++ = cc;
				p++;
				i++;
				if (i > 8)
					break;
				}
			*s++ = '\0';

			/* check literal table */
			for (i=0; i<head.h_literals; i++)
				if (compar(literals+i*8, clabel))  {
					sym = LIT;
					mem = i;
					return;
					}

			sym = LBL;
			mem = hash(clabel);
			return;

			/* numeric */
		case 0x02:
			p--;
			sym = CON;
			mem = argnum();
			return;

			/* operator */
		case 0x08:
			sym = OPR;
			mem = chtab[cc] & 0xf;
			return;

			/* any other char */
		default:
			sym = CHR;
			mem = cc;
			return;

		}
}


ccode(cc)
register int cc;
{
	return((chtab[cc] >> 4) & 0xf);
}
