#include	"mac.h"
#include	"m.out.h"
#include	"mac.x"



/*
 *   Symbol table dump.
 */
sdump()
{
	register struct st *q, **s;
	register int n;
	register int obj;			/* object dump flag */
	register int dump;			/* code dump */

	dump = FALSE;
	obj = FALSE;
	if (OPTION('s'))
		dump = TRUE;			/* dump */
	if (OPTION('a'))  {
		obj = TRUE;
		out.ou_nseg = SYMBOLS;
		out.ou_start = 0;
		out.ou_length = globno * (8 + 3*INT);
		fwrite(&out, OUT, 1, mout);
		}

	q = symtab;
	if (q == NULL)
		return;

	if (dump)  {
		header();
		printf("NAME          VALUE\n\n");
		}

	while (q != NULL) {

		if (dump)  {
			if (!(q->s_mode & LITR))  {
				printf("%-8s      ", q->s_u.s_name);
				printl(pt.l_dw, q->s_value);
				printf("  \t");

				if (!(q->s_mode & REFR))
					if(q->s_mode & CLAS)
						printf("CLAS\t");
					else
						printf("NREF\t");
				else
					putchar('\t');
				if (q->s_mode & GLOB)
					printf("GLOB\t");
				else
					putchar('\t');
				if(q->s_mode & ABS)
					printf("ABS\t");
				else
					putchar('\t');
				if(q->s_mode & REL)
					printf("REL\t");
				else
					putchar('\t');
				putchar('\n');
				newpage();
				}

			}
		if (obj &&  q->s_mode & GLOB)
			/* write symbol table entry */
			fwrite(q, 8+3*INT, 1, mout);

		q = nextsym(q);
		}

	return;
}


/*
 *   Code dump to std. output
 *   and a.out generation.
 */
cdump()
{
	register int *len;
	register int *r;
	register int i;
	register int j;
	register int wdump;			/* page width */
	register int width;
	register struct ol *o;
	register struct rl *rp;


	/*
	 *   Decide upon dump format.
	 *   hexadecimal defaults.
	 */
	width = (head.h_bu_len + 3) / 4;

	if (OPTION('o'))
		width = (head.h_bu_len + 2) / 3;
	if (OPTION('b'))
		width = head.h_bu_len;

	wdump = 64 / (width + 1);


	if (OPTION('d'))
		header();

	/*
	 *   Search each location counter in turn
	 *   for code of any sort to generate.
	 */
	for (i=0; i<LCOUNT; i++)  {

		o = (locn[i].l_orgs);

		while( o != NUL) {

			if(o->ol_lcend <= o->ol_lcstart) {
				o = o->ol_next;
				continue;
			}

			r = o->ol_start;
			j = o->ol_lcend - o->ol_lcstart;

			if (OPTION('d'))  {
				len = r + j;			/* end of seg. pointer */
				printf("\n\nSEGMENT %2d  ", i);
				printf("LENGTH %5d  ", j);
				printf("START   0x%x\n\n", o->ol_lcstart);

				j = 0;
				while (r < len)  {
					if (j > wdump)  {
						putchar('\n');
						newpage();
						j = 0;
						}

					printl(width, *r);
					putchar(' ');		/* spacer */
					r++;
					j++;
					}

				putchar('\n');
				newpage();
				}

			/*
			 *   Check for a.out
			 */
			if (OPTION('a'))  {
				out.ou_nseg = i;
				out.ou_start = o->ol_lcstart;
				out.ou_length = o->ol_lcend - o->ol_lcstart;
				fwrite(&out, OUT, 1, mout);
				fwrite(o->ol_start, out.ou_length*INT, 1, mout);

			}
			o = o->ol_next;
			if(OPTION('r')) {
				out.ou_nseg = RELOCATION;
				out.ou_length = locn[i].l_rsize * (RL - INT);

				fwrite(&out, OUT, 1, mout);

				rp = locn[i].l_rlsts;
				while(rp != NUL) {
					/* change pointer to undef global
					   to its global no. */
					if((rp->rl_type & RLBL) == RLBL)
						rp->rl_u.rl_gln = (rp->rl_u.rl_glp)->s_value;
					fwrite(rp, RL - INT, 1, mout);
					rp = rp->rl_next;
				}
			}
		}
	}
	return;
}


/*
 *   Generate header lines for listing.
 */
header()
{
	register char *r;
	register int i;

	if (lpage || OPTION('c')) putchar('\f');

	putchar('\n');
	printf("\t\t\t\t\t\t\t\t\t\t\t\tPage %d\n", ++lpage);
	printf("MAC CROSS-ASSEMBLER   (%s)\n\n", head.h_mac);

	printf("\t\t\t%s\n\n\n", ctitle);

	lline = 7;

	return;
}


/*
 *   Check to see whether a new page is needed or not.
 */
newpage()
{
	register int title;
	register int i;

	if (intercode.i_flags & PS)  {
		i = intercode.i_op;
		if (i == 11 || i == 12)
			title = TRUE;
		}
	else
		title = FALSE;


	if (!lline && !title)
		header();

	lline = (lline + 1) % head.h_page;

	return;
}


/*
 *   Print source line.
 */
source()
{

	/* line number */
	printf("  %3d\t", nline);

	buf[listchs] = '\0';
	printf("%s", buf);

	return;
}

mouthdr() {

	if (OPTION('a'))  {
		/*
		 *   Write a.out header
		 */
		aout.ao_mword = head.h_macmword;
		aout.ao_bu_len = head.h_bu_len;
		aout.ao_startad = startad;
		fwrite(&aout, AOUT, 1, mout);
		}

}
