#include	"mac.h"
#include	"mac.x"


/*
 *   Define constant handlers.
 */
pedc1()
{
	pedc(0);
	return;
}

pedc2()
{
	pedc(1);
	return;
}

pedc3()
{
	pedc(2);
	return;
}

pedc4()
{
	pedc(3);
	return;
}

pedc(n)
register int n;
{
	/*
	 *   Evaluate the expression (argument)
	 *   and stack it as arg 'a' for the
	 *   code formatter format().
	 */
	p = intercode.i_opr;
	oprstac[1] = expr();
	relstac[1] = reloc;

	format(&head.dctype[n], ERR);		/* format value in core */

						/* incr pc */
	locn[lcntr].l_value += (length = head.dctype[n].f_len);
	locn[lcntr].l_lop = 0;
	return;
}




/*
 *   Special dc.
 */
pedcs()
{
	register struct fd *form;
	register char *f;
	register int len;

	/*
	 *   Special dc format descr.
	 */
	form = &head.dctype[4];
	len  = head.dctype[4].f_len;

	f = intercode.i_opr;
	if (*f == '"')  {
		f++;
		length = 0;
		while (*f != '"')  {
			oprstac[1] = *f++;
			relstac[1] = ABS;
			format(form, ERR);
			length += len;
			}

		locn[lcntr].l_value += length;
		locn[lcntr].l_lop = 0;
		return;
		}

	p = intercode.i_opr;
	oprstac[1] = expr();
	relstac[1] = reloc;
	format(form, ERR);
	locn[lcntr].l_value += len;
	locn[lcntr].l_lop =  0;
	length = len;
	return;
}


/*
 *   Null routine - just return.
 */
penull()
{
	return;
}


/*
 *   Align location counter to an even multiple
 *   of the argument expression.
 */
pealign()
{
	register int v;
	register int l;

	p = intercode.i_opr;
	v = expr();
	v *= bu;
	if (v < 1)
		return;

	l = locn[lcntr].l_value;
	v = (l + v) % v;
	if (!v)				/* no align needed */
		return;

	/*
	 *   Increment pc and code assembly pointer
	 */
	locn[lcntr].l_value += v;
	locn[lcntr].l_next  += v;

	return;
}


/*
 *   Set location counter origin.
 */
peorg()
{
	register int offset;
	register int v;

	p = intercode.i_opr;
	v = expr();
	v *= bu;

	/*
	 * move down the origin chain
	 */

	if((locn[lcntr].l_currorg = (locn[lcntr].l_currorg)->ol_next)
		== NUL) {
		fprintf(stderr, "Origin chain is crap\n");
		abort();
	}

	locn[lcntr].l_next = (locn[lcntr].l_currorg)->ol_start;
	locn[lcntr].l_value = (locn[lcntr].l_currorg)->ol_lcstart;
	if(locn[lcntr].l_value != v) {
		fprintf(stderr, "Origin chain loc. cntr. mismatch\n");
		abort();
	}

	offset = ((locn[lcntr].l_currorg)->ol_lcend - (locn[lcntr].l_currorg)->ol_lcstart) * bu;


	locn[lcntr].l_lop = 2;
	return;
}


/*
 *   Set segment indicator.
 *   (already checked for validity)
 */
peseg()
{
	p = intercode.i_opr;
	lcntr = expr();

	return;
}


/*
 *   Define (n) basic addr. units of storage.
 */
peds()
{
	register int v;

	p = intercode.i_opr;
	v = expr();
	v *= bu;

	locn[lcntr].l_value += v;

	for(; v > 0; v--)
		*locn[lcntr].l_next++ = 0;

	locn[lcntr].l_lop = 0;

	return;
}


/*
 *   end:  Set eof flag
 */
peend()
{
	eof = TRUE;
	return;
}


/*
 *   Set title info.
 */
petitle()
{
	register char *r;
	register char *s;
	register int i;

	r = intercode.i_opr;
	if (*r != '"')  {
		synerr("title not a string");
		return;
		}

	/*
	 *   Copy string into title buffer
	 */
	r++;
	s = ctitle;
	while (*r != '"')
		*s++ = *r++;
	*s = '\0';

	return;
}

pelist() {
	liston = TRUE;
}

penlist() {
	liston = FALSE;
}

peincl() {
	register char *q, *r, *s;
	register int len;
	char *filenm;
	FILE *f;

	p = intercode.i_opr;
	if (*p == '"')  {
		p++;
		len = 0;
		q = r = p;
		while (*r++ != '"')
			len++;
		p = r;

	} else {
		synerr("string required");
		return;
	}
	filenm = s = getmem(len + 1);
	r--;	/* reverse over '"' */
	while ( q < r )
		*s++ = *q++;
	*s = '\0';

	if(OPTION('l'))
		if ((f = fopen(filenm, "r")) == NULL) {
			synerr("Can't open include file");
			return;
		}

	if(inclevel >= MAXINCL) {
		synerr("Includes nested too deep");
		return;
	}

	inclstk[inclevel].inc_fil = src;
	inclstk[inclevel].inc_name = currfile;
	inclstk[inclevel].inc_list = liston;
	inclstk[inclevel++].inc_line = nline;

	src = f;
	currfile = filenm;
	/* nline cannot be reset until the line has been listed */
	return;
}
