#include	"mac.h"
#include	"mac.x"


int	next;			/* next state in the automaton */
char	*opr;			/* pointer to temp code */

pass1()
{
	register struct fd *f;		/* fmt descr */
	register int sret;		/* success return */
	register int fret;		/* failure return */
	register int s;
	register int i;
	register int len;
	register struct oc *r;		/* opcode table ptr */
	struct os *os;
	int	itlen;			/* length of intercode needed to
					 * be written out
					 */


	eof = FALSE;
	newline();			/* general initialisation */

	/*
	 *   Start the automaton.  Once it is going, -
	 *   it keeps itself going until end-of-input.
	 */
	while (!eof)  {


		s = parse[next].tb_sym;


		/*
		 *   If no match or sym != MCH (always match)
		 *   proceed to next case in parser table.
		 */
		if (sym != (s < 0  ?  -s : s)  &&  s != MCH)  {
			next++;
			continue;
			}

		/*
		 * A special match is applied here. If the symbol to match
		 * is a label, check if a classed label is wanted. MATCH
		 * if the symbol's class matches the required class
		 */

		if (sym == LBL && parse[next].tb_act == CLBL )
			printf("%s class: %04x required: %04x\n",
clabel, lscan(clabel, LKP, mem, NUL, NUL)->s_class, parse[next].tb_mem);
		if (sym == LBL && parse[next].tb_act == CLBL &&
			(lscan(clabel, LKP, mem, NUL, NUL)->s_class &
			parse[next].tb_mem) == 0) {
				next++;
				continue;
		}

		/*
		 *   Have a sym match.
		 *   If sym < 0 this implies that the member
		 *   must be checked as well !.
		 *   Failure to match can occur here as well.
		 */
		if (s < 0  &&  mem != parse[next].tb_mem)  {
			next++;
			continue;
			}

		/*
		 *   Sym (and mem) match -
		 *   perform action specified.
		 */
		switch (parse[next].tb_act)  {


				/* no operation */
			case NOOP:
				break;


				/* add label tag */
			case ALBL:
				i = alocn(bu);
				i = (int)lscan(clabel, DEF, mem, i/bu, REL);
				if (i == ERR)  {
					newline();
					continue;
					}
				intercode.i_label = (struct st *)i;
				break;

				/* a label of a predefined class is required
				 * here. Precede the label by a class name
				 */

			case CLBL:
				i = (int)lscan(clabel, LKP, mem, NUL, NUL);
				*opr++ = '{';
				opr = num(parse[next].tb_mem, opr);
				*opr++ = '$';
				opr = num(i, opr);
				break;

				/* decode opcode value */
			case DOPV:
				i = pscan();		/* pseudo ? */
				if (i != ERR)  {
					intercode.i_flags = PS;
					intercode.i_op = i;
					fn = pradr[i];
					break;
					}

				i = oscan();		/* opcode ? */
				if (i == ERR)  {
					synerr("op not found");
					newline();
					continue;
					}

				intercode.i_flags = OP;
				intercode.i_op = i;
				break;


				/* out literal operand */
			case LITP:
				linkl(LKP);
				*opr++ = '=';
				break;


				/* out operand label */
			case OLBL:
				i = (int)lscan(clabel, LKP, mem, NUL, NUL);
				*opr++ = '$';
				opr = num(i, opr);
				break;


				/* out operand operator */
			case OOPR:
				*opr++ = oprtab[mem];
				break;


				/* out operand delimiter */
			case ODEL:
				*opr++ = ',';
				break;


				/* out operand constant */
			case OCON:
				*opr++ = '#';
				opr = num(mem, opr);
				break;


				/* out extra character */
			case OCHR:
				*opr++ = mem;
				break;


				/* out string in "'s */
			case OSTR:
				*opr++ = '"';
				for (i=0; i<mem; i++)
					*opr++ = clabel[i];
				*opr++ = '"';
				break;


				/* end pass 1 */
			case ENDP:
				warning("no end stmt");
				prend();
				return;


				/* select options */
			case SELC:
				for (i=0; i<4; i++)
					intercode.i_selc[i] = parse[next].tb_arg[i];
				next = parse[next].tb_next;
				continue;


				/* call expr parser */
			case EXPR:
				fret = next + 1;
				sret = parse[next].tb_next;
				next = 0;		/* start of expr */
				continue;


				/* good expr return */
			case RETN:
				next = sret;
				sret = NUL;
				continue;


				/* fail expr return */
			case GOTO:
				next = fret;
				fret = NUL;
				continue;


				/* input line error */
			case OERR:
				synerr("syntax error");
				*opr = '\0';
				if(opr >= &intercode.i_opr[MAXOPR]) {
					synerr("expression too long");
					exit(1);
					}
				itlen = IT - (&intercode.i_opr[MAXOPR] - opr)
					   + 1;
				fwrite(&itlen, INT, 1, intercd);
				fwrite(&intercode, itlen, 1, intercd);
				newline();
				continue;


				/* scan ok - write intercode */
			case OREC:
				if (intercode.i_flags & OP)  {
					r = &opcode[intercode.i_op];
					if (intercode.i_selc[0] & SELOPC)
						/* select opcode column */
						i = intercode.i_selc[2];
	
					else
						/* select default */
						i = 0;

					os = scanop(r, i);
	
					if (intercode.i_selc[0] & SELFMT)
						/* select new format */
						f = &memory[intercode.i_selc[3]];
	
					else
						/* select default */
						if(p != NULL)
							f = &memory[os->os_fmt];
						else
							f = &memory[0];

					intercode.i_op = (int)os;

					/* adjust instruction location */
					len = f->f_len;
					clocn(len);

					/* increment pc */
					locn[lcntr].l_value += f->f_len;
					}


				if (intercode.i_flags & PS)  {
					/* call pseudo routine */
					intercode.i_locn = locn[lcntr].l_value;
					(*fn)();
					}

				*opr = '\0';
				if(opr >= &intercode.i_opr[MAXOPR]) {
					synerr("expression too long");
					exit(1);
					}
				itlen = IT - (&intercode.i_opr[MAXOPR] - opr)
					   + 1;
				fwrite(&itlen, INT, 1, intercd);
				fwrite(&intercode, itlen, 1, intercd);

				newline();
				continue;



				/* bad action - fatal */
			default:
				synerr("pass 1 non-existant action");
				exit(1);

			}


		/*
		 *   Successful match - get new input symbol
		 *   and move to next automaton state.
		 */
		getsym();
		next = parse[next].tb_next;
		if(opr >= &intercode.i_opr[MAXOPR]) {
			synerr("expression too long");
			exit(1);
			}

		}

	/*
	 *   end of pass 1
	 */
}


newline()
{
	register char *r;
	register int i;

	if (eof)
		return;

	getlin();
	getsym();

	nline++;
	intercode.i_label = (struct st *)ERR; intercode.i_op = ERR;
	intercode.i_flags = NUL;
	intercode.i_selc[0] = NUL;		/* no actions */
	opr = r = &intercode.i_opr[0];
	for (i=0; i<32; i++)
		/* clear intercode argument buffer */
		*r++ = '\0';

	next = head.h_p_start;

	return;
}
/*
 *	adjust location to the next location modulo 'inc'
 *
 */
alocn(inc)
register int inc;
{
	register int i;
	i = locn[lcntr].l_value;
	i = ((i+inc-1)/inc)*inc;
	locn[lcntr].l_value = intercode.i_locn = i;
	return i;
}
/*
 *	adjust instruction location
 *		- to commence on a specified byte multiple
 *		- if ibx set -  not to overlap an address boundary
 */
clocn(len)
register int len;
{
	register int i,j;

	/*
	 * if adjusted to an address boundary for a label
	 */
	if (intercode.i_label != (struct st *)ERR) return;
	i =alocn(ib);

	/*
	 * if addresses larger than instructions
	 * & instructions cannot overlap words
	 */
	if (ibx) {
		j = (i/bu)*bu;
		if ((j != i) && (i+len > j+bu))
			locn[lcntr].l_value = intercode.i_locn = j+bu;
		}
 	return;
}
