#
/*
 * ti980.h: common declarations and defines for Texas Instruments 980B
 * special device.
*/

#define	TIDSOFF	0		/* offset for disk devices */
#define	TIMTOFF	8		/* offset for tape devices */
#define TILPOFF 13		/* offset for line printers */
#define	TIDTOFF 14		/* offset for data channel */
#define TISTOFF	15		/* offset for commands/status */


#define	TIADDR	(struct device *)0172460	/* address of 8 registers */

#define	GO	01		/* GO bit, interrupts 980B */
#define	TI_PHYS	0100		/* physical I/O bit */
#define TI_ACK	0200		/* issue next return bit */
#define	TI_IGN	040000		/* ignore data bit */


/*
 * commands
 */

#define	T_WRITE	0
#define	T_READ	1
#define	T_OPEN	2
#define	T_CLOSE	3
