#include <sys/param.h>
#include <sys/ino.h>
#include <sys/inode.h>
#include <sys/filsys.h>
#include <sys/dir.h>
#include <sys/seg.h>
#include <saio.h>


extern int cputype;

char module[] = "Boot";
char line[100];

main()
{
int i;
	segflag = 2;


	printf("\n%d%s\n", cputype, module);
	do {
		printf(": "); gets(line);
		i = open(line,0);
	} while (i < 0);


	copyunix(i);

}


copyunix(io)
register io;
{
register addr,s;
long phys;
long ovaddr;
unsigned	txtsiz,datsiz,bsssiz,ovsize;
int	magic;
unsigned ovsizes[8];
int i;


	lseek(io, (off_t)0, 0);
	magic = getw(io);
	txtsiz = getw(io);
	datsiz = getw(io);
	bsssiz = getw(io);


	switch (magic) {
	case 0411:
		if (cputype == 40) {
			printf("Can't load sep i/d prog's\n");
			exit(0);
		}
		setsep();	/* re-enable sep i/d */
		setseg(0);
		lseek(io, (long)(020+txtsiz), 0);

		for(addr=0; addr!=datsiz; addr+=2)  {
			mtpi(getw(io),addr);
		}

		clrseg(addr,bsssiz);

		phys = (long)datsiz + (long)bsssiz + 63L;
		phys =/ 64;
		setseg((int)phys);

		lseek(io, 020L, 0);

		for(addr=0; addr!=txtsiz; addr+=2) {
			mtpi(getw(io),addr);
		}
		return;
	case 0407:
		if (cputype != 40) {
			setseg(0);
			setnosep();
		}
		/*
		 * space over the header. We do this instead of seeking
		 * because the input might be a tape which doesn't know
		 * how to seek.
		 */
		getw(io); getw(io); getw(io); getw(io);
		phys = (long)txtsiz + (long)datsiz;
		for (addr = 0; addr != (int)phys; addr += 2)
			mtpi(getw(io),addr);
		clrseg(addr, bsssiz);
		return;

	case 0430:	/* overlayed text */
		if (cputype != 40) {
			setnosep();
		}
		/*
		 * check for consistency
		 */
		if (txtsiz < 017777) {
			printf("text segment too small (0%o)\n", txtsiz);
			exit(1);
		}
		if (txtsiz > 037777) {
			printf("text segment too big (0%o)\n", txtsiz);
			exit(1);
		}
		if (datsiz + bsssiz > 057777) {
			printf("data segment too big (0%o)\n", datsiz + bsssiz);
			exit(1);
		}

		lseek(io, (long) 020, 0);	/* skip to overlay header */
		for (i = 0, ovsize = 0; i < 8; i++) {
			ovsizes[i] = getw(io);
			ovsize += ovsizes[i];
		}
		ovsize -= ovsizes[0];
		if (ovsizes[0] > 017777) {
			printf("max overlay too big (0%o)\n", ovsizes[0]);
			exit(1);
		}
		ovsizes[0] = 0;
		/*
		 * load text segment at zero
		 */
		setseg(0);
		for (addr = 0; addr < txtsiz; addr +=2)
			mtpi(getw(io), addr);
		/*
		 * load data segment at 24Kb
		 */
		phys = 060000L;
		setseg((int)(phys/64));
		lseek(io, 040L + (long)txtsiz + (long)ovsize, 0);
		for (addr = 0; addr < datsiz; addr += 2)
			mtpi(getw(io), addr);
		/*
		 * clear bss
		 */
		clrseg(addr, bsssiz);
		phys += datsiz + bsssiz;
		phys = (phys + 077) & ~077;
		/*
		 * load the overlays after the bss
		 * except for overlay 1, which is loaded at 16Kb
		 */
		lseek(io, (long)(040+txtsiz), 0);
		ovaddr = phys;
		for (i = 1; i < 8; i++) {
			if (i == 1)
				setseg(040000/64);
			else {
				setseg((int)(phys/64));
				phys += ovsizes[i];
			}
			for (addr = 0; addr < ovsizes[i]; addr += 2)
				mtpi(getw(io), addr);
		}

		/*
		 * build the overlay address and descriptor
		 * tables for the kernel.
		 */
		setseg(0);
		addr = 0400;	/* overlay tables start here */
		for (i = 0; i < 8; i++) {
			if (i == 1)
				mtpi(040000/64, addr);
			else {
				mtpi((int)(ovaddr/64), addr);
				ovaddr += ovsizes[i];
			}
			addr += 2;
		}
		for (i = 0; i < 8; i++) {
			if (ovsizes[i] != 0)
				mtpi((((ovsizes[i]/64)-1)<<8) | RO, addr);
			else
				mtpi(0, addr);
			addr += 2;
		}
		mtpi((int)(phys/64), addr);	/* start of free memory */
		return;

	default:
		printf("Can't load %o files\n", magic);
		exit(1);
	}
}
