/*
 *	ss - system status
 *	like ps but human-readable
 */

#include <stdio.h>
#include <a.out.h>
#include <core.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/tty.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/text.h>
#include <pwd.h>

extern struct passwd *getpwuid();
extern struct passwd *getpwnam();
extern char *ttyname();

struct nlist nl[] = {
	{ "_proc" },
	{ "_swapdev" },
	{ "_swplo" },
	{ "" },
};

struct proc	proc[NPROC];

char *state[] = {
	"    ",
	"slp ",
	"wait",
	"RUN*",
	"idle",
	"zomb",
	"stpd",
};

struct	user u;
int	chkpid;
int	retcode=1;
int	lflg;
int	kflg;
int	xflg;
int	tflg = 1;
int	uflg;
int	pflg;
char	*tptr;
long	lseek();
char	*gettty();
char	*getptr();
char	*strncmp();
int	mem;
int	swmem;
int	swap;
daddr_t	swplo;

int	ndev;
struct devl {
	char	dname[DIRSIZ];
	dev_t	dev;
} devl[256];

char	*coref;

main(argc, argv)
char **argv;
{
	int i;
	char *ap;
	int uid, puid;
	struct proc *p;

	tptr = ttyname(2);
	tptr += 5;
	if (strncmp("tty", tptr, 3) == 0)
		tptr += 3;
	uid = getuid();
	if (argc > 1)
		ap = argv[1];
	else
		ap = "-a";
	if (*ap == '-') ap++;
	while (*ap) switch (*ap++) {

	case 'a':
		uflg = 0;
		tflg = 0;
		tptr = 0;
		break;

	case 't':
		tflg = 1;
		if (argv[2])
			tptr = argv[2];
		uflg = 0;
		if (*tptr == '?')
			xflg++;
		argc--; argv++;
		break;

	case 'x':
		xflg++;
		break;

	case '-':
		uflg++;
		uid = getuid();
		tflg = 0;
		tptr = 0;
		break;

	case 'l':
		lflg++;
		break;

	case 'k':
		kflg++;
		break;

	case 'p':
		pflg++;
		uflg = 0;
		tflg = 0;
		tptr = 0;
		chkpid = atoi(argv[2]);
		argc--; argv++;
		break;

	case 'u':
		uflg = 1;
		tflg = 0;
		tptr = 0;
		pflg = 0;
		uid = getpwnam(argv[2])->pw_uid;
		argc--; argv++;
		break;
	}

	if(chdir("/dev") < 0) {
		fprintf(stderr, "Can't change to /dev\n");
		exit(1);
	}
	nlist(argc>2? argv[2]:"/unix", nl);
	if (nl[0].n_type==0) {
		fprintf(stderr, "No namelist\n");
		exit(1);
	}
	coref = "/dev/mem";
	if(kflg)
		coref = "/usr/sys/core";
	if ((mem = open(coref, 0)) < 0) {
		fprintf(stderr, "No mem\n");
		exit(1);
	}
	swmem = open(coref, 0);
	/*
	 * read mem to find swap dev.
	 */
	lseek(mem, (long)nl[1].n_value, 0);
	read(mem, (char *)&nl[1].n_value, sizeof(nl[1].n_value));
	/*
	 * Find base of swap
	 */
	lseek(mem, (long)nl[2].n_value, 0);
	read(mem, (char *)&swplo, sizeof(swplo));
	/*
	 * Locate proc table
	 */
	lseek(mem, (long)nl[0].n_value, 0);
	getdev();
	if (!pflg) {
		if (!tflg) printf("TTY ");
		if (lflg) printf("PRI  SIZE STATE ");
		if (!uflg) printf("USER    ");
		printf("  PID COMMAND\n");
	}
	read(mem, (char *)proc, sizeof proc);
	for (p = proc; p < &proc[NPROC]; p++) {
		if (p->p_stat==0)
			continue;
		if (p->p_pgrp==0 && xflg==0 && p->p_uid==0)
			continue;
		puid = p->p_uid;
		if ((uid != puid && uflg) ||
		    (pflg && chkpid!=p->p_pid))
			continue;
		if(prcom(p)) {
			printf("\n");
			retcode=0;
		}
	}
	exit(retcode);
}

getdev()
{
#include <sys/stat.h>
	register FILE *df;
	struct stat sbuf;
	struct direct dbuf;

	if ((df = fopen("/dev", "r")) == NULL) {
		fprintf(stderr, "Can't open /dev\n");
		exit(1);
	}
	ndev = 0;
	while (fread((char *)&dbuf, sizeof(dbuf), 1, df) == 1) {
		if(dbuf.d_ino == 0)
			continue;
		if(stat(dbuf.d_name, &sbuf) < 0)
			continue;
		if ((sbuf.st_mode&S_IFMT) != S_IFCHR)
			continue;
		strcpy(devl[ndev].dname, dbuf.d_name);
		devl[ndev].dev = sbuf.st_rdev;
		ndev++;
	}
	fclose(df);
	if ((swap = open("/dev/swap", 0)) < 0) {
		fprintf(stderr, "Can't open /dev/swap\n");
		exit(1);
	}
}

long
round(a, b)
	long		a, b;
{
	long		w = ((a+b-1)/b)*b;

	return(w);
}

struct map {
	long	b1, e1; long f1;
	long	b2, e2; long f2;
};
struct map datmap;
int	file;
prcom(p)
struct proc *p;
{
	char abuf[512];
	long addr;
	register int *ip;
	register char *cp, *cp1;
	long tm;
	int c, nbad;
	register char *tp;
	long txtsiz, datsiz, stksiz;
	int septxt;
	int lw=(lflg?35:80);
	char **ap;

	if (p->p_flag&SLOAD) {
		addr = ctob((long)p->p_addr);
		file = swmem;
	} else {
		addr = (p->p_addr+swplo)<<9;
		file = swap;
	}
	lseek(file, addr, 0);
	if (read(file, (char *)&u, sizeof(u)) != sizeof(u))
		return(0);

	/* set up address maps for user pcs */
	txtsiz = ctob(u.u_tsize);
	datsiz = ctob(u.u_dsize);
	stksiz = ctob(u.u_ssize);
	septxt = u.u_sep;
	datmap.b1 = (septxt ? 0 : round(txtsiz,TXTRNDSIZ));
	datmap.e1 = datmap.b1+datsiz;
	datmap.f1 = ctob(USIZE)+addr;
	datmap.b2 = stackbas(stksiz);
	datmap.e2 = stacktop(stksiz);
	datmap.f2 = ctob(USIZE)+(datmap.e1-datmap.b1)+addr;

	if (u.u_ttyp == 0) u.u_ttyd = -1;
	tp = gettty(u.u_ttyd);
	if (tptr && strncmp(tptr, tp, 2))
		return(0);
	if (!tflg)
		printf("%-2.2s: ", tp);
	if (lflg) {
		printf("%3d", p->p_pri);
		if (p->p_textp)
			printf(" %2d+", tsize(p));
		else
			printf("    ");
		printf("%2d %c%-4.4s ", size(p->p_size),
			p->p_flag&SLOAD ? '*' : ' ',
			state[p->p_stat]);
	}
	if (!uflg)
		printf("%-8.8s",
			getpwuid(p->p_uid)->pw_name);
	printf("%5d", p->p_pid);
	if (p->p_stat == SZOMB) {
		printf(" (dead)");
		return(1);
	}
	if (p->p_pid == 0) {
		printf(" system scheduler");
		return(1);
	}
	addr += ctob((long)p->p_size) - 512;

	/* look for sh special */
	lseek(file, addr+512-sizeof(char **), 0);
	if (read(file, (char *)&ap, sizeof(char *)) != sizeof(char *))
		return(1);
	if (ap) {
		char b[82];
		char *bp = b;
		while((cp=getptr(ap++)) && cp && (bp<b+lw) ) {
			nbad = 0;
			while((c=getbyte(cp++)) && (bp<b+lw)) {
				if (c<' ' || c>'~') {
					if (nbad++>3)
						break;
					continue;
				}
				*bp++ = c;
			}
			*bp++ = ' ';
		}
		*bp++ = 0;
		printf(lflg?" %.30s":" %.60s", b);
		return(1);
	}

	lseek(file, addr, 0);
	if (read(file, abuf, sizeof(abuf)) != sizeof(abuf))
		return(1);
	for (ip = (int *)&abuf[512]-2; ip > (int *)abuf; ) {
		if (*--ip == -1 || *ip==0) {
			cp = (char *)(ip+1);
			if (*cp==0)
				cp++;
			nbad = 0;
			for (cp1 = cp; cp1 < &abuf[512]; cp1++) {
				c = *cp1&0177;
				if (c==0)
					*cp1 = ' ';
				else if (c < ' ' || c > 0176) {
					if (++nbad >= 5) {
						*cp1++ = ' ';
						break;
					}
					*cp1 = '?';
				} else if (c=='=') {
					*cp1 = 0;
					while (cp1>cp && *--cp1!=' ')
						*cp1 = 0;
					break;
				}
			}
			while (*--cp1==' ')
				*cp1 = 0;
			printf(lflg?" %.30s":" %.60s", cp);
			return(1);
		}
	}
	return(1);
}

char *
gettty(td)
{
	register i;
	register char *p;

	if (td == -1)
		return("?");
	for (i=0; i<ndev; i++) {
		if (devl[i].dev == td) {
			p = devl[i].dname;
			if (p[0]=='t' && p[1]=='t' && p[2]=='y')
				p += 3;
			return(p);
		}
	}
	return("?");
}

char *
getptr(adr)
char **adr;
{
	char *ptr;
	register char *p, *pa;
	register i;

	ptr = 0;
	pa = (char *)adr;
	p = (char *)&ptr;
	for (i=0; i<sizeof(ptr); i++)
		*p++ = getbyte(pa++);
	return(ptr);
}

getbyte(adr)
char *adr;
{
	register struct map *amap = &datmap;
	char b;
	long saddr;

	if(!within(adr, amap->b1, amap->e1)) {
		if(within(adr, amap->b2, amap->e2)) {
			saddr = (unsigned)adr + amap->f2 - amap->b2;
		} else
			return(0);
	} else
		saddr = (unsigned)adr + amap->f1 - amap->b1;
	if(lseek(file, saddr, 0)==-1
		   || read(file, &b, 1)<1) {
		return(0);
	}
	return((unsigned)b);
}


within(adr,lbd,ubd)
char *adr;
long lbd, ubd;
{
	return((unsigned)adr>=lbd && (unsigned)adr<ubd);
}

size(x)
{
	return((ctob(x) + 2047) / 2048);
}

struct texts {
	struct text *tp;
	int siz;
};
struct texts texts[NTEXT];

tsize(p)
struct proc *p;
{
	struct texts *t;
	struct text txt;

	for (t = texts; t->tp; t++)
		if (t->tp == p->p_textp)
			return(t->siz);
	lseek(mem, (long)p->p_textp, 0);
	read(mem, (char *)&txt, sizeof txt);
	t->tp = p->p_textp;
	t->siz = size(txt.x_size);
	return(t->siz);
}
