/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

/*
**	Shell program for a "once_only" invocation of a net daemon.
**
**	Assumes that login name is that of host to be netted.
**
**	SETUID => ROOT
*/

#ifndef	lint
static char	sccsid[]	= "@(#)shell.c	1.17 85/07/20";
#endif	lint

#include	"global.h"
#include	"debug.h"

#include	"Passwd.h"
#include	"state.h"

#include	"caller.h"

#if	CSIRONET
#include	<sys/ioctl.h>

char	Stopmsg[]	= "EI\004";
#endif	CSIRONET


char *	Name;
int	Traceflag;

VarArgs	ExecArgs	=
{
	2,
	NNDAEMON,	/* Default node-node daemon name */
	"-BF"		/* Batch mode */
};

char	NN2shell[]	= NN2SHELL;

extern char *	ttyname();




main(argc, argv)
	int	argc;
	char *	argv[];
{
	char *	startmsg;
	int	stmsglen;
	bool	nogo;
	Passwd	remote;
	char *	node;
	char *	login;
	char *	getlogin();

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	if ( *Name == '-' )
		Name++;

	if ( (node = strrchr(NN2shell, '/')) != NULLSTR )
		node++;
	else
		node = NN2shell;

	Report3("name \"%s\", nn2shell \"%s\"", Name, node);

	if ( strcmp(Name, node) == STREQUAL )
	{
		startmsg = START2MSG;
		ARG(&ExecArgs, 0) = NN2DAEMON;
	}
	else
		startmsg = STARTMSG;

	if ( (login = getlogin()) == NULLSTR )
	{
		if ( !GetUser(&remote, getuid()) )
			Error("passwd file error \"%s\"", remote.P_error);
		login = remote.P_name;
	}

	if ( (node = ttyname(1)) != NULLSTR )
		(void)chmod(node, 0600);	/* Turn off "write" permission */

#	ifdef	NICEDAEMON
	(void)nice(NICEDAEMON);
#	endif	NICEDAEMON

	(void)setgid(ACSNETGID);
	(void)setuid(ACSNETUID);

	if ( (node = FindAlias(login)) == NULLSTR )
		node = login;

	NEXTARG(&ExecArgs) = node;

	SetRaw(2, 0, 1, 1, true);	/* To ignore signals */

	if ( DaemonActive(".", false) )
	{
		startmsg = NOGOMSG;
		nogo = true;
	}
	else
		nogo = false;

	stmsglen= strlen(startmsg);
	startmsg[stmsglen] = '\n';
	(void)write(2, startmsg, stmsglen+1);

	if ( nogo )
	{
		(void)sleep(5);
		return 0;
	}

#	if	CSIRONET
	(void)write(2, Stopmsg, sizeof Stopmsg - 1);
	(void)write(2, Stopmsg, sizeof Stopmsg - 1);
	(void)sleep(2);
	(void)ioctl(2, XTIOCRAW, 0);
#	endif	CSIRONET

	(void)execve(ARG(&ExecArgs, 0), &ARG(&ExecArgs, 0), StripEnv());
	Syserror(ARG(&ExecArgs, 0));
	return 1;
}



void
finish(error)
	int	error;
{
	exit(error);
}
